/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SVX_XBTMPIT_HXX
#define INCLUDED_SVX_XBTMPIT_HXX

#include <svx/svxdllapi.h>
#include <svx/xit.hxx>
#include <svtools/grfmgr.hxx>

class SdrModel;
class BitmapColor;


// helper to construct historical 8x8 bitmaps with two colors

Bitmap SVX_DLLPUBLIC createHistorical8x8FromArray(const sal_uInt16* pArray, Color aColorPix, Color aColorBack);
bool SVX_DLLPUBLIC isHistorical8x8(const BitmapEx& rBitmapEx, BitmapColor& o_rBack, BitmapColor& o_rFront);


// class XFillBitmapItem

class SVX_DLLPUBLIC XFillBitmapItem : public NameOrIndex
{
private:
    GraphicObject   maGraphicObject;

public:
            TYPEINFO_OVERRIDE();
            XFillBitmapItem() : NameOrIndex(XATTR_FILLBITMAP, -1 ) {}
            XFillBitmapItem(const OUString& rName, const GraphicObject& rGraphicObject);
            XFillBitmapItem(SfxItemPool* pPool, const GraphicObject& rGraphicObject);
            XFillBitmapItem( const XFillBitmapItem& rItem );
            XFillBitmapItem( SvStream& rIn, sal_uInt16 nVer = 0 );

    virtual bool            operator==( const SfxPoolItem& rItem ) const SAL_OVERRIDE;
    virtual SfxPoolItem*    Clone( SfxItemPool* pPool = 0 ) const SAL_OVERRIDE;
    virtual SfxPoolItem*    Create( SvStream& rIn, sal_uInt16 nVer ) const SAL_OVERRIDE;
    virtual SvStream&       Store( SvStream& rOut, sal_uInt16 nItemVersion  ) const SAL_OVERRIDE;
    virtual sal_uInt16      GetVersion( sal_uInt16 nFileFormatVersion ) const SAL_OVERRIDE;

    virtual bool            QueryValue( com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) const SAL_OVERRIDE;
    virtual bool            PutValue( const com::sun::star::uno::Any& rVal, sal_uInt8 nMemberId = 0 ) SAL_OVERRIDE;

    virtual bool GetPresentation( SfxItemPresentation ePres,
                                    SfxMapUnit eCoreMetric,
                                    SfxMapUnit ePresMetric,
                                    OUString &rText, const IntlWrapper * = 0 ) const SAL_OVERRIDE;

    const GraphicObject& GetGraphicObject() const { return maGraphicObject;}
    void SetGraphicObject(const GraphicObject& rGraphicObject);

    static bool CompareValueFunc( const NameOrIndex* p1, const NameOrIndex* p2 );
    XFillBitmapItem* checkForUniqueItem( SdrModel* pModel ) const;

    virtual void dumpAsXml(struct _xmlTextWriter* pWriter) const SAL_OVERRIDE;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
