/**
 * SECTION:object-cache
 * @short_description: A generic abstract cache for sets of objects. This can be used by subclasses to implement caching of homogeneous sets of objects. Subclasses simply have to implement serialisation and deserialisation of the objects to and from <link linkend="GVariant"><type>GVariant</type></link>s.
 * 
 * <para>It&apos;s intended that this class be used for providing caching layers for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s, for example.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_OBJECT_CACHE:
 * 
 * The type for <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link>.
 */
/**
 * folks_object_cache_load_objects:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @cancellable: (in) (allow-none): &nbsp;.  <para>A <link linkend="GCancellable"><type>GCancellable</type></link> for the operation, or <code>null</code>. </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Load a set of objects from the cache and return them as a new set. If the cache file doesn&apos;t exist, <code>null</code> will be returned. An empty set will be returned if the cache file existed but was empty (i.e. was stored with an empty set originally).
 * 
 * <para>Loading the objects can be cancelled using <code>cancellable</code>. If it is, <code>null</code> will be returned.</para><para>If any errors are encountered while loading the objects, warnings will be logged as appropriate and <code>null</code> will be returned.</para><para>This method is safe to call multiple times concurrently.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-load-objects-finish"><function>folks_object_cache_load_objects_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_object_cache_load_objects_finish:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Load a set of objects from the cache and return them as a new set. If the cache file doesn&apos;t exist, <code>null</code> will be returned. An empty set will be returned if the cache file existed but was empty (i.e. was stored with an empty set originally).
 * 
 * <para>Loading the objects can be cancelled using <code>cancellable</code>. If it is, <code>null</code> will be returned.</para><para>If any errors are encountered while loading the objects, warnings will be logged as appropriate and <code>null</code> will be returned.</para><para>This method is safe to call multiple times concurrently.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-load-objects"><function>folks_object_cache_load_objects()</function></link>
 * 
 * Returns: <para>A set of objects from the cache, or <code>null</code>. </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_object_cache_store_objects:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @objects: (in): &nbsp;.  <para>A set of objects to store. This may be empty, but may not be <code>null</code>. </para>
 * @cancellable: (in) (allow-none): &nbsp;.  <para>A <link linkend="GCancellable"><type>GCancellable</type></link> for the operation, or <code>null</code>. </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Store a set of objects to the cache file, overwriting any existing set of objects in the cache, or creating the cache file from scratch if it didn&apos;t previously exist.
 * 
 * <para>Storing the objects can be cancelled using <code>cancellable</code>. If it is, the cache will be left in a consistent state, but may be storing the old set of objects or the new set.</para><para>This method is safe to call multiple times concurrently.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-store-objects-finish"><function>folks_object_cache_store_objects_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_object_cache_store_objects_finish:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Store a set of objects to the cache file, overwriting any existing set of objects in the cache, or creating the cache file from scratch if it didn&apos;t previously exist.
 * 
 * <para>Storing the objects can be cancelled using <code>cancellable</code>. If it is, the cache will be left in a consistent state, but may be storing the old set of objects or the new set.</para><para>This method is safe to call multiple times concurrently.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-store-objects"><function>folks_object_cache_store_objects()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_object_cache_clear_cache:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Clear this cache object, deleting its backing file.
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-clear-cache-finish"><function>folks_object_cache_clear_cache_finish()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * folks_object_cache_clear_cache_finish:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Clear this cache object, deleting its backing file.
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-object-cache-clear-cache"><function>folks_object_cache_clear_cache()</function></link>
 *
 * Since: 0.6.0
 */
/**
 * FolksObjectCache:type-id:
 * 
 * A string identifying the type of object being cached.
 * 
 * <para>This has to be suitable for use as a directory name; i.e. lower case, hyphen-separated tokens.</para>
 *
 * Since: 0.6.6
 */
/**
 * folks_object_cache_get_type_id:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksObjectCache--type-id"><type>"type-id"</type></link> property.
 * 
 * A string identifying the type of object being cached.
 * 
 * <para>This has to be suitable for use as a directory name; i.e. lower case, hyphen-separated tokens.</para>
 * 
 * Returns: the value of the <link linkend="FolksObjectCache--type-id"><type>"type-id"</type></link> property
 *
 * Since: 0.6.6
 */
/**
 * FolksObjectCache:id:
 * 
 * A string identifying the particular cache instance.
 * 
 * <para>This will form the file name of the cache file, but will be escaped beforehand, so can be an arbitrary non-empty string.</para>
 *
 * Since: 0.6.6
 */
/**
 * folks_object_cache_get_id:
 * @self: the <link linkend="FolksObjectCache"><type>FolksObjectCache</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksObjectCache--id"><type>"id"</type></link> property.
 * 
 * A string identifying the particular cache instance.
 * 
 * <para>This will form the file name of the cache file, but will be escaped beforehand, so can be an arbitrary non-empty string.</para>
 * 
 * Returns: the value of the <link linkend="FolksObjectCache--id"><type>"id"</type></link> property
 *
 * Since: 0.6.6
 */
/**
 * FolksObjectCache:
 * 
 * A generic abstract cache for sets of objects. This can be used by subclasses to implement caching of homogeneous sets of objects. Subclasses simply have to implement serialisation and deserialisation of the objects to and from <link linkend="GVariant"><type>GVariant</type></link>s.
 * 
 * <para>It&apos;s intended that this class be used for providing caching layers for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s, for example.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksObjectCacheClass:
 * @get_serialised_object_type: virtual method used internally
 * @get_serialised_object_version: virtual method used internally
 * @serialise_object: virtual method used internally
 * @deserialise_object: virtual method used internally
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-OBJECT-CACHE:CAPS"><literal>FOLKS_TYPE_OBJECT_CACHE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
