/**
 * SECTION:phone-details
 * @short_description: Object representing a phone number that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_PHONE_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksPhoneFieldDetails"><type>FolksPhoneFieldDetails</type></link>.
 */
/**
 * folks_phone_field_details_get_normalised:
 * @self: the <link linkend="FolksPhoneFieldDetails"><type>FolksPhoneFieldDetails</type></link> instance
 * 
 * Return this object&apos;s normalised phone number.
 * 
 * <para>Typical normalisations:</para><para>- <code>1-800-123-4567</code> → <code>18001234567</code></para><para>- <code>+1-800-123-4567</code> → <code>+18001234567</code></para><para>- <code>+1-800-123-4567P123</code> → <code>+18001234567P123</code></para>
 * 
 * Returns: <para>the normalised form of <code>number</code> </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_phone_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, which should be a non-empty phone number (no particular format is mandated) </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new PhoneFieldDetails.
 * 
 * Returns: <para>a new PhoneFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPhoneFieldDetails:
 * 
 * Object representing a phone number that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPhoneFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-PHONE-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_PHONE_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_phone_details_change_phone_numbers:
 * @self: the <link linkend="FolksPhoneDetails"><type>FolksPhoneDetails</type></link> instance
 * @phone_numbers: (in): &nbsp;.  <para>the set of phone numbers </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s phone numbers.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> directly, as this method gives error notification and will only return once the phone numbers have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the phone numbers failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-phone-details-change-phone-numbers-finish"><function>folks_phone_details_change_phone_numbers_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_phone_details_change_phone_numbers_finish:
 * @self: the <link linkend="FolksPhoneDetails"><type>FolksPhoneDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s phone numbers.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> directly, as this method gives error notification and will only return once the phone numbers have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the phone numbers failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-phone-details-change-phone-numbers"><function>folks_phone_details_change_phone_numbers()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksPhoneDetails:phone-numbers:
 * 
 * The phone numbers of the contact.
 * 
 * <para>A list of phone numbers associated to the contact.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_phone_details_get_phone_numbers:
 * @self: the <link linkend="FolksPhoneDetails"><type>FolksPhoneDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> property.
 * 
 * The phone numbers of the contact.
 * 
 * <para>A list of phone numbers associated to the contact.</para>
 * 
 * Returns: the value of the <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_phone_details_set_phone_numbers:
 * @self: the <link linkend="FolksPhoneDetails"><type>FolksPhoneDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link> property to @value.
 * 
 * The phone numbers of the contact.
 * 
 * <para>A list of phone numbers associated to the contact.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPhoneDetails:
 * 
 * Interface for classes that can provide a phone number, such as <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 *
 * Since: 0.3.5
 */
/**
 * FolksPhoneDetailsIface:
 * @change_phone_numbers: virtual method called by <link linkend="folks-phone-details-change-phone-numbers"><function>folks_phone_details_change_phone_numbers()</function></link>
 * @change_phone_numbers_finish: asynchronous finish function for <structfield>change_phone_numbers</structfield>, called by <link linkend="folks-phone-details-change-phone-numbers"><function>folks_phone_details_change_phone_numbers()</function></link>
 * @get_phone_numbers: getter method for the abstract property <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link>
 * @set_phone_numbers: setter method for the abstract property <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksPhoneDetails"><type>FolksPhoneDetails</type></link> implementations.
 */
