/**
 * SECTION:utils
 * @short_description: Utility functions to simplify common patterns in Folks client code.
 * 
 * <para>These may be used by folks clients as well, and are part of folks&apos; supported stable API.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_UTILS:
 * 
 * The type for <link linkend="FolksUtils"><type>FolksUtils</type></link>.
 */
/**
 * folks_utils_new:
 * 
 * Create a new utilities object.
 * 
 * <para>This method is useless and should never be used. It will be removed in a future version in favour of making the Utils class into a nested namespace.</para>
 * 
 * Returns: <para>a new utilities object </para>
 *
 * Since: 0.6.0
 * Deprecated: 0.7.4: Replaced by #FolksUtils.
 */
/**
 * folks_utils_multi_map_str_str_equal:
 * @a: (in): &nbsp;.  <para>a multi-map to compare </para>
 * @b: (in): &nbsp;.  <para>another multi-map to compare </para>
 * 
 * Check whether two multi-maps of strings to strings are equal. This performs a deep check for equality, checking whether both maps are of the same size, and that each key maps to the same set of values in both maps.
 * 
 * Returns: <para><code>true</code> if the multi-maps are equal, <code>false</code> otherwise </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_utils_multi_map_str_afd_equal:
 * @a: (in): &nbsp;.  <para>a multi-map to compare </para>
 * @b: (in): &nbsp;.  <para>another multi-map to compare </para>
 * 
 * Check whether two multi-maps of strings to AbstractFieldDetails are equal.
 * 
 * <para>This performs a deep check for equality, checking whether both maps are of the same size, and that each key maps to the same set of values in both maps.</para>
 * 
 * Returns: <para><code>true</code> if the multi-maps are equal, <code>false</code> otherwise </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_utils_set_afd_equal:
 * @a: (in): &nbsp;.  <para>a set to compare </para>
 * @b: (in): &nbsp;.  <para>another set to compare </para>
 * 
 * Check whether a set of strings to AbstractFieldDetails are equal.
 * 
 * <para>This performs a deep check for equality, checking whether both sets are of the same size, and that each key maps to the same set of values in both maps.</para>
 * 
 * Returns: <para><code>true</code> if the sets are equal, <code>false</code> otherwise </para>
 *
 * Since: 0.6.0
 */
/**
 * folks_utils_set_string_afd_equal:
 * @a: (in): &nbsp;.  <para>a set to compare </para>
 * @b: (in): &nbsp;.  <para>another set to compare </para>
 * 
 * Check whether a set of AbstractFieldDetails with string values are equal.
 * 
 * <para>This performs a deep check for equality, checking whether both sets are of the same size, and that each set has the same values using string compaction instead of AbstractFieldDetails equal function</para>
 * 
 * Returns: <para><code>true</code> if the sets are equal, <code>false</code> otherwise </para>
 *
 * Since: 0.9.7
 */
/**
 * FolksUtils:
 * 
 * Utility functions to simplify common patterns in Folks client code.
 * 
 * <para>These may be used by folks clients as well, and are part of folks&apos; supported stable API.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksUtilsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-UTILS:CAPS"><literal>FOLKS_TYPE_UTILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
