/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.util.internal.TextUtil;

public class JvmPluginsHelper {
    public static Configuration addApiToSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration apiConfiguration = JvmPluginsHelper.maybeCreateInvisibleConfig(configurations, sourceSet.getApiConfigurationName(), "API dependencies for " + sourceSet + ".", false);
        Configuration compileOnlyApiConfiguration = JvmPluginsHelper.maybeCreateInvisibleConfig(configurations, sourceSet.getCompileOnlyApiConfigurationName(), "Compile only API dependencies for " + sourceSet + ".", false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration, compileOnlyApiConfiguration});
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileOnlyConfiguration = configurations.getByName(sourceSet.getCompileOnlyConfigurationName());
        compileOnlyConfiguration.extendsFrom(new Configuration[]{compileOnlyApiConfiguration});
        return apiConfiguration;
    }

    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        JvmPluginsHelper.configureForSourceSet(sourceSet, sourceDirectorySet, compile, target);
        JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, options, target);
    }

    private static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource((FileTree)sourceSet.getJava());
        ConfigurableFileCollection classpath = compile.getProject().getObjects().fileCollection();
        classpath.from(new Object[]{() -> sourceSet.getCompileClasspath().plus((FileCollection)target.files(new Object[]{sourceSet.getJava().getClassesDirectory()}))});
        compile.getConventionMapping().map("classpath", () -> classpath);
    }

    public static void configureAnnotationProcessorPath(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, CompileOptions options, Project target) {
        ConventionMapping conventionMapping = new DslObject((Object)options).getConventionMapping();
        conventionMapping.map("annotationProcessorPath", sourceSet::getAnnotationProcessorPath);
        String annotationProcessorGeneratedSourcesChildPath = "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        options.getGeneratedSourceOutputDirectory().convention(target.getLayout().getBuildDirectory().dir(annotationProcessorGeneratedSourcesChildPath));
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target, Provider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        TaskProvider taskProvider = (TaskProvider)Cast.uncheckedCast(compileTask);
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, sourceDirectorySet, target, (TaskProvider<? extends AbstractCompile>)taskProvider, options);
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target, TaskProvider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.getDestinationDirectory().convention(target.getLayout().getBuildDirectory().dir(sourceSetChildPath));
        DefaultSourceSetOutput sourceSetOutput = (DefaultSourceSetOutput)Cast.cast(DefaultSourceSetOutput.class, (Object)sourceSet.getOutput());
        sourceSetOutput.getClassesDirs().from(new Object[]{sourceDirectorySet.getDestinationDirectory()}).builtBy(new Object[]{compileTask});
        sourceSetOutput.getGeneratedSourcesDirs().from(new Object[]{options.flatMap(CompileOptions::getGeneratedSourceOutputDirectory)});
        sourceDirectorySet.compiledBy(compileTask, AbstractCompile::getDestinationDirectory);
    }

    public static void configureJavaDocTask(@Nullable String featureName, SourceSet sourceSet, TaskContainer tasks, @Nullable JavaPluginExtension javaPluginExtension) {
        String javadocTaskName = sourceSet.getJavadocTaskName();
        if (!tasks.getNames().contains(javadocTaskName)) {
            tasks.register(javadocTaskName, Javadoc.class, javadoc -> {
                javadoc.setDescription("Generates Javadoc API documentation for the " + (featureName == null ? "main source code." : "'" + featureName + "' feature."));
                javadoc.setGroup("documentation");
                javadoc.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
                javadoc.setSource((FileTree)sourceSet.getAllJava());
                if (javaPluginExtension != null) {
                    javadoc.getConventionMapping().map("destinationDir", () -> ((Directory)javaPluginExtension.getDocsDir().dir(javadocTaskName).get()).getAsFile());
                    javadoc.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
                }
            });
        }
    }

    @Deprecated
    public static void configureDocumentationVariantWithArtifact(String variantName, @Nullable String featureName, String docsType, List<Capability> capabilities, String jarTaskName, Object artifactSource, @Nullable AdhocComponentWithVariants component, ConfigurationContainer configurations, TaskContainer tasks, ObjectFactory objectFactory) {
        ((DeprecationMessageBuilder.DeprecateInternalApi)DeprecationLogger.deprecateInternalApi((String)"configureDocumentationVariantWithArtifact (no FileResolver)").replaceWith((Object)"configureDocumentationVariantWithArtifact (with FileResolver)")).willBeRemovedInGradle8().withUpgradeGuideSection(7, "lazypublishartifact_fileresolver").nagUser();
        JvmPluginsHelper.configureDocumentationVariantWithArtifact(variantName, featureName, docsType, capabilities, jarTaskName, artifactSource, component, configurations, tasks, objectFactory, null);
    }

    public static void configureDocumentationVariantWithArtifact(String variantName, @Nullable String featureName, String docsType, List<Capability> capabilities, String jarTaskName, Object artifactSource, @Nullable AdhocComponentWithVariants component, ConfigurationContainer configurations, TaskContainer tasks, ObjectFactory objectFactory, FileResolver fileResolver) {
        Configuration variant = JvmPluginsHelper.maybeCreateInvisibleConfig(configurations, variantName, docsType + " elements for " + (featureName == null ? "main" : featureName) + ".", true);
        AttributeContainer attributes = variant.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "documentation")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
        attributes.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)objectFactory.named(DocsType.class, docsType)));
        capabilities.forEach(arg_0 -> ((ConfigurationPublications)variant.getOutgoing()).capability(arg_0));
        if (!tasks.getNames().contains(jarTaskName)) {
            TaskProvider jarTask = tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the " + (featureName == null ? "main " + docsType + "." : docsType + " of the '" + featureName + "' feature."));
                jar.setGroup("build");
                jar.from(new Object[]{artifactSource});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)(featureName == null ? docsType : featureName + "-" + docsType)));
            });
            if (tasks.getNames().contains("assemble")) {
                tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        TaskProvider jar2 = tasks.named(jarTaskName);
        variant.getOutgoing().artifact((Object)new LazyPublishArtifact((Provider)jar2, fileResolver));
        if (component != null) {
            component.addVariantsFromConfiguration(variant, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    private static Configuration maybeCreateInvisibleConfig(ConfigurationContainer container, String name, String description, boolean canBeConsumed) {
        Configuration configuration = (Configuration)container.maybeCreate(name);
        configuration.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeResolved(false);
        configuration.setCanBeConsumed(canBeConsumed);
        return configuration;
    }

    @Nullable
    public static AdhocComponentWithVariants findJavaComponent(SoftwareComponentContainer components) {
        SoftwareComponent component = (SoftwareComponent)components.findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }

    public static Action<ConfigurationInternal> configureLibraryElementsAttributeForCompileClasspath(boolean javaClasspathPackaging, SourceSet sourceSet, TaskProvider<JavaCompile> compileTaskProvider, ObjectFactory objectFactory) {
        return conf -> {
            AttributeContainerInternal attributes = conf.getAttributes();
            if (!attributes.contains(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE)) {
                String libraryElements = javaClasspathPackaging || JavaModuleDetector.isModuleSource((boolean)((Boolean)((JavaCompile)compileTaskProvider.get()).getModularity().getInferModulePath().get()), (Iterable)CompilationSourceDirs.inferSourceRoots((FileTreeInternal)((FileTreeInternal)sourceSet.getJava().getAsFileTree()))) ? "jar" : "classes";
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, libraryElements)));
            }
        };
    }

    public static class ProviderBasedIntermediateJavaArtifact
    extends IntermediateJavaArtifact {
        private final Provider<File> fileProvider;

        public ProviderBasedIntermediateJavaArtifact(String type, Object dependency, Provider<File> fileProvider) {
            super(type, dependency);
            this.fileProvider = fileProvider;
        }

        public File getFile() {
            return (File)this.fileProvider.get();
        }
    }

    public static class ImmediateIntermediateJavaArtifact
    extends IntermediateJavaArtifact {
        private final File file;

        public ImmediateIntermediateJavaArtifact(String type, Object dependency, File file) {
            super(type, dependency);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    private static abstract class IntermediateJavaArtifact
    extends AbstractPublishArtifact {
        private final String type;

        public IntermediateJavaArtifact(String type, Object dependency) {
            super(new Object[]{dependency});
            this.type = type;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }

        public boolean shouldBePublished() {
            return false;
        }
    }
}

