/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.RootConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class RootLocalComponentMetadata
extends DefaultLocalComponentMetadata {
    private final DependencyLockingProvider dependencyLockingProvider;
    private final Map<String, RootLocalConfigurationMetadata> rootConfigs = Maps.newHashMap();

    public RootLocalComponentMetadata(ModuleVersionIdentifier moduleVersionIdentifier, ComponentIdentifier componentIdentifier, String status, AttributesSchemaInternal schema, DependencyLockingProvider dependencyLockingProvider, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        super(moduleVersionIdentifier, componentIdentifier, status, schema, model, calculatedValueContainerFactory);
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
        assert (hierarchy.contains((Object)name));
        RootLocalConfigurationMetadata conf = new RootLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities, this.model, this.calculatedValueContainerFactory, consistentResolutionConstraints);
        this.addToConfigurations(name, conf);
        this.rootConfigs.put(name, conf);
        return conf;
    }

    @Override
    public List<? extends DependencyMetadata> getSyntheticDependencies(String configuration) {
        return this.rootConfigs.get(configuration).getSyntheticDependencies();
    }

    class RootLocalConfigurationMetadata
    extends DefaultLocalComponentMetadata.DefaultLocalConfigurationMetadata
    implements RootConfigurationMetadata {
        private final Supplier<List<DependencyConstraint>> consistentResolutionConstraints;
        private boolean configurationLocked;
        private DependencyLockingState dependencyLockingState;
        private final Lazy<List<LocalOriginDependencyMetadata>> syntheticDependencies;

        RootLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
            super(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionDeprecation, canBeResolved, capabilities, model, calculatedValueContainerFactory);
            this.syntheticDependencies = Lazy.locking().of(this::computeSyntheticDependencies);
            this.consistentResolutionConstraints = consistentResolutionConstraints;
        }

        @Override
        public void enableLocking() {
            this.configurationLocked = true;
        }

        @Override
        List<LocalOriginDependencyMetadata> getSyntheticDependencies() {
            return (List)this.syntheticDependencies.get();
        }

        private ImmutableList<LocalOriginDependencyMetadata> computeSyntheticDependencies() {
            ImmutableList.Builder syntheticDependencies = ImmutableList.builder();
            if (this.configurationLocked) {
                this.dependencyLockingState = RootLocalComponentMetadata.this.dependencyLockingProvider.loadLockState(this.getName());
                boolean strict = this.dependencyLockingState.mustValidateLockState();
                for (ModuleComponentIdentifier lockedDependency : this.dependencyLockingState.getLockedDependencies()) {
                    String lockedVersion = lockedDependency.getVersion();
                    DefaultMutableVersionConstraint versionConstraint = strict ? DefaultMutableVersionConstraint.withStrictVersion(lockedVersion) : DefaultMutableVersionConstraint.withVersion(lockedVersion);
                    ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockedDependency.getGroup(), lockedDependency.getModule()), versionConstraint);
                    syntheticDependencies.add((Object)new LocalComponentDependencyMetadata(this.getComponentId(), (ComponentSelector)selector, this.getName(), (AttributeContainer)this.getAttributes(), (AttributeContainer)ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, this.getLockReason(strict, lockedVersion)));
                }
            }
            List<DependencyConstraint> dependencyConstraints = this.consistentResolutionConstraints.get();
            for (DependencyConstraint dc : dependencyConstraints) {
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dc.getGroup(), dc.getName()), dc.getVersionConstraint());
                syntheticDependencies.add((Object)new LocalComponentDependencyMetadata(this.getComponentId(), (ComponentSelector)selector, this.getName(), (AttributeContainer)this.getAttributes(), (AttributeContainer)ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, dc.getReason()));
            }
            return syntheticDependencies.build();
        }

        private String getLockReason(boolean strict, String lockedVersion) {
            if (strict) {
                return "dependency was locked to version '" + lockedVersion + "'";
            }
            return "dependency was locked to version '" + lockedVersion + "' (update/lenient mode)";
        }

        @Override
        public DependencyLockingState getDependencyLockingState() {
            return this.dependencyLockingState;
        }
    }
}

