/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSetFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveVariantState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.component.model.VariantWithOverloadAttributes;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ArtifactSelector;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.util.internal.CollectionUtils;

public class DefaultArtifactSelector
implements ArtifactSelector {
    private final List<OriginArtifactSelector> selectors;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final ArtifactResolver artifactResolver;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ResolvedVariantCache resolvedVariantCache;

    public DefaultArtifactSelector(List<OriginArtifactSelector> selectors, ArtifactResolver artifactResolver, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ResolvedVariantCache resolvedVariantCache) {
        this.selectors = selectors;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactResolver = artifactResolver;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.resolvedVariantCache = resolvedVariantCache;
    }

    @Override
    public ArtifactSet resolveArtifacts(LocalFileDependencyMetadata fileDependencyMetadata) {
        return new FileDependencyArtifactSet(fileDependencyMetadata, this.artifactTypeRegistry, this.calculatedValueContainerFactory);
    }

    @Override
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, Supplier<Set<? extends VariantResolveMetadata>> allVariants, Set<? extends VariantResolveMetadata> legacyVariants, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
        ModuleVersionIdentifier moduleVersionId = component.getModuleVersionId();
        ModuleSources sources = component.getSources();
        ImmutableCapabilities fallbackCapabilities = ImmutableCapabilities.of(ImmutableCapability.defaultCapabilityForComponent(moduleVersionId));
        ImmutableSet<ResolvedVariant> legacyResolvedVariants = this.buildResolvedVariants(moduleVersionId, fallbackCapabilities, sources, legacyVariants, exclusions);
        ComponentArtifactResolveVariantState allResolvedVariants = () -> this.buildResolvedVariants(moduleVersionId, fallbackCapabilities, sources, (Set)allVariants.get(), exclusions);
        for (OriginArtifactSelector selector : this.selectors) {
            ArtifactSet artifacts = selector.resolveArtifacts(component, allResolvedVariants, (Set<ResolvedVariant>)legacyResolvedVariants, exclusions, overriddenAttributes);
            if (artifacts == null) continue;
            return artifacts;
        }
        throw new IllegalStateException("No artifacts selected.");
    }

    private ImmutableSet<ResolvedVariant> buildResolvedVariants(ModuleVersionIdentifier moduleVersionId, ImmutableCapabilities fallbackCapabilities, ModuleSources sources, Set<? extends VariantResolveMetadata> allVariants, ExcludeSpec exclusions) {
        ImmutableSet.Builder resolvedVariantBuilder = ImmutableSet.builder();
        for (VariantResolveMetadata variantResolveMetadata : allVariants) {
            ResolvedVariant resolvedVariant = this.toResolvedVariant(variantResolveMetadata.getIdentifier(), variantResolveMetadata.asDescribable(), variantResolveMetadata.getAttributes(), variantResolveMetadata.getArtifacts(), DefaultArtifactSelector.withImplicitCapability(variantResolveMetadata.getCapabilities().getCapabilities(), fallbackCapabilities), exclusions, moduleVersionId, sources, this.resolvedVariantCache, variantResolveMetadata.isEligibleForCaching());
            resolvedVariantBuilder.add((Object)resolvedVariant);
        }
        return resolvedVariantBuilder.build();
    }

    private ResolvedVariant toResolvedVariant(VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes variantAttributes, ImmutableList<? extends ComponentArtifactMetadata> artifacts, ImmutableCapabilities capabilities, ExcludeSpec exclusions, ModuleVersionIdentifier ownerId, ModuleSources moduleSources, ResolvedVariantCache resolvedVariantCache, boolean eligibleForCaching) {
        List artifactsToResolve = CollectionUtils.filter(artifacts, artifact -> !exclusions.excludesArtifact(ownerId.getModule(), artifact.getName()));
        boolean hasExcludedArtifact = artifactsToResolve.size() < artifacts.size();
        ImmutableAttributes attributes = this.artifactTypeRegistry.mapAttributesFor(variantAttributes, (Iterable<? extends ComponentArtifactMetadata>)artifacts);
        if (hasExcludedArtifact) {
            return ArtifactSetFactory.toResolvedVariant(null, displayName, attributes, artifactsToResolve, capabilities, ownerId, moduleSources, this.artifactResolver);
        }
        if (!eligibleForCaching) {
            return ArtifactSetFactory.toResolvedVariant(identifier, displayName, attributes, artifactsToResolve, capabilities, ownerId, moduleSources, this.artifactResolver);
        }
        VariantWithOverloadAttributes key = new VariantWithOverloadAttributes(identifier, attributes);
        return resolvedVariantCache.computeIfAbsent(key, id -> ArtifactSetFactory.toResolvedVariant(identifier, displayName, attributes, artifactsToResolve, capabilities, ownerId, moduleSources, this.artifactResolver));
    }

    private static ImmutableCapabilities withImplicitCapability(Collection<? extends Capability> capabilities, ImmutableCapabilities fallbackCapabilities) {
        if (capabilities.isEmpty()) {
            return fallbackCapabilities;
        }
        return ImmutableCapabilities.copyAsImmutable(capabilities);
    }

    @Override
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, Collection<? extends ComponentArtifactMetadata> artifacts, ImmutableAttributes overriddenAttributes) {
        ImmutableAttributes attributes = this.artifactTypeRegistry.mapAttributesFor(component.getAttributes(), artifacts);
        return ArtifactSetFactory.adHocVariant(component.getId(), component.getModuleVersionId(), artifacts, component.getSources(), component.getAttributesSchema(), this.artifactResolver, attributes, overriddenAttributes);
    }
}

