/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;

public abstract class ArchiveHandler {
    private final File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){};

    protected ArchiveHandler(@NotNull String path2) {
        if (path2 == null) {
            ArchiveHandler.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference<Object>(null);
        this.myChildrenEntries = new SoftReference<Object>(null);
        this.myPath = new File(path2);
    }

    @NotNull
    public File getFile() {
        File file2 = this.myPath;
        if (file2 == null) {
            ArchiveHandler.$$$reportNull$$$0(1);
        }
        return file2;
    }

    public void dispose() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(10);
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference<Map<String, EntryInfo>>(map);
                }
            }
        }
        Map<String, EntryInfo> map2 = map;
        if (map2 == null) {
            ArchiveHandler.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    @NotNull
    protected Trinity<String, String, String> splitPathAndFix(@NotNull String entryName) {
        int slashP;
        int p;
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(17);
        }
        String parentName = (p = Math.max(slashP = entryName.lastIndexOf(47), entryName.lastIndexOf(92))) > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        String fixedParent = parentName.replace('\\', '/');
        if (fixedParent != parentName || slashP == -1 && p != -1) {
            parentName = fixedParent;
            entryName = parentName + '/' + shortName;
        }
        Trinity<String, String, String> trinity = Trinity.create(parentName, shortName, entryName);
        if (trinity == null) {
            ArchiveHandler.$$$reportNull$$$0(18);
        }
        return trinity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentChildrenMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentChildrenMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPathAndFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEntryInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "splitPathAndFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent2;
            if (shortName == null) {
                EntryInfo.$$$reportNull$$$0(0);
            }
            this.parent = parent2;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
        }
    }
}

