/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.TaskNode;
import org.gradle.initialization.DefaultPlannedTask;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;

public class BuildOperationFiringBuildWorkPreparer
implements BuildWorkPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildWorkPreparer delegate;

    public BuildOperationFiringBuildWorkPreparer(BuildOperationExecutor buildOperationExecutor, BuildWorkPreparer delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    @Override
    public ExecutionPlan newExecutionPlan() {
        return this.delegate.newExecutionPlan();
    }

    @Override
    public void populateWorkGraph(GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new PopulateWorkGraph(gradle, plan, this.delegate, action));
    }

    @Override
    public FinalizedExecutionPlan finalizeWorkGraph(GradleInternal gradle, ExecutionPlan plan) {
        return this.delegate.finalizeWorkGraph(gradle, plan);
    }

    private static List<CalculateTaskGraphBuildOperationType.PlannedTask> toPlannedTasks(QueryableExecutionPlan.ScheduledNodes scheduledWork) {
        ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask> tasks = new ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask>();
        scheduledWork.visitNodes(nodes -> {
            for (Node node : nodes) {
                if (!(node instanceof LocalTaskNode)) continue;
                tasks.add(BuildOperationFiringBuildWorkPreparer.toPlannedTask((LocalTaskNode)node));
            }
        });
        return tasks;
    }

    private static CalculateTaskGraphBuildOperationType.PlannedTask toPlannedTask(LocalTaskNode taskNode) {
        TaskIdentity<?> taskIdentity = taskNode.getTask().getTaskIdentity();
        return new DefaultPlannedTask(new PlannedTaskIdentity(taskIdentity), BuildOperationFiringBuildWorkPreparer.taskIdentifiesOf(taskNode.getDependencySuccessors(), (Function<? super Node, ? extends Collection<Node>>)((Function)Node::getDependencySuccessors)), BuildOperationFiringBuildWorkPreparer.taskIdentifiesOf(taskNode.getMustSuccessors()), BuildOperationFiringBuildWorkPreparer.taskIdentifiesOf(taskNode.getShouldSuccessors()), BuildOperationFiringBuildWorkPreparer.taskIdentifiesOf(taskNode.getFinalizers()));
    }

    private static List<CalculateTaskGraphBuildOperationType.TaskIdentity> taskIdentifiesOf(Collection<Node> nodes, Function<? super Node, ? extends Collection<Node>> traverser) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CalculateTaskGraphBuildOperationType.TaskIdentity> list = new ArrayList<CalculateTaskGraphBuildOperationType.TaskIdentity>();
        BuildOperationFiringBuildWorkPreparer.traverseNonTasks(nodes, traverser, Collections.newSetFromMap(new IdentityHashMap())).forEach(taskNode -> list.add(BuildOperationFiringBuildWorkPreparer.toIdentity(taskNode)));
        return list;
    }

    private static Iterable<TaskNode> traverseNonTasks(Collection<Node> nodes, Function<? super Node, ? extends Collection<Node>> traverser, Set<Node> seen) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return FluentIterable.from(nodes).filter(seen::add).transformAndConcat(node -> node instanceof TaskNode ? ImmutableSet.of((Object)((TaskNode)node)) : BuildOperationFiringBuildWorkPreparer.traverseNonTasks(Objects.requireNonNull((Collection)traverser.apply(node)), traverser, seen));
    }

    private static List<CalculateTaskGraphBuildOperationType.TaskIdentity> taskIdentifiesOf(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return FluentIterable.from(nodes).filter(TaskNode.class).transform(BuildOperationFiringBuildWorkPreparer::toIdentity).toList();
    }

    private static CalculateTaskGraphBuildOperationType.TaskIdentity toIdentity(TaskNode n) {
        return new PlannedTaskIdentity(n.getTask().getTaskIdentity());
    }

    private static List<String> toTaskPaths(Set<Task> tasks) {
        return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, Task::getPath)).asList();
    }

    private static class PlannedTaskIdentity
    implements CalculateTaskGraphBuildOperationType.TaskIdentity {
        private final TaskIdentity<?> delegate;

        public PlannedTaskIdentity(TaskIdentity<?> delegate) {
            this.delegate = delegate;
        }

        public String getBuildPath() {
            return this.delegate.getBuildPath();
        }

        public String getTaskPath() {
            return this.delegate.getTaskPath();
        }

        public long getTaskId() {
            return this.delegate.getId();
        }
    }

    private static class PopulateWorkGraph
    implements RunnableBuildOperation {
        private final GradleInternal gradle;
        private final ExecutionPlan plan;
        private final BuildWorkPreparer delegate;
        private final Consumer<? super ExecutionPlan> action;

        public PopulateWorkGraph(GradleInternal gradle, ExecutionPlan plan, BuildWorkPreparer delegate, Consumer<? super ExecutionPlan> action) {
            this.gradle = gradle;
            this.plan = plan;
            this.delegate = delegate;
            this.action = action;
        }

        public void run(BuildOperationContext buildOperationContext) {
            this.populateTaskGraph();
            QueryableExecutionPlan contents = this.plan.getContents();
            final Set<Task> requestedTasks = contents.getRequestedTasks();
            final Set<Task> filteredTasks = contents.getFilteredTasks();
            final QueryableExecutionPlan.ScheduledNodes scheduledWork = contents.getScheduledNodes();
            buildOperationContext.setResult((Object)new CalculateTaskGraphBuildOperationType.Result(){
                private final List<CalculateTaskGraphBuildOperationType.PlannedTask> taskPlan;
                {
                    this.taskPlan = BuildOperationFiringBuildWorkPreparer.toPlannedTasks(scheduledWork);
                }

                public List<String> getRequestedTaskPaths() {
                    return BuildOperationFiringBuildWorkPreparer.toTaskPaths(requestedTasks);
                }

                public List<String> getExcludedTaskPaths() {
                    return BuildOperationFiringBuildWorkPreparer.toTaskPaths(filteredTasks);
                }

                public List<CalculateTaskGraphBuildOperationType.PlannedTask> getTaskPlan() {
                    return this.taskPlan;
                }
            });
        }

        void populateTaskGraph() {
            this.delegate.populateWorkGraph(this.gradle, this.plan, this.action);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){

                public String getBuildPath() {
                    return gradle.getIdentityPath().getPath();
                }
            });
        }
    }
}

