/**
 * @typedef Option
 * @property {'boolean'|'string'} [type='string']
 * @property {string} long
 * @property {string} description
 * @property {string} [value]
 * @property {string} [short]
 * @property {boolean|string} [default='']
 * @property {boolean} [truelike=false]
 */
/** @type {Array<Option>} */
export const schema: Array<Option>
export type Option = {
  type?: 'string' | 'boolean' | undefined
  long: string
  description: string
  value?: string | undefined
  short?: string | undefined
  default?: string | boolean | undefined
  truelike?: boolean | undefined
}
