/**
 * @typedef Context
 * @property {Array<VFile>} files
 * @property {Configuration} [configuration]
 */
/**
 * @param {Context} context
 * @param {Settings} settings
 */
export function log(context: Context, settings: Settings): Promise<any>
export type Context = {
  files: Array<VFile>
  configuration?: import('../configuration.js').Configuration | undefined
}
export type VFile = import('vfile').VFile
export type VFileReporter = import('../index.js').VFileReporter
export type Settings = import('./index.js').Settings
export type Configuration = import('./index.js').Configuration
