/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Map;
import javajs.img.DCT;
import javajs.img.Huffman;
import javajs.img.ImageEncoder;
import javajs.img.JpegObj;

public class JpgEncoder
extends ImageEncoder {
    private static final int CONTINUE_MAX = 65500;
    private static final int CONTINUE_MAX_BUFFER = 65510;
    private JpegObj jpegObj;
    private Huffman huf;
    private DCT dct;
    protected int defaultQuality = 100;
    private String applicationTag;
    private static byte[] eoi = new byte[]{-1, -39};
    private static byte[] jfif;
    private static byte[] soi;

    static {
        byte[] byArray = new byte[18];
        byArray[0] = -1;
        byArray[1] = -32;
        byArray[3] = 16;
        byArray[4] = 74;
        byArray[5] = 70;
        byArray[6] = 73;
        byArray[7] = 70;
        byArray[9] = 1;
        byArray[13] = 1;
        byArray[15] = 1;
        jfif = byArray;
        soi = new byte[]{-1, -40};
    }

    @Override
    protected void setParams(Map<String, Object> map) {
        if (this.quality <= 0) {
            this.quality = map.containsKey("qualityJPG") ? (Integer)map.get("qualityJPG") : this.defaultQuality;
        }
        this.jpegObj = new JpegObj();
        this.jpegObj.comment = (String)map.get("comment");
        this.applicationTag = (String)map.get("jpgAppTag");
    }

    @Override
    protected void generate() throws IOException {
        this.jpegObj.imageWidth = this.width;
        this.jpegObj.imageHeight = this.height;
        this.dct = new DCT(this.quality);
        this.huf = new Huffman(this.width, this.height);
        if (this.jpegObj == null) {
            return;
        }
        this.jpegObj.getYCCArray(this.pixels);
        String string = this.writeHeaders(this.jpegObj, this.dct);
        this.writeCompressedData(this.jpegObj, this.dct, this.huf);
        this.writeMarker(eoi);
        if (string != null) {
            byte[] byArray = string.getBytes();
            this.out.write(byArray, 0, byArray.length);
        }
    }

    private void writeCompressedData(JpegObj jpegObj, DCT dCT, Huffman huffman) {
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[jpegObj.numberOfComponents];
        int n = huffman.imageWidth % 8 != 0 ? (int)(Math.floor((double)huffman.imageWidth / 8.0) + 1.0) * 8 : huffman.imageWidth;
        int n2 = huffman.imageHeight % 8 != 0 ? (int)(Math.floor((double)huffman.imageHeight / 8.0) + 1.0) * 8 : huffman.imageHeight;
        int n3 = 0;
        while (n3 < jpegObj.numberOfComponents) {
            n = Math.min(n, jpegObj.blockWidth[n3]);
            n2 = Math.min(n2, jpegObj.blockHeight[n3]);
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                n4 = n6 * 8;
                int n7 = n5 * 8;
                n3 = 0;
                while (n3 < jpegObj.numberOfComponents) {
                    float[][] fArray2 = jpegObj.components[n3];
                    int n8 = jpegObj.vsampFactor[n3];
                    int n9 = jpegObj.hsampFactor[n3];
                    int n10 = jpegObj.qtableNumber[n3];
                    int n11 = jpegObj.dctableNumber[n3];
                    int n12 = jpegObj.actableNumber[n3];
                    int n13 = 0;
                    while (n13 < n8) {
                        int n14 = 0;
                        while (n14 < n9) {
                            int n15 = n14 * 8;
                            int n16 = n13 * 8;
                            int n17 = 0;
                            while (n17 < 8) {
                                int n18 = 0;
                                while (n18 < 8) {
                                    fArray[n17][n18] = fArray2[n7 + n16 + n17][n4 + n15 + n18];
                                    ++n18;
                                }
                                ++n17;
                            }
                            dArray = DCT.forwardDCT(fArray);
                            nArray = DCT.quantizeBlock(dArray, dCT.divisors[n10]);
                            huffman.HuffmanBlockEncoder(this.out, nArray, nArray2[n3], n11, n12);
                            nArray2[n3] = nArray[0];
                            ++n14;
                        }
                        ++n13;
                    }
                    ++n3;
                }
                ++n6;
            }
            ++n5;
        }
        huffman.flushBuffer(this.out);
    }

    private String writeHeaders(JpegObj jpegObj, DCT dCT) {
        this.writeMarker(soi);
        this.writeArray(jfif);
        String string = null;
        if (jpegObj.comment.length() > 0) {
            this.writeString(jpegObj.comment, (byte)-31);
        }
        this.writeString("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.\n\n", (byte)-2);
        byte[] byArray = new byte[134];
        byArray[0] = -1;
        byArray[1] = -37;
        byArray[2] = 0;
        byArray[3] = -124;
        int n = 4;
        int n2 = 0;
        while (n2 < 2) {
            byArray[n++] = (byte)(0 + n2);
            int[] nArray = dCT.quantum[n2];
            int n3 = 0;
            while (n3 < 64) {
                byArray[n++] = (byte)nArray[Huffman.jpegNaturalOrder[n3]];
                ++n3;
            }
            ++n2;
        }
        this.writeArray(byArray);
        byte[] byArray2 = new byte[19];
        byArray2[0] = -1;
        byArray2[1] = -64;
        byArray2[2] = 0;
        byArray2[3] = 17;
        byArray2[4] = (byte)jpegObj.precision;
        byArray2[5] = (byte)(jpegObj.imageHeight >> 8 & 0xFF);
        byArray2[6] = (byte)(jpegObj.imageHeight & 0xFF);
        byArray2[7] = (byte)(jpegObj.imageWidth >> 8 & 0xFF);
        byArray2[8] = (byte)(jpegObj.imageWidth & 0xFF);
        byArray2[9] = (byte)jpegObj.numberOfComponents;
        int n4 = 10;
        n2 = 0;
        while (n2 < byArray2[9]) {
            byArray2[n4++] = (byte)jpegObj.compID[n2];
            byArray2[n4++] = (byte)((jpegObj.hsampFactor[n2] << 4) + jpegObj.vsampFactor[n2]);
            byArray2[n4++] = (byte)jpegObj.qtableNumber[n2];
            ++n2;
        }
        this.writeArray(byArray2);
        this.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance);
        this.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance);
        this.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance);
        this.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance);
        byte[] byArray3 = new byte[14];
        byArray3[0] = -1;
        byArray3[1] = -38;
        byArray3[2] = 0;
        byArray3[3] = 12;
        byArray3[4] = (byte)jpegObj.numberOfComponents;
        n4 = 5;
        n2 = 0;
        while (n2 < byArray3[4]) {
            byArray3[n4++] = (byte)jpegObj.compID[n2];
            byArray3[n4++] = (byte)((jpegObj.dctableNumber[n2] << 4) + jpegObj.actableNumber[n2]);
            ++n2;
        }
        byArray3[n4++] = (byte)jpegObj.ss;
        byArray3[n4++] = (byte)jpegObj.se;
        byArray3[n4++] = (byte)((jpegObj.ah << 4) + jpegObj.al);
        this.writeArray(byArray3);
        return string;
    }

    private void writeString(String string, byte by) {
        int n = string.length();
        int n2 = 0;
        String string2 = this.applicationTag;
        while (n2 < n) {
            int n3;
            int n4 = n - n2;
            if (n4 > 65510 && (n3 = string.lastIndexOf(10, n2 + (n4 = 65500))) > n2 + 1) {
                n4 = n3 - n2;
            }
            if (n2 + n4 == n) {
                string2 = "";
            }
            this.writeTag(n4 + string2.length(), by);
            this.writeArray(string.substring(n2, n2 + n4).getBytes());
            if (string2.length() > 0) {
                this.writeArray(string2.getBytes());
            }
            n2 += n4;
        }
    }

    private void writeTag(int n, byte by) {
        byte[] byArray = new byte[]{-1, by, (byte)((n += 2) >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeArray(byArray);
    }

    void WriteDHTHeader(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 1;
        while (n2 < 17) {
            n += nArray[n2];
            ++n2;
        }
        byte[] byArray = new byte[21 + n];
        byArray[0] = -1;
        byArray[1] = -60;
        n2 = 4;
        int n3 = 0;
        while (n3 < 17) {
            byArray[n2++] = (byte)nArray[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            byArray[n2++] = (byte)nArray2[n3];
            ++n3;
        }
        byArray[2] = (byte)(n2 - 2 >> 8 & 0xFF);
        byArray[3] = (byte)(n2 - 2 & 0xFF);
        this.writeArray(byArray);
    }

    void writeMarker(byte[] byArray) {
        this.out.write(byArray, 0, 2);
    }

    void writeArray(byte[] byArray) {
        this.out.write(byArray, 0, byArray.length);
    }
}

