/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.SessionSaveAction;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class SessionLoadAction
extends DiskAccessAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.setHelpId(HelpUtil.ht("/Action/SessionLoad"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractFileChooser fc = SessionLoadAction.createAndOpenFileChooser(true, false, I18n.tr("Open session", new Object[0]), Arrays.asList(SessionImporter.FILE_FILTER, FileFilterAllFiles.getInstance()), SessionImporter.FILE_FILTER, 0, "lastDirectory");
        if (fc == null) {
            return;
        }
        File file = fc.getSelectedFile();
        boolean zip = Utils.hasExtension(file, "joz");
        MainApplication.worker.submit(new Loader(file, zip));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private final URI uri;
        private final InputStream is;
        private final boolean zip;
        private List<Layer> layers;
        private Layer active;
        private List<Runnable> postLoadTasks;
        private SessionReader.SessionViewportData viewport;
        private SessionReader.SessionProjectionChoiceData projectionChoice;

        public Loader(File file, boolean zip) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            this.file = file;
            this.uri = null;
            this.is = null;
            this.zip = zip;
        }

        public Loader(InputStream is, URI uri, boolean zip) {
            super(I18n.tr("Loading session ''{0}''", uri));
            CheckParameterUtil.ensureParameterNotNull(is, "is");
            CheckParameterUtil.ensureParameterNotNull(uri, "uri");
            this.file = null;
            this.uri = uri;
            this.is = is;
            this.zip = zip;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(() -> {
                if (this.canceled) {
                    return;
                }
                if (this.projectionChoice != null) {
                    ProjectionPreference.setProjection(this.projectionChoice.getProjectionChoiceId(), this.projectionChoice.getSubPreferences(), false);
                }
                this.addLayers();
                this.runPostLoadTasks();
            });
        }

        private void addLayers() {
            if (!Utils.isEmpty(this.layers)) {
                boolean noMap = MainApplication.getMap() == null;
                for (Layer l : this.layers) {
                    if (this.canceled) {
                        return;
                    }
                    Loader.addLayer(l);
                }
                if (this.active != null) {
                    MainApplication.getLayerManager().setActiveLayer(this.active);
                }
                if (noMap && this.viewport != null) {
                    MainApplication.getMap().mapView.scheduleZoomTo(this.viewport.getEastNorthViewport(ProjectionRegistry.getProjection()));
                }
            }
        }

        static boolean addLayer(Layer l) {
            if (!MainApplication.getLayerManager().containsLayer(l)) {
                try {
                    MainApplication.getLayerManager().addLayer(l);
                }
                catch (ReportedException e) {
                    Logging.error(e);
                    new Notification(I18n.tr("Unable to add layer ''{0}'': {1}", l.getName(), e.getMessage())).setIcon(0).setDuration(Notification.TIME_LONG).show();
                    if (MainApplication.getLayerManager().containsLayer(l)) {
                        MainApplication.getLayerManager().removeLayer(l);
                    }
                    return false;
                }
            }
            return true;
        }

        private void runPostLoadTasks() {
            if (this.postLoadTasks != null) {
                for (Runnable task : this.postLoadTasks) {
                    if (this.canceled) {
                        return;
                    }
                    if (task == null) continue;
                    task.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() {
            try {
                ProgressMonitor monitor = this.getProgressMonitor();
                SessionReader reader = new SessionReader();
                boolean tempFile = false;
                try {
                    if (this.file == null) {
                        this.file = File.createTempFile("session_", ".joz", Utils.getJosmTempDir());
                        tempFile = true;
                        Files.copy(this.is, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    reader.loadSession(this.file, this.zip, monitor);
                    this.layers = reader.getLayers();
                    this.active = reader.getActive();
                    this.postLoadTasks = reader.getPostLoadTasks();
                    this.viewport = reader.getViewport();
                    this.projectionChoice = reader.getProjectionChoice();
                    SessionSaveAction.setCurrentSession(this.file, this.zip, reader.getLayers());
                }
                finally {
                    if (tempFile) {
                        Utils.deleteFile(this.file);
                        this.file = null;
                    }
                }
            }
            catch (IllegalDataException e) {
                this.handleException(I18n.tr("Data Error", new Object[0]), e);
            }
            catch (IOException e) {
                this.handleException(I18n.tr("IO Error", new Object[0]), e);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                this.cancel();
                throw e;
            }
        }

        private void handleException(String dialogTitle, Exception e) {
            Logging.error(e);
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.uri != null ? this.uri : this.file.getName(), Utils.escapeReservedCharactersHTML(e.getMessage())), dialogTitle, 0, null);
            this.cancel();
        }
    }
}

