/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.LRUCache;

public final class Scanner
implements Iterator<String>,
Closeable {
    private CharBuffer buf;
    private static final int BUFFER_SIZE = 1024;
    private int position;
    private Matcher matcher;
    private Pattern delimPattern;
    private Pattern hasNextPattern;
    private int hasNextPosition;
    private String hasNextResult;
    private Readable source;
    private boolean sourceClosed = false;
    private boolean needInput = false;
    private boolean skipped = false;
    private int savedScannerPosition = -1;
    private Object typeCache = null;
    private boolean matchValid = false;
    private boolean closed = false;
    private int radix = 10;
    private int defaultRadix = 10;
    private Locale locale = null;
    private LRUCache<String, Pattern> patternCache = new LRUCache<String, Pattern>(7){

        @Override
        protected Pattern create(String s) {
            return Pattern.compile(s);
        }

        @Override
        protected boolean hasName(Pattern p, String s) {
            return p.pattern().equals(s);
        }
    };
    private IOException lastException;
    private static Pattern WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static Pattern FIND_ANY_PATTERN = Pattern.compile("(?s).*");
    private static Pattern NON_ASCII_DIGIT = Pattern.compile("[\\p{javaDigit}&&[^0-9]]");
    private String groupSeparator = "\\,";
    private String decimalSeparator = "\\.";
    private String nanString = "NaN";
    private String infinityString = "Infinity";
    private String positivePrefix = "";
    private String negativePrefix = "\\-";
    private String positiveSuffix = "";
    private String negativeSuffix = "";
    private static volatile Pattern boolPattern;
    private static final String BOOLEAN_PATTERN = "true|false";
    private Pattern integerPattern;
    private String digits = "0123456789abcdefghijklmnopqrstuvwxyz";
    private String non0Digit = "[\\p{javaDigit}&&[^0]]";
    private int SIMPLE_GROUP_INDEX = 5;
    private static volatile Pattern separatorPattern;
    private static volatile Pattern linePattern;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";
    private static final String LINE_PATTERN = ".*(\r\n|[\n\r\u2028\u2029\u0085])|.+$";
    private Pattern floatPattern;
    private Pattern decimalPattern;

    private static Pattern boolPattern() {
        Pattern bp = boolPattern;
        if (bp == null) {
            boolPattern = bp = Pattern.compile(BOOLEAN_PATTERN, 2);
        }
        return bp;
    }

    private String buildIntegerPatternString() {
        String radixDigits = this.digits.substring(0, this.radix);
        String digit = "((?i)[" + radixDigits + "\\p{javaDigit}])";
        String groupedNumeral = "(" + this.non0Digit + digit + "?" + digit + "?(" + this.groupSeparator + digit + digit + digit + ")+)";
        String numeral = "((" + digit + "++)|" + groupedNumeral + ")";
        String javaStyleInteger = "([-+]?(" + numeral + "))";
        String negativeInteger = this.negativePrefix + numeral + this.negativeSuffix;
        String positiveInteger = this.positivePrefix + numeral + this.positiveSuffix;
        return "(" + javaStyleInteger + ")|(" + positiveInteger + ")|(" + negativeInteger + ")";
    }

    private Pattern integerPattern() {
        if (this.integerPattern == null) {
            this.integerPattern = this.patternCache.forName(this.buildIntegerPatternString());
        }
        return this.integerPattern;
    }

    private static Pattern separatorPattern() {
        Pattern sp = separatorPattern;
        if (sp == null) {
            separatorPattern = sp = Pattern.compile(LINE_SEPARATOR_PATTERN);
        }
        return sp;
    }

    private static Pattern linePattern() {
        Pattern lp = linePattern;
        if (lp == null) {
            linePattern = lp = Pattern.compile(LINE_PATTERN);
        }
        return lp;
    }

    private void buildFloatAndDecimalPattern() {
        String digit = "(([0-9\\p{javaDigit}]))";
        String exponent = "([eE][+-]?" + digit + "+)?";
        String groupedNumeral = "(" + this.non0Digit + digit + "?" + digit + "?(" + this.groupSeparator + digit + digit + digit + ")+)";
        String numeral = "((" + digit + "++)|" + groupedNumeral + ")";
        String decimalNumeral = "(" + numeral + "|" + numeral + this.decimalSeparator + digit + "*+|" + this.decimalSeparator + digit + "++)";
        String nonNumber = "(NaN|" + this.nanString + "|Infinity|" + this.infinityString + ")";
        String positiveFloat = "(" + this.positivePrefix + decimalNumeral + this.positiveSuffix + exponent + ")";
        String negativeFloat = "(" + this.negativePrefix + decimalNumeral + this.negativeSuffix + exponent + ")";
        String decimal = "(([-+]?" + decimalNumeral + exponent + ")|" + positiveFloat + "|" + negativeFloat + ")";
        String hexFloat = "[-+]?0[xX][0-9a-fA-F]*\\.[0-9a-fA-F]+([pP][-+]?[0-9]+)?";
        String positiveNonNumber = "(" + this.positivePrefix + nonNumber + this.positiveSuffix + ")";
        String negativeNonNumber = "(" + this.negativePrefix + nonNumber + this.negativeSuffix + ")";
        String signedNonNumber = "(([-+]?" + nonNumber + ")|" + positiveNonNumber + "|" + negativeNonNumber + ")";
        this.floatPattern = Pattern.compile(decimal + "|" + hexFloat + "|" + signedNonNumber);
        this.decimalPattern = Pattern.compile(decimal);
    }

    private Pattern floatPattern() {
        if (this.floatPattern == null) {
            this.buildFloatAndDecimalPattern();
        }
        return this.floatPattern;
    }

    private Pattern decimalPattern() {
        if (this.decimalPattern == null) {
            this.buildFloatAndDecimalPattern();
        }
        return this.decimalPattern;
    }

    private Scanner(Readable source, Pattern pattern) {
        assert (source != null) : "source should not be null";
        assert (pattern != null) : "pattern should not be null";
        this.source = source;
        this.delimPattern = pattern;
        this.buf = CharBuffer.allocate(1024);
        this.buf.limit(0);
        this.matcher = this.delimPattern.matcher(this.buf);
        this.matcher.useTransparentBounds(true);
        this.matcher.useAnchoringBounds(false);
        this.useLocale(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Scanner(Readable source) {
        this(Objects.requireNonNull(source, "source"), WHITESPACE_PATTERN);
    }

    public Scanner(InputStream source) {
        this(new InputStreamReader(source), WHITESPACE_PATTERN);
    }

    public Scanner(InputStream source, String charsetName) {
        this(Scanner.makeReadable(Objects.requireNonNull(source, "source"), Scanner.toCharset(charsetName)), WHITESPACE_PATTERN);
    }

    private static Charset toCharset(String csn) {
        Objects.requireNonNull(csn, "charsetName");
        try {
            return Charset.forName(csn);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Readable makeReadable(InputStream source, Charset charset) {
        return new InputStreamReader(source, charset);
    }

    public Scanner(File source) throws FileNotFoundException {
        this(new FileInputStream(source).getChannel());
    }

    public Scanner(File source, String charsetName) throws FileNotFoundException {
        this(Objects.requireNonNull(source), Scanner.toDecoder(charsetName));
    }

    private Scanner(File source, CharsetDecoder dec) throws FileNotFoundException {
        this(Scanner.makeReadable(new FileInputStream(source).getChannel(), dec));
    }

    private static CharsetDecoder toDecoder(String charsetName) {
        Objects.requireNonNull(charsetName, "charsetName");
        try {
            return Charset.forName(charsetName).newDecoder();
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException unused) {
            throw new IllegalArgumentException(charsetName);
        }
    }

    private static Readable makeReadable(ReadableByteChannel source, CharsetDecoder dec) {
        return Channels.newReader(source, dec, -1);
    }

    public Scanner(Path source) throws IOException {
        this(Files.newInputStream(source, new OpenOption[0]));
    }

    public Scanner(Path source, String charsetName) throws IOException {
        this(Objects.requireNonNull(source), Scanner.toCharset(charsetName));
    }

    private Scanner(Path source, Charset charset) throws IOException {
        this(Scanner.makeReadable(Files.newInputStream(source, new OpenOption[0]), charset));
    }

    public Scanner(String source) {
        this(new StringReader(source), WHITESPACE_PATTERN);
    }

    public Scanner(ReadableByteChannel source) {
        this(Scanner.makeReadable(Objects.requireNonNull(source, "source")), WHITESPACE_PATTERN);
    }

    private static Readable makeReadable(ReadableByteChannel source) {
        return Scanner.makeReadable(source, Charset.defaultCharset().newDecoder());
    }

    public Scanner(ReadableByteChannel source, String charsetName) {
        this(Scanner.makeReadable(Objects.requireNonNull(source, "source"), Scanner.toDecoder(charsetName)), WHITESPACE_PATTERN);
    }

    private void saveState() {
        this.savedScannerPosition = this.position;
    }

    private void revertState() {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
    }

    private boolean revertState(boolean b) {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
        return b;
    }

    private void cacheResult() {
        this.hasNextResult = this.matcher.group();
        this.hasNextPosition = this.matcher.end();
        this.hasNextPattern = this.matcher.pattern();
    }

    private void cacheResult(String result) {
        this.hasNextResult = result;
        this.hasNextPosition = this.matcher.end();
        this.hasNextPattern = this.matcher.pattern();
    }

    private void clearCaches() {
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private String getCachedResult() {
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
        return this.hasNextResult;
    }

    private void useTypeCache() {
        if (this.closed) {
            throw new IllegalStateException("Scanner closed");
        }
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private void readInput() {
        if (this.buf.limit() == this.buf.capacity()) {
            this.makeSpace();
        }
        int p = this.buf.position();
        this.buf.position(this.buf.limit());
        this.buf.limit(this.buf.capacity());
        int n = 0;
        try {
            n = this.source.read(this.buf);
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            n = -1;
        }
        if (n == -1) {
            this.sourceClosed = true;
            this.needInput = false;
        }
        if (n > 0) {
            this.needInput = false;
        }
        this.buf.limit(this.buf.position());
        this.buf.position(p);
    }

    private boolean makeSpace() {
        this.clearCaches();
        int offset = this.savedScannerPosition == -1 ? this.position : this.savedScannerPosition;
        this.buf.position(offset);
        if (offset > 0) {
            this.buf.compact();
            this.translateSavedIndexes(offset);
            this.position -= offset;
            this.buf.flip();
            return true;
        }
        int newSize = this.buf.capacity() * 2;
        CharBuffer newBuf = CharBuffer.allocate(newSize);
        newBuf.put(this.buf);
        newBuf.flip();
        this.translateSavedIndexes(offset);
        this.position -= offset;
        this.buf = newBuf;
        this.matcher.reset(this.buf);
        return true;
    }

    private void translateSavedIndexes(int offset) {
        if (this.savedScannerPosition != -1) {
            this.savedScannerPosition -= offset;
        }
    }

    private void throwFor() {
        this.skipped = false;
        if (this.sourceClosed && this.position == this.buf.limit()) {
            throw new NoSuchElementException();
        }
        throw new InputMismatchException();
    }

    private boolean hasTokenInBuffer() {
        this.matchValid = false;
        this.matcher.usePattern(this.delimPattern);
        this.matcher.region(this.position, this.buf.limit());
        if (this.matcher.lookingAt()) {
            this.position = this.matcher.end();
        }
        return this.position != this.buf.limit();
    }

    private String getCompleteTokenInBuffer(Pattern pattern) {
        this.matchValid = false;
        this.matcher.usePattern(this.delimPattern);
        if (!this.skipped) {
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.lookingAt()) {
                if (this.matcher.hitEnd() && !this.sourceClosed) {
                    this.needInput = true;
                    return null;
                }
                this.skipped = true;
                this.position = this.matcher.end();
            }
        }
        if (this.position == this.buf.limit()) {
            if (this.sourceClosed) {
                return null;
            }
            this.needInput = true;
            return null;
        }
        this.matcher.region(this.position, this.buf.limit());
        boolean foundNextDelim = this.matcher.find();
        if (foundNextDelim && this.matcher.end() == this.position) {
            foundNextDelim = this.matcher.find();
        }
        if (foundNextDelim) {
            if (this.matcher.requireEnd() && !this.sourceClosed) {
                this.needInput = true;
                return null;
            }
            int tokenEnd = this.matcher.start();
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            this.matcher.usePattern(pattern);
            this.matcher.region(this.position, tokenEnd);
            if (this.matcher.matches()) {
                String s = this.matcher.group();
                this.position = this.matcher.end();
                return s;
            }
            return null;
        }
        if (this.sourceClosed) {
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            this.matcher.usePattern(pattern);
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.matches()) {
                String s = this.matcher.group();
                this.position = this.matcher.end();
                return s;
            }
            return null;
        }
        this.needInput = true;
        return null;
    }

    private String findPatternInBuffer(Pattern pattern, int horizon) {
        this.matchValid = false;
        this.matcher.usePattern(pattern);
        int bufferLimit = this.buf.limit();
        int horizonLimit = -1;
        int searchLimit = bufferLimit;
        if (horizon > 0 && (horizonLimit = this.position + horizon) < bufferLimit) {
            searchLimit = horizonLimit;
        }
        this.matcher.region(this.position, searchLimit);
        if (this.matcher.find()) {
            if (this.matcher.hitEnd() && !this.sourceClosed) {
                if (searchLimit != horizonLimit) {
                    this.needInput = true;
                    return null;
                }
                if (searchLimit == horizonLimit && this.matcher.requireEnd()) {
                    this.needInput = true;
                    return null;
                }
            }
            this.position = this.matcher.end();
            return this.matcher.group();
        }
        if (this.sourceClosed) {
            return null;
        }
        if (horizon == 0 || searchLimit != horizonLimit) {
            this.needInput = true;
        }
        return null;
    }

    private String matchPatternInBuffer(Pattern pattern) {
        this.matchValid = false;
        this.matcher.usePattern(pattern);
        this.matcher.region(this.position, this.buf.limit());
        if (this.matcher.lookingAt()) {
            if (this.matcher.hitEnd() && !this.sourceClosed) {
                this.needInput = true;
                return null;
            }
            this.position = this.matcher.end();
            return this.matcher.group();
        }
        if (this.sourceClosed) {
            return null;
        }
        this.needInput = true;
        return null;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Scanner closed");
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.source instanceof Closeable) {
            try {
                ((Closeable)((Object)this.source)).close();
            }
            catch (IOException ioe) {
                this.lastException = ioe;
            }
        }
        this.sourceClosed = true;
        this.source = null;
        this.closed = true;
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Pattern delimiter() {
        return this.delimPattern;
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimPattern = pattern;
        return this;
    }

    public Scanner useDelimiter(String pattern) {
        this.delimPattern = this.patternCache.forName(pattern);
        return this;
    }

    public Locale locale() {
        return this.locale;
    }

    public Scanner useLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
        this.groupSeparator = "\\x{" + Integer.toHexString(dfs.getGroupingSeparator()) + "}";
        this.decimalSeparator = "\\x{" + Integer.toHexString(dfs.getDecimalSeparator()) + "}";
        this.nanString = Pattern.quote(dfs.getNaN());
        this.infinityString = Pattern.quote(dfs.getInfinity());
        this.positivePrefix = df.getPositivePrefix();
        if (this.positivePrefix.length() > 0) {
            this.positivePrefix = Pattern.quote(this.positivePrefix);
        }
        this.negativePrefix = df.getNegativePrefix();
        if (this.negativePrefix.length() > 0) {
            this.negativePrefix = Pattern.quote(this.negativePrefix);
        }
        this.positiveSuffix = df.getPositiveSuffix();
        if (this.positiveSuffix.length() > 0) {
            this.positiveSuffix = Pattern.quote(this.positiveSuffix);
        }
        this.negativeSuffix = df.getNegativeSuffix();
        if (this.negativeSuffix.length() > 0) {
            this.negativeSuffix = Pattern.quote(this.negativeSuffix);
        }
        this.integerPattern = null;
        this.floatPattern = null;
        return this;
    }

    public int radix() {
        return this.defaultRadix;
    }

    public Scanner useRadix(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix:" + radix);
        }
        if (this.defaultRadix == radix) {
            return this;
        }
        this.defaultRadix = radix;
        this.integerPattern = null;
        return this;
    }

    private void setRadix(int radix) {
        if (this.radix != radix) {
            this.integerPattern = null;
            this.radix = radix;
        }
    }

    public MatchResult match() {
        if (!this.matchValid) {
            throw new IllegalStateException("No match result available");
        }
        return this.matcher.toMatchResult();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.util.Scanner");
        sb.append("[delimiters=" + this.delimPattern + "]");
        sb.append("[position=" + this.position + "]");
        sb.append("[match valid=" + this.matchValid + "]");
        sb.append("[need input=" + this.needInput + "]");
        sb.append("[source closed=" + this.sourceClosed + "]");
        sb.append("[skipped=" + this.skipped + "]");
        sb.append("[group separator=" + this.groupSeparator + "]");
        sb.append("[decimal separator=" + this.decimalSeparator + "]");
        sb.append("[positive prefix=" + this.positivePrefix + "]");
        sb.append("[negative prefix=" + this.negativePrefix + "]");
        sb.append("[positive suffix=" + this.positiveSuffix + "]");
        sb.append("[negative suffix=" + this.negativeSuffix + "]");
        sb.append("[NaN string=" + this.nanString + "]");
        sb.append("[infinity string=" + this.infinityString + "]");
        return sb.toString();
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        this.saveState();
        while (!this.sourceClosed) {
            if (this.hasTokenInBuffer()) {
                return this.revertState(true);
            }
            this.readInput();
        }
        boolean result = this.hasTokenInBuffer();
        return this.revertState(result);
    }

    @Override
    public String next() {
        this.ensureOpen();
        this.clearCaches();
        while (true) {
            String token;
            if ((token = this.getCompleteTokenInBuffer(null)) != null) {
                this.matchValid = true;
                this.skipped = false;
                return token;
            }
            if (this.needInput) {
                this.readInput();
                continue;
            }
            this.throwFor();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext(String pattern) {
        return this.hasNext(this.patternCache.forName(pattern));
    }

    public String next(String pattern) {
        return this.next(this.patternCache.forName(pattern));
    }

    public boolean hasNext(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.hasNextPattern = null;
        this.saveState();
        while (true) {
            if (this.getCompleteTokenInBuffer(pattern) != null) {
                this.matchValid = true;
                this.cacheResult();
                return this.revertState(true);
            }
            if (!this.needInput) break;
            this.readInput();
        }
        return this.revertState(false);
    }

    public String next(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (this.hasNextPattern == pattern) {
            return this.getCachedResult();
        }
        this.clearCaches();
        while (true) {
            String token;
            if ((token = this.getCompleteTokenInBuffer(pattern)) != null) {
                this.matchValid = true;
                this.skipped = false;
                return token;
            }
            if (this.needInput) {
                this.readInput();
                continue;
            }
            this.throwFor();
        }
    }

    public boolean hasNextLine() {
        this.saveState();
        String result = this.findWithinHorizon(Scanner.linePattern(), 0);
        if (result != null) {
            MatchResult mr = this.match();
            String lineSep = mr.group(1);
            if (lineSep != null) {
                result = result.substring(0, result.length() - lineSep.length());
                this.cacheResult(result);
            } else {
                this.cacheResult();
            }
        }
        this.revertState();
        return result != null;
    }

    public String nextLine() {
        if (this.hasNextPattern == Scanner.linePattern()) {
            return this.getCachedResult();
        }
        this.clearCaches();
        String result = this.findWithinHorizon(linePattern, 0);
        if (result == null) {
            throw new NoSuchElementException("No line found");
        }
        MatchResult mr = this.match();
        String lineSep = mr.group(1);
        if (lineSep != null) {
            result = result.substring(0, result.length() - lineSep.length());
        }
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public String findInLine(String pattern) {
        return this.findInLine(this.patternCache.forName(pattern));
    }

    public String findInLine(Pattern pattern) {
        int endPosition;
        block4: {
            this.ensureOpen();
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.clearCaches();
            endPosition = 0;
            this.saveState();
            while (true) {
                String token;
                if ((token = this.findPatternInBuffer(Scanner.separatorPattern(), 0)) != null) {
                    endPosition = this.matcher.start();
                    break block4;
                }
                if (!this.needInput) break;
                this.readInput();
            }
            endPosition = this.buf.limit();
        }
        this.revertState();
        int horizonForLine = endPosition - this.position;
        if (horizonForLine == 0) {
            return null;
        }
        return this.findWithinHorizon(pattern, horizonForLine);
    }

    public String findWithinHorizon(String pattern, int horizon) {
        return this.findWithinHorizon(this.patternCache.forName(pattern), horizon);
    }

    public String findWithinHorizon(Pattern pattern, int horizon) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (horizon < 0) {
            throw new IllegalArgumentException("horizon < 0");
        }
        this.clearCaches();
        while (true) {
            String token;
            if ((token = this.findPatternInBuffer(pattern, horizon)) != null) {
                this.matchValid = true;
                return token;
            }
            if (!this.needInput) break;
            this.readInput();
        }
        return null;
    }

    public Scanner skip(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.clearCaches();
        while (true) {
            String token;
            if ((token = this.matchPatternInBuffer(pattern)) != null) {
                this.matchValid = true;
                this.position = this.matcher.end();
                return this;
            }
            if (!this.needInput) break;
            this.readInput();
        }
        throw new NoSuchElementException();
    }

    public Scanner skip(String pattern) {
        return this.skip(this.patternCache.forName(pattern));
    }

    public boolean hasNextBoolean() {
        return this.hasNext(Scanner.boolPattern());
    }

    public boolean nextBoolean() {
        this.clearCaches();
        return Boolean.parseBoolean(this.next(Scanner.boolPattern()));
    }

    public boolean hasNextByte() {
        return this.hasNextByte(this.defaultRadix);
    }

    public boolean hasNextByte(int radix) {
        this.setRadix(radix);
        boolean result = this.hasNext(this.integerPattern());
        if (result) {
            try {
                String s = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Byte.parseByte(s, radix);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public byte nextByte() {
        return this.nextByte(this.defaultRadix);
    }

    public byte nextByte(int radix) {
        if (this.typeCache != null && this.typeCache instanceof Byte && this.radix == radix) {
            byte val = (Byte)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(radix);
        this.clearCaches();
        try {
            String s = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                s = this.processIntegerToken(s);
            }
            return Byte.parseByte(s, radix);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextShort() {
        return this.hasNextShort(this.defaultRadix);
    }

    public boolean hasNextShort(int radix) {
        this.setRadix(radix);
        boolean result = this.hasNext(this.integerPattern());
        if (result) {
            try {
                String s = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Short.parseShort(s, radix);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public short nextShort() {
        return this.nextShort(this.defaultRadix);
    }

    public short nextShort(int radix) {
        if (this.typeCache != null && this.typeCache instanceof Short && this.radix == radix) {
            short val = (Short)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(radix);
        this.clearCaches();
        try {
            String s = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                s = this.processIntegerToken(s);
            }
            return Short.parseShort(s, radix);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextInt() {
        return this.hasNextInt(this.defaultRadix);
    }

    public boolean hasNextInt(int radix) {
        this.setRadix(radix);
        boolean result = this.hasNext(this.integerPattern());
        if (result) {
            try {
                String s = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Integer.parseInt(s, radix);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    private String processIntegerToken(String token) {
        int sufLen;
        String result = token.replaceAll("" + this.groupSeparator, "");
        boolean isNegative = false;
        int preLen = this.negativePrefix.length();
        if (preLen > 0 && result.startsWith(this.negativePrefix)) {
            isNegative = true;
            result = result.substring(preLen);
        }
        if ((sufLen = this.negativeSuffix.length()) > 0 && result.endsWith(this.negativeSuffix)) {
            isNegative = true;
            result = result.substring(result.length() - sufLen, result.length());
        }
        if (isNegative) {
            result = "-" + result;
        }
        return result;
    }

    public int nextInt() {
        return this.nextInt(this.defaultRadix);
    }

    public int nextInt(int radix) {
        if (this.typeCache != null && this.typeCache instanceof Integer && this.radix == radix) {
            int val = (Integer)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(radix);
        this.clearCaches();
        try {
            String s = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                s = this.processIntegerToken(s);
            }
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextLong() {
        return this.hasNextLong(this.defaultRadix);
    }

    public boolean hasNextLong(int radix) {
        this.setRadix(radix);
        boolean result = this.hasNext(this.integerPattern());
        if (result) {
            try {
                String s = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Long.parseLong(s, radix);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public long nextLong() {
        return this.nextLong(this.defaultRadix);
    }

    public long nextLong(int radix) {
        if (this.typeCache != null && this.typeCache instanceof Long && this.radix == radix) {
            long val = (Long)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(radix);
        this.clearCaches();
        try {
            String s = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                s = this.processIntegerToken(s);
            }
            return Long.parseLong(s, radix);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    private String processFloatToken(String token) {
        Matcher m;
        int sufLen;
        String result = token.replaceAll(this.groupSeparator, "");
        if (!this.decimalSeparator.equals("\\.")) {
            result = result.replaceAll(this.decimalSeparator, ".");
        }
        boolean isNegative = false;
        int preLen = this.negativePrefix.length();
        if (preLen > 0 && result.startsWith(this.negativePrefix)) {
            isNegative = true;
            result = result.substring(preLen);
        }
        if ((sufLen = this.negativeSuffix.length()) > 0 && result.endsWith(this.negativeSuffix)) {
            isNegative = true;
            result = result.substring(result.length() - sufLen, result.length());
        }
        if (result.equals(this.nanString)) {
            result = "NaN";
        }
        if (result.equals(this.infinityString)) {
            result = "Infinity";
        }
        if (isNegative) {
            result = "-" + result;
        }
        if ((m = NON_ASCII_DIGIT.matcher(result)).find()) {
            StringBuilder inASCII = new StringBuilder();
            for (int i = 0; i < result.length(); ++i) {
                char nextChar = result.charAt(i);
                if (Character.isDigit(nextChar)) {
                    int d = Character.digit(nextChar, 10);
                    if (d != -1) {
                        inASCII.append(d);
                        continue;
                    }
                    inASCII.append(nextChar);
                    continue;
                }
                inASCII.append(nextChar);
            }
            result = inASCII.toString();
        }
        return result;
    }

    public boolean hasNextFloat() {
        this.setRadix(10);
        boolean result = this.hasNext(this.floatPattern());
        if (result) {
            try {
                String s = this.processFloatToken(this.hasNextResult);
                this.typeCache = Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public float nextFloat() {
        if (this.typeCache != null && this.typeCache instanceof Float) {
            float val = ((Float)this.typeCache).floatValue();
            this.useTypeCache();
            return val;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            return Float.parseFloat(this.processFloatToken(this.next(this.floatPattern())));
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextDouble() {
        this.setRadix(10);
        boolean result = this.hasNext(this.floatPattern());
        if (result) {
            try {
                String s = this.processFloatToken(this.hasNextResult);
                this.typeCache = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public double nextDouble() {
        if (this.typeCache != null && this.typeCache instanceof Double) {
            double val = (Double)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            return Double.parseDouble(this.processFloatToken(this.next(this.floatPattern())));
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextBigInteger() {
        return this.hasNextBigInteger(this.defaultRadix);
    }

    public boolean hasNextBigInteger(int radix) {
        this.setRadix(radix);
        boolean result = this.hasNext(this.integerPattern());
        if (result) {
            try {
                String s = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = new BigInteger(s, radix);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public BigInteger nextBigInteger() {
        return this.nextBigInteger(this.defaultRadix);
    }

    public BigInteger nextBigInteger(int radix) {
        if (this.typeCache != null && this.typeCache instanceof BigInteger && this.radix == radix) {
            BigInteger val = (BigInteger)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(radix);
        this.clearCaches();
        try {
            String s = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                s = this.processIntegerToken(s);
            }
            return new BigInteger(s, radix);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public boolean hasNextBigDecimal() {
        this.setRadix(10);
        boolean result = this.hasNext(this.decimalPattern());
        if (result) {
            try {
                String s = this.processFloatToken(this.hasNextResult);
                this.typeCache = new BigDecimal(s);
            }
            catch (NumberFormatException nfe) {
                result = false;
            }
        }
        return result;
    }

    public BigDecimal nextBigDecimal() {
        if (this.typeCache != null && this.typeCache instanceof BigDecimal) {
            BigDecimal val = (BigDecimal)this.typeCache;
            this.useTypeCache();
            return val;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            String s = this.processFloatToken(this.next(this.decimalPattern()));
            return new BigDecimal(s);
        }
        catch (NumberFormatException nfe) {
            this.position = this.matcher.start();
            throw new InputMismatchException(nfe.getMessage());
        }
    }

    public Scanner reset() {
        this.delimPattern = WHITESPACE_PATTERN;
        this.useLocale(Locale.getDefault(Locale.Category.FORMAT));
        this.useRadix(10);
        this.clearCaches();
        return this;
    }
}

