/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BlockingProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EDT;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgressRunner<R> {
    private static final Logger LOG = Logger.getInstance(ProgressRunner.class);
    @NotNull
    private final @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> myComputation;
    private final boolean isSync;
    private final boolean isModal;
    private final ThreadToUse myThreadToUse;
    @NotNull
    private final @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> myProgressIndicatorFuture;

    public ProgressRunner(@NotNull @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> computation) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(2);
        }
        this(computation, false, false, ThreadToUse.POOLED, CompletableFuture.completedFuture(new EmptyProgressIndicator()));
    }

    private ProgressRunner(@NotNull @NotNull Function<? super @NotNull ProgressIndicator, ? extends R> computation, boolean sync, boolean modal, @NotNull ThreadToUse use, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        if (computation == null) {
            ProgressRunner.$$$reportNull$$$0(3);
        }
        if (use == null) {
            ProgressRunner.$$$reportNull$$$0(4);
        }
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(5);
        }
        this.myComputation = ClientId.decorateFunction(computation);
        this.isSync = sync;
        this.isModal = modal;
        this.myThreadToUse = use;
        this.myProgressIndicatorFuture = progressIndicatorFuture;
    }

    @NotNull
    public ProgressRunner<R> onThread(@NotNull ThreadToUse thread) {
        if (thread == null) {
            ProgressRunner.$$$reportNull$$$0(6);
        }
        return thread == this.myThreadToUse ? this : new ProgressRunner<R>(this.myComputation, this.isSync, this.isModal, thread, this.myProgressIndicatorFuture);
    }

    @NotNull
    public ProgressRunner<R> withProgress(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(8);
        }
        return this.myProgressIndicatorFuture == progressIndicatorFuture ? this : new ProgressRunner<R>(this.myComputation, this.isSync, this.isModal, this.myThreadToUse, progressIndicatorFuture);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public CompletableFuture<ProgressResult<R>> submit() {
        CompletableFuture<Object> resultFuture;
        boolean forceSyncExec = this.checkIfForceDirectExecNeeded();
        @NotNull CompletionStage progressFuture = this.myProgressIndicatorFuture.thenApply(progress -> {
            if (progress instanceof Disposable) {
                Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progress));
            }
            return progress;
        });
        Semaphore modalityEntered = new Semaphore(forceSyncExec ? 0 : 1);
        Supplier<Object> onThreadCallable = () -> this.lambda$submit$4(modalityEntered, (CompletableFuture)progressFuture);
        if (forceSyncExec) {
            resultFuture = new CompletableFuture<Object>();
            try {
                resultFuture.complete(onThreadCallable.get());
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        } else {
            resultFuture = ApplicationManager.getApplication().isDispatchThread() ? this.execFromEDT((CompletableFuture<ProgressIndicator>)progressFuture, modalityEntered, onThreadCallable) : this.normalExec((CompletableFuture<ProgressIndicator>)progressFuture, modalityEntered, onThreadCallable);
        }
        CompletionStage completionStage = resultFuture.handle((arg_0, arg_1) -> ProgressRunner.lambda$submit$5((CompletableFuture)progressFuture, arg_0, arg_1));
        if (completionStage == null) {
            ProgressRunner.$$$reportNull$$$0(10);
        }
        return completionStage;
    }

    private boolean checkIfForceDirectExecNeeded() {
        boolean forceDirectExec;
        if (this.isSync && EDT.isCurrentThreadEdt() && !ApplicationManager.getApplication().isWriteThread()) {
            throw new IllegalStateException("Running sync tasks on pure EDT (w/o IW lock) is dangerous for several reasons.");
        }
        if (!this.isSync && this.isModal && EDT.isCurrentThreadEdt()) {
            throw new IllegalStateException("Running async modal tasks from EDT is impossible: modal implies sync dialog show + polling events");
        }
        boolean bl = forceDirectExec = this.isSync && ApplicationManager.getApplication().isDispatchThread() && (ApplicationManager.getApplication().isWriteAccessAllowed() || !this.isModal);
        if (forceDirectExec) {
            String reason = ApplicationManager.getApplication().isWriteAccessAllowed() ? "inside Write Action" : "not modal execution";
            @NonNls String failedConstraints = "";
            if (this.isModal) {
                failedConstraints = failedConstraints + "Use Modal execution; ";
            }
            if (this.myThreadToUse == ThreadToUse.POOLED || this.myThreadToUse == ThreadToUse.FJ) {
                failedConstraints = failedConstraints + "Use pooled thread; ";
            }
            failedConstraints = failedConstraints.isEmpty() ? "none" : failedConstraints;
            Logger.getInstance(ProgressRunner.class).warn("Forced to sync exec on EDT. Reason: " + reason + ". Failed constraints: " + failedConstraints, new Throwable());
        }
        return forceDirectExec;
    }

    @NotNull
    private CompletableFuture<R> execFromEDT(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressFuture, @NotNull Semaphore modalityEntered, @NotNull Supplier<R> onThreadCallable) {
        CompletionStage<Object> resultFuture;
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(11);
        }
        if (modalityEntered == null) {
            ProgressRunner.$$$reportNull$$$0(12);
        }
        if (onThreadCallable == null) {
            ProgressRunner.$$$reportNull$$$0(13);
        }
        CompletableFuture taskFuture = this.launchTask(onThreadCallable, progressFuture);
        if (this.isModal) {
            CompletionStage blockingRunFuture = ((CompletableFuture)progressFuture.thenAccept(progressIndicator -> {
                if (progressIndicator instanceof BlockingProgressIndicator) {
                    ((BlockingProgressIndicator)progressIndicator).startBlocking(modalityEntered::up, taskFuture);
                } else {
                    Logger.getInstance(ProgressRunner.class).warn("Can't go modal without BlockingProgressIndicator");
                    modalityEntered.up();
                }
            })).exceptionally(throwable -> {
                taskFuture.completeExceptionally((Throwable)throwable);
                return null;
            });
            resultFuture = taskFuture.thenCombine(blockingRunFuture, (r, __) -> r);
        } else {
            resultFuture = taskFuture;
        }
        if (this.isSync) {
            try {
                resultFuture.get();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        CompletableFuture completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<R> normalExec(@NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressFuture, @NotNull Semaphore modalityEntered, @NotNull Supplier<R> onThreadCallable) {
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(15);
        }
        if (modalityEntered == null) {
            ProgressRunner.$$$reportNull$$$0(16);
        }
        if (onThreadCallable == null) {
            ProgressRunner.$$$reportNull$$$0(17);
        }
        if (this.isModal) {
            Function<ProgressIndicator, ProgressIndicator> modalityRunnable = progressIndicator -> {
                LaterInvocator.enterModal(progressIndicator, (ModalityStateEx)progressIndicator.getModalityState());
                modalityEntered.up();
                return progressIndicator;
            };
            progressFuture = progressFuture.thenApplyAsync(modalityRunnable, r -> {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    r.run();
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(r);
                }
            });
        }
        CompletionStage<Object> resultFuture = this.launchTask(onThreadCallable, (CompletableFuture<? extends ProgressIndicator>)progressFuture);
        if (this.isModal) {
            CompletionStage modalityExitFuture = ((CompletableFuture)resultFuture.handle((r, throwable) -> r)).thenAcceptBoth(progressFuture, (r, progressIndicator) -> {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    LaterInvocator.leaveModal(progressIndicator);
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> LaterInvocator.leaveModal(progressIndicator), progressIndicator.getModalityState());
                }
            });
            resultFuture = resultFuture.thenCombine(modalityExitFuture, (r, __) -> r);
        }
        if (this.isSync) {
            ProgressRunner.waitForFutureUnlockingThread(resultFuture);
        }
        CompletableFuture<R> completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    private static void waitForFutureUnlockingThread(@NotNull CompletableFuture<?> resultFuture) {
        if (resultFuture == null) {
            ProgressRunner.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isWriteThread()) {
            ProgressRunner.pollLaterInvocatorActively(resultFuture, LaterInvocator::pollWriteThreadEventsOnce);
            return;
        }
        if (EDT.isCurrentThreadEdt()) {
            throw new UnsupportedOperationException("Sync waiting from EDT is dangerous.");
        }
        try {
            resultFuture.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void pollLaterInvocatorActively(@NotNull CompletableFuture<?> resultFuture, @NotNull Runnable pollAction) {
        if (resultFuture == null) {
            ProgressRunner.$$$reportNull$$$0(20);
        }
        if (pollAction == null) {
            ProgressRunner.$$$reportNull$$$0(21);
        }
        ApplicationManagerEx.getApplicationEx().runUnlockingIntendedWrite(() -> {
            while (true) {
                try {
                    resultFuture.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    ApplicationManagerEx.getApplicationEx().runIntendedWriteActionOnCurrentThread(pollAction);
                }
                finally {
                    continue;
                }
                break;
            }
            return null;
        });
    }

    public static boolean isCanceled(@NotNull Future<? extends ProgressIndicator> progressFuture) {
        if (progressFuture == null) {
            ProgressRunner.$$$reportNull$$$0(22);
        }
        try {
            return progressFuture.get().isCanceled();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Throwable unwrap(@Nullable Throwable exception) {
        return exception instanceof CompletionException || exception instanceof ExecutionException ? exception.getCause() : exception;
    }

    @NotNull
    private CompletableFuture<R> launchTask(@NotNull Supplier<R> callable, @NotNull @NotNull CompletableFuture<? extends @NotNull ProgressIndicator> progressIndicatorFuture) {
        CompletableFuture<Object> resultFuture;
        if (callable == null) {
            ProgressRunner.$$$reportNull$$$0(23);
        }
        if (progressIndicatorFuture == null) {
            ProgressRunner.$$$reportNull$$$0(24);
        }
        switch (this.myThreadToUse) {
            case POOLED: {
                resultFuture = CompletableFuture.supplyAsync(callable, AppExecutorUtil.getAppExecutorService());
                break;
            }
            case FJ: {
                resultFuture = CompletableFuture.supplyAsync(callable, ForkJoinPool.commonPool());
                break;
            }
            case WRITE: {
                resultFuture = new CompletableFuture();
                Runnable runnable = () -> {
                    try {
                        resultFuture.complete(callable.get());
                    }
                    catch (Throwable e) {
                        resultFuture.completeExceptionally(e);
                    }
                };
                progressIndicatorFuture.whenComplete((progressIndicator, throwable) -> {
                    if (throwable != null) {
                        resultFuture.completeExceptionally((Throwable)throwable);
                        return;
                    }
                    ModalityState processModality = progressIndicator.getModalityState();
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(runnable, processModality);
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.myThreadToUse));
            }
        }
        CompletableFuture<Object> completableFuture = resultFuture;
        if (completableFuture == null) {
            ProgressRunner.$$$reportNull$$$0(25);
        }
        return completableFuture;
    }

    private static /* synthetic */ ProgressResult lambda$submit$5(CompletableFuture progressFuture, Object result2, Throwable e) {
        Throwable throwable = ProgressRunner.unwrap(e);
        if (LOG.isDebugEnabled()) {
            if (throwable != null) {
                LOG.debug("ProgressRunner: task completed with throwable", throwable);
            }
            if (ProgressRunner.isCanceled(progressFuture)) {
                LOG.debug("ProgressRunner: task cancelled");
            }
        }
        return new ProgressResult<Object>(result2, throwable instanceof ProcessCanceledException || ProgressRunner.isCanceled(progressFuture), throwable);
    }

    private /* synthetic */ Object lambda$submit$4(Semaphore modalityEntered, CompletableFuture progressFuture) {
        ProgressIndicator progressIndicator;
        Ref result2 = Ref.create();
        if (this.isModal) {
            modalityEntered.waitFor();
        }
        try {
            progressIndicator = (ProgressIndicator)progressFuture.join();
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't get progress", e);
        }
        if (progressIndicator == null) {
            throw new IllegalStateException("Expected not-null progress indicator but got null from " + this.myProgressIndicatorFuture);
        }
        ProgressManager.getInstance().runProcess(() -> result2.set(this.myComputation.apply(progressIndicator)), progressIndicator);
        return result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 5: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorFuture";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressFuture";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityEntered";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onThreadCallable";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultFuture";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pollAction";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "submitAndGet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "execFromEDT";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "normalExec";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "launchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onThread";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withProgress";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execFromEDT";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "normalExec";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForFutureUnlockingThread";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pollLaterInvocatorActively";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCanceled";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "launchTask";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ThreadToUse {
        WRITE,
        POOLED,
        FJ;

    }
}

