/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"buildUnreachableAfterNothingType", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableForVerifier", "getSourceLocation", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "Lorg/jetbrains/kotlin/ir/IrElement;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "backend.wasm"})
public final class LocationUtilsKt {
    @NotNull
    public static final SourceLocation getSourceLocation(@NotNull IrElement $this$getSourceLocation, @Nullable IrFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter($this$getSourceLocation, "<this>");
        if (fileEntry == null) {
            return SourceLocation.Companion.NoLocation("fileEntry is null");
        }
        String path = fileEntry.getName();
        int startLine = fileEntry.getLineNumber($this$getSourceLocation.getStartOffset());
        int startColumn = fileEntry.getColumnNumber($this$getSourceLocation.getStartOffset());
        if (startLine < 0 || startColumn < 0) {
            return SourceLocation.Companion.NoLocation("startLine or startColumn < 0");
        }
        return new SourceLocation.Location(path, startLine, startColumn);
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter($this$buildUnreachableForVerifier, "<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter($this$buildUnreachableAfterNothingType, "<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }
}

