/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.events;

import org.jetbrains.kotlin.org.apache.maven.wagon.Wagon;
import org.jetbrains.kotlin.org.apache.maven.wagon.events.WagonEvent;

public class SessionEvent
extends WagonEvent {
    private int eventType;
    private Exception exception;

    public SessionEvent(Wagon wagon, int eventType) {
        super(wagon);
        this.eventType = eventType;
    }

    public SessionEvent(Wagon wagon, Exception exception) {
        super(wagon);
        this.exception = exception;
        this.eventType = 9;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionEvent[");
        switch (this.eventType) {
            case 1: {
                sb.append("CONNECTION_CLOSED");
                break;
            }
            case 3: {
                sb.append("CONNECTION_DISCONNECTED");
                break;
            }
            case 2: {
                sb.append("CONNECTION_DISCONNECTING");
                break;
            }
            case 9: {
                sb.append("CONNECTION_ERROR_OCCURRED");
                break;
            }
            case 7: {
                sb.append("CONNECTION_LOGGED_IN");
                break;
            }
            case 8: {
                sb.append("CONNECTION_LOGGED_OFF");
                break;
            }
            case 6: {
                sb.append("CONNECTION_OPENED");
                break;
            }
            case 5: {
                sb.append("CONNECTION_OPENING");
                break;
            }
            case 4: {
                sb.append("CONNECTION_CONNECTION_REFUSED");
                break;
            }
            default: {
                sb.append(this.eventType);
            }
        }
        sb.append("|");
        sb.append(this.getWagon().getRepository()).append("|");
        sb.append(this.source);
        if (this.exception != null) {
            sb.append("|");
            sb.append(this.exception.getClass().getName()).append(":");
            sb.append(this.exception.getMessage());
        }
        sb.append("]");
        return sb.toString();
    }
}

