/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.WeakMap;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IMapping;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XCurrentContext;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.WeakHashMap;

public class UnoRuntime {
    @Deprecated
    public static final boolean DEBUG = false;
    private static final WeakHashMap<Object, String> oidMap = new WeakHashMap();
    private static final String uniqueKeyHostPrefix = Integer.toString(new Object().hashCode(), 16) + ":";
    private static final Object uniqueKeyLock = new Object();
    private static long uniqueKeyTime = System.currentTimeMillis();
    private static long uniqueKeyCount = Long.MIN_VALUE;
    private static final String oidSuffix = ";java[];" + UnoRuntime.getUniqueKey();
    private static final ThreadLocal<XCurrentContext> currentContext = new ThreadLocal();
    private static final WeakMap<String, IEnvironment> environments = new WeakMap();
    private static final WeakMap<String, IBridge> bridges = new WeakMap();

    @Deprecated
    public UnoRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueKey() {
        Object object = uniqueKeyLock;
        synchronized (object) {
            if (uniqueKeyCount == Long.MAX_VALUE) {
                long time = System.currentTimeMillis();
                while (time == uniqueKeyTime) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                uniqueKeyTime = time;
                uniqueKeyCount = Long.MIN_VALUE;
            }
            long l = uniqueKeyCount++;
            return uniqueKeyHostPrefix + Long.toString(uniqueKeyTime, 16) + ":" + Long.toString(l, 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateOid(Object object) {
        String oid = null;
        if (object instanceof IQueryInterface) {
            oid = ((IQueryInterface)object).getOid();
        }
        if (oid == null) {
            WeakHashMap<Object, String> weakHashMap = oidMap;
            synchronized (weakHashMap) {
                oid = oidMap.get(object);
                if (oid == null) {
                    oid = UUID.randomUUID().toString() + oidSuffix;
                    oidMap.put(object, oid);
                }
            }
        }
        return oid;
    }

    public static Object queryInterface(Type type, Object object) {
        Class<?> c;
        Any a;
        if (object instanceof Any && (a = (Any)object).getType().getTypeClass() == TypeClass.INTERFACE) {
            object = a.getObject();
        }
        if (object instanceof IQueryInterface && (object = ((IQueryInterface)object).queryInterface(type)) instanceof Any) {
            a = (Any)object;
            Object object2 = object = a.getType().getTypeClass() == TypeClass.INTERFACE ? a.getObject() : null;
        }
        if ((c = type.getZClass()) == null || !c.isInstance(object)) {
            object = null;
        }
        return object;
    }

    public static <T> T queryInterface(Class<T> zInterface, Object object) {
        return (T)UnoRuntime.queryInterface(new Type(zInterface), object);
    }

    public static boolean areSame(Object any1, Object any2) {
        Any a1 = Any.complete(any1);
        Any a2 = Any.complete(any2);
        Type t = a1.getType();
        if (!a2.getType().equals(t)) {
            return false;
        }
        Object v1 = a1.getObject();
        Object v2 = a2.getObject();
        switch (t.getTypeClass().getValue()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return v1.equals(v2);
            }
            case 20: {
                int n = Array.getLength(v1);
                if (n != Array.getLength(v2)) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (UnoRuntime.areSame(Array.get(v1, i), Array.get(v2, i))) continue;
                    return false;
                }
                return true;
            }
            case 15: {
                return v1 == v2;
            }
            case 17: 
            case 19: {
                FieldDescription[] fs;
                try {
                    fs = TypeDescription.getTypeDescription(t).getFieldDescriptions();
                }
                catch (ClassNotFoundException e) {
                    throw new java.lang.RuntimeException(e);
                }
                for (int i = 0; i < fs.length; ++i) {
                    Type ft = new Type(fs[i].getTypeDescription());
                    try {
                        if (UnoRuntime.areSame(UnoRuntime.completeValue(ft, fs[i].getField().get(v1)), UnoRuntime.completeValue(ft, fs[i].getField().get(v2)))) continue;
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        throw new java.lang.RuntimeException(e);
                    }
                }
                return true;
            }
            case 22: {
                return v1 == v2 || v1 instanceof IQueryInterface && ((IQueryInterface)v1).isSame(v2) || v2 instanceof IQueryInterface && ((IQueryInterface)v2).isSame(v1);
            }
        }
        throw new java.lang.RuntimeException("com.sun.star.uno.Any has bad com.sun.star.uno.TypeClass");
    }

    public static final Object completeValue(Type type, Object value) {
        if (value != null) {
            return value;
        }
        switch (type.getTypeClass().getValue()) {
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return (byte)0;
            }
            case 4: 
            case 5: {
                return (short)0;
            }
            case 6: 
            case 7: {
                return 0;
            }
            case 8: 
            case 9: {
                return 0L;
            }
            case 10: {
                return Float.valueOf(0.0f);
            }
            case 11: {
                return 0.0;
            }
            case 1: {
                return Character.valueOf('\u0000');
            }
            case 12: {
                return "";
            }
            case 13: {
                return Type.VOID;
            }
            case 14: 
            case 22: {
                return null;
            }
            case 20: {
                return Array.newInstance(type.getZClass().getComponentType(), 0);
            }
            case 17: {
                try {
                    return type.getZClass().getConstructor(null).newInstance(null);
                }
                catch (java.lang.RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new java.lang.RuntimeException(e);
                }
            }
            case 15: {
                try {
                    return type.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null);
                }
                catch (java.lang.RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new java.lang.RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("com.sun.star.uno.UnoRuntime.completeValue called with bad com.sun.star.uno.Type");
    }

    public static XCurrentContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(XCurrentContext context) {
        if (context == null) {
            currentContext.remove();
        } else {
            currentContext.set(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IEnvironment getEnvironment(String name, Object context) throws Exception {
        WeakMap<String, IEnvironment> weakMap = environments;
        synchronized (weakMap) {
            IEnvironment env = (IEnvironment)WeakMap.getValue(environments.get(name + context));
            if (env == null) {
                Class<?> c = Class.forName("com.sun.star.lib.uno.environments." + name + "." + name + "_environment");
                Constructor<?> ctor = c.getConstructor(Object.class);
                env = (IEnvironment)ctor.newInstance(context);
                environments.put((Object)(name + context), (Object)env);
            }
            return env;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IBridge getBridge(IEnvironment from, IEnvironment to, Object[] args) throws Exception {
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            String name = from.getName() + "_" + to.getName();
            String hashName = from.getName() + from.getContext() + "_" + to.getName() + to.getContext();
            IBridge bridge = (IBridge)WeakMap.getValue(bridges.get(hashName));
            if (bridge == null) {
                Class<?> zClass = null;
                String className = name + "_bridge";
                try {
                    zClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    className = "com.sun.star.lib.uno.bridges." + name + "." + className;
                    zClass = Class.forName(className);
                }
                Class[] signature = new Class[]{IEnvironment.class, IEnvironment.class, args.getClass()};
                Constructor<?> constructor = zClass.getConstructor(signature);
                Object[] iargs = new Object[]{from, to, args};
                bridge = (IBridge)constructor.newInstance(iargs);
                bridges.put((Object)hashName, (Object)bridge);
            }
            return bridge;
        }
    }

    @Deprecated
    public static IBridge getBridgeByName(String from, Object fromContext, String to, Object toContext, Object[] args) throws Exception {
        return UnoRuntime.getBridge(UnoRuntime.getEnvironment(from, fromContext), UnoRuntime.getEnvironment(to, toContext), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IBridge[] getBridges() {
        ArrayList<IBridge> l = new ArrayList<IBridge>();
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            Iterator<WeakReference<IBridge>> i = bridges.values().iterator();
            while (i.hasNext()) {
                IBridge o = (IBridge)WeakMap.getValue(i.next());
                if (o == null) continue;
                l.add(o);
            }
        }
        return l.toArray(new IBridge[l.size()]);
    }

    @Deprecated
    public static IMapping getMapping(IEnvironment from, IEnvironment to) throws Exception {
        IBridge bridge;
        try {
            bridge = UnoRuntime.getBridge(from, to, null);
        }
        catch (ClassNotFoundException e) {
            bridge = new BridgeTurner(UnoRuntime.getBridge(to, from, null));
        }
        return new MappingWrapper(bridge);
    }

    @Deprecated
    public static IMapping getMappingByName(String from, String to) throws Exception {
        return UnoRuntime.getMapping(UnoRuntime.getEnvironment(from, null), UnoRuntime.getEnvironment(to, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean reset() {
        WeakMap<String, IBridge> weakMap = bridges;
        synchronized (weakMap) {
            Iterator<WeakReference<IBridge>> i = bridges.values().iterator();
            while (i.hasNext()) {
                IBridge b = (IBridge)WeakMap.getValue(i.next());
                if (b == null) continue;
                try {
                    b.dispose();
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + e);
                }
            }
            bridges.clear();
        }
        environments.clear();
        return bridges.isEmpty() && environments.isEmpty();
    }

    private static final class BridgeTurner
    implements IBridge {
        private final IBridge bridge;

        public BridgeTurner(IBridge bridge) {
            this.bridge = bridge;
        }

        @Override
        public Object mapInterfaceTo(Object object, Type type) {
            return this.bridge.mapInterfaceFrom(object, type);
        }

        @Override
        public Object mapInterfaceFrom(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }

        @Override
        public IEnvironment getSourceEnvironment() {
            return this.bridge.getTargetEnvironment();
        }

        @Override
        public IEnvironment getTargetEnvironment() {
            return this.bridge.getSourceEnvironment();
        }

        @Override
        public void acquire() {
            this.bridge.acquire();
        }

        @Override
        public void release() {
            this.bridge.release();
        }

        @Override
        public void dispose() throws InterruptedException, IOException {
            this.bridge.dispose();
        }
    }

    private static final class MappingWrapper
    implements IMapping {
        private final IBridge bridge;

        public MappingWrapper(IBridge bridge) {
            this.bridge = bridge;
        }

        @Override
        public Object mapInterface(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }
    }
}

