/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HtmlResourceBundle
extends ResourceBundle {
    private static final Pattern PATTERN_DIV = Pattern.compile("<div\\s+id=\"([^\"]+)\"");
    private static final Pattern PATTERN_KEY = Pattern.compile("(.*?)(?:\\.(\\d+))?");
    private LinkedHashMap<String, String> messages = new LinkedHashMap();

    public HtmlResourceBundle(InputStream input, ResourceBundle parent) throws IOException {
        String line;
        this.setParent(parent);
        BufferedReader br = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        boolean inDiv = false;
        String currentId = null;
        ArrayList<String> currentLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            Matcher matcher;
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("<div")) {
                inDiv = true;
                matcher = PATTERN_DIV.matcher(trimmedLine);
                if (!matcher.find()) continue;
                currentId = matcher.group(1);
                continue;
            }
            if (trimmedLine.startsWith("</div>")) {
                if (currentId != null && (matcher = PATTERN_KEY.matcher(currentId)).matches()) {
                    String key = matcher.group(1);
                    this.messages.put(key, this.toMessage(currentLines));
                }
                currentLines.clear();
                currentId = null;
                inDiv = false;
                continue;
            }
            if (!inDiv) continue;
            currentLines.add(trimmedLine);
        }
        input.close();
    }

    @NotNull
    private String toMessage(List<String> currentLines) {
        StringBuilder buffer = new StringBuilder();
        for (String currentLine : currentLines) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(currentLine.trim());
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        Set<String> keySet = this.messages.keySet();
        if (this.parent != null) {
            keySet = new LinkedHashSet<String>(keySet);
            Enumeration<String> en = this.parent.getKeys();
            while (en.hasMoreElements()) {
                keySet.add(en.nextElement());
            }
        }
        return Collections.enumeration(keySet);
    }

    @Override
    protected Object handleGetObject(@NotNull String key) {
        return this.messages.get(key);
    }
}

