/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.CalendarBorderProperties;
import com.github.lgooddatepicker.optionalusertools.CalendarListener;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.CalendarSelectionEvent;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.github.lgooddatepicker.zinternaltools.JIntegerTextField;
import com.github.lgooddatepicker.zinternaltools.MouseLiberalAdapter;
import com.github.lgooddatepicker.zinternaltools.YearMonthChangeEvent;
import com.privatejgoodies.forms.factories.CC;
import com.privatejgoodies.forms.layout.CellConstraints;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CalendarPanel
extends JPanel {
    private ArrayList<JLabel> dateLabels;
    private JLabel topLeftLabel;
    private ArrayList<JLabel> weekdayLabels;
    private ArrayList<JLabel> weekNumberLabels;
    private JLabel[][] borderLabels;
    private ArrayList<CalendarListener> calendarListeners = new ArrayList();
    private static final Point constantFirstWeekdayLabelCell = new Point(4, 2);
    private static final Point constantFirstWeekNumberLabelCell = new Point(2, 6);
    private static final Point constantFirstDateLabelCell = new Point(4, 6);
    private static final Dimension constantSizeOfCenterPanelBorders = new Dimension(2, 5);
    private static final Point constantTopLeftLabelCell = new Point(2, 2);
    private static final Insets constantWeekNumberLabelInsets = new Insets(0, 6, 0, 5);
    private LocalDate displayedSelectedDate = null;
    private YearMonth displayedYearMonth = null;
    private boolean isIndependentCalendarPanel;
    private EmptyBorder labelIndicatorEmptyBorder = new EmptyBorder(3, 2, 3, 2);
    private DatePickerSettings settings;
    private final PopupCancelWatcher yearPopupCancelWatcher = new PopupCancelWatcher();
    private final PopupCancelWatcher monthPopupCancelWatcher = new PopupCancelWatcher();
    private JIntegerTextField yearTextField;
    private JPanel headerControlsPanel;
    private JButton buttonPreviousYear;
    private JButton buttonPreviousMonth;
    private JPanel monthAndYearOuterPanel;
    private JPanel monthAndYearInnerPanel;
    private JLabel labelMonth;
    private JLabel labelYear;
    private JButton buttonNextMonth;
    private JButton buttonNextYear;
    private JPanel centerPanel;
    private JPanel footerPanel;
    private JLabel labelSetDateToToday;
    private JLabel labelClearDate;
    private JPanel yearEditorPanel;
    private JButton doneEditingYearButton;
    private JPopupMenu popupMonth = new JPopupMenu();
    private JPopupMenu popupYear = new JPopupMenu();

    public CalendarPanel() {
        this((DatePickerSettings)null, true);
    }

    public CalendarPanel(DatePickerSettings settings2) {
        this(settings2, true);
    }

    public CalendarPanel(DatePicker parentDatePicker) {
        this(parentDatePicker.getSettings(), false);
    }

    private CalendarPanel(DatePickerSettings datePickerSettings, boolean isIndependentCalendarPanelInstance) {
        this.isIndependentCalendarPanel = isIndependentCalendarPanelInstance;
        this.popupMonth.addPopupMenuListener(this.monthPopupCancelWatcher);
        this.popupYear.addPopupMenuListener(this.yearPopupCancelWatcher);
        this.displayedYearMonth = YearMonth.now(this.getClockForToday());
        this.initComponents();
        this.zAddMouseListenersToTodayAndClearButtons();
        this.yearTextField = new JIntegerTextField(4);
        this.yearTextField.setMaximumValue(999999999);
        this.yearTextField.setMinimumValue(-999999999);
        this.yearTextField.setMargin(new Insets(1, 1, 1, 1));
        this.yearEditorPanel.add((Component)this.yearTextField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.yearTextField.numberChangeListener = new JIntegerTextField.IntegerTextFieldNumberChangeListener(){

            @Override
            public void integerTextFieldNumberChanged(JIntegerTextField source2, int newValue) {
                YearMonth newYearMonth = YearMonth.of(newValue, CalendarPanel.this.displayedYearMonth.getMonth());
                CalendarPanel.this.drawCalendar(newYearMonth);
            }
        };
        this.doneEditingYearButton.setMargin(new Insets(0, 0, 0, 0));
        this.doneEditingYearButton.setText("\u2713");
        this.setOpaque(true);
        this.buttonPreviousYear.setMargin(new Insets(1, 2, 1, 2));
        this.buttonNextYear.setMargin(new Insets(1, 2, 1, 2));
        this.buttonPreviousMonth.setMargin(new Insets(1, 2, 1, 2));
        this.buttonNextMonth.setMargin(new Insets(1, 2, 1, 2));
        this.addDateLabels();
        this.addWeekdayLabels();
        this.addTopLeftLabel();
        this.addWeekNumberLabels();
        this.addBorderLabels();
        this.setSettings(datePickerSettings);
    }

    private void addBorderLabels() {
        Point[] allBorderLabelIndexes;
        this.borderLabels = new JLabel[6][6];
        int[] labelLocations_X_forColumn = new int[]{0, 1, 2, 3, 4, 11};
        int[] labelLocations_Y_forRow = new int[]{0, 1, 2, 5, 6, 12};
        int[] labelWidthsInCells_forColumn = new int[]{0, 1, 1, 1, 7, 1};
        int[] labelHeightsInCells_forRow = new int[]{0, 1, 3, 1, 6, 1};
        for (Point index : allBorderLabelIndexes = new Point[]{new Point(1, 1), new Point(2, 1), new Point(3, 1), new Point(4, 1), new Point(5, 1), new Point(1, 2), new Point(3, 2), new Point(5, 2), new Point(1, 3), new Point(2, 3), new Point(3, 3), new Point(4, 3), new Point(5, 3), new Point(1, 4), new Point(3, 4), new Point(5, 4), new Point(1, 5), new Point(2, 5), new Point(3, 5), new Point(4, 5), new Point(5, 5)}) {
            Point labelLocationCell = new Point(labelLocations_X_forColumn[index.x], labelLocations_Y_forRow[index.y]);
            Dimension labelSizeInCells = new Dimension(labelWidthsInCells_forColumn[index.x], labelHeightsInCells_forRow[index.y]);
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setVisible(false);
            this.borderLabels[index.x][index.y] = label;
            this.centerPanel.add((Component)label, CC.xywh(labelLocationCell.x, labelLocationCell.y, labelSizeInCells.width, labelSizeInCells.height));
        }
    }

    private void addDateLabels() {
        this.dateLabels = new ArrayList();
        for (int i = 0; i < 42; ++i) {
            int dateLabelColumnX = i % 7 + CalendarPanel.constantFirstDateLabelCell.x;
            int dateLabelRowY = i / 7 + CalendarPanel.constantFirstDateLabelCell.y;
            JLabel dateLabel = new JLabel();
            dateLabel.setHorizontalAlignment(0);
            dateLabel.setVerticalAlignment(0);
            dateLabel.setBackground(Color.white);
            dateLabel.setForeground(Color.black);
            dateLabel.setBorder(null);
            dateLabel.setOpaque(true);
            dateLabel.setText("" + i);
            CellConstraints constraints = CC.xy(dateLabelColumnX, dateLabelRowY);
            this.centerPanel.add((Component)dateLabel, constraints);
            this.dateLabels.add(dateLabel);
            dateLabel.addMouseListener(new MouseLiberalAdapter(){

                @Override
                public void mouseLiberalClick(MouseEvent e) {
                    CalendarPanel.this.dateLabelMousePressed(e);
                }
            });
        }
    }

    private void addWeekNumberLabels() {
        this.weekNumberLabels = new ArrayList();
        int weekNumberLabelColumnX = CalendarPanel.constantFirstWeekNumberLabelCell.x;
        int weekNumberLabelWidthInCells = 1;
        int weekNumberLabelHeightInCells = 1;
        for (int i = 0; i < 6; ++i) {
            int weekNumberLabelRowY = i + CalendarPanel.constantFirstWeekNumberLabelCell.y;
            JLabel weekNumberLabel = new JLabel();
            weekNumberLabel.setHorizontalAlignment(0);
            weekNumberLabel.setVerticalAlignment(0);
            weekNumberLabel.setBorder(new EmptyBorder(constantWeekNumberLabelInsets));
            weekNumberLabel.setOpaque(true);
            weekNumberLabel.setText("3" + i);
            weekNumberLabel.setVisible(false);
            CellConstraints constraints = CC.xywh(weekNumberLabelColumnX, weekNumberLabelRowY, weekNumberLabelWidthInCells, weekNumberLabelHeightInCells);
            this.centerPanel.add((Component)weekNumberLabel, constraints);
            this.weekNumberLabels.add(weekNumberLabel);
        }
        this.setSizeOfWeekNumberLabels();
    }

    private void addWeekdayLabels() {
        this.weekdayLabels = new ArrayList();
        int weekdayLabelRowY = CalendarPanel.constantFirstWeekdayLabelCell.y;
        int weekdayLabelWidthInCells = 1;
        int weekdayLabelHeightInCells = 3;
        for (int i = 0; i < 7; ++i) {
            int weekdayLabelColumnX = i + CalendarPanel.constantFirstWeekdayLabelCell.x;
            JLabel weekdayLabel = new JLabel();
            weekdayLabel.setHorizontalAlignment(0);
            weekdayLabel.setVerticalAlignment(0);
            weekdayLabel.setBorder(new EmptyBorder(0, 2, 0, 2));
            weekdayLabel.setOpaque(true);
            weekdayLabel.setText("wd" + i);
            CellConstraints constraints = CC.xywh(weekdayLabelColumnX, weekdayLabelRowY, weekdayLabelWidthInCells, weekdayLabelHeightInCells);
            this.centerPanel.add((Component)weekdayLabel, constraints);
            this.weekdayLabels.add(weekdayLabel);
        }
    }

    private void addTopLeftLabel() {
        this.topLeftLabel = new JLabel();
        this.topLeftLabel.setOpaque(true);
        this.topLeftLabel.setVisible(false);
        this.centerPanel.add((Component)this.topLeftLabel, CC.xywh(CalendarPanel.constantTopLeftLabelCell.x, CalendarPanel.constantTopLeftLabelCell.y, 1, 3));
    }

    public void addCalendarListener(CalendarListener listener) {
        this.calendarListeners.add(listener);
    }

    private void buttonNextMonthActionPerformed(ActionEvent e) {
        try {
            this.drawCalendar(this.displayedYearMonth.plusMonths(1L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buttonNextYearActionPerformed(ActionEvent e) {
        try {
            this.drawCalendar(this.displayedYearMonth.plusYears(1L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buttonPreviousMonthActionPerformed(ActionEvent e) {
        try {
            this.drawCalendar(this.displayedYearMonth.minusMonths(1L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buttonPreviousYearActionPerformed(ActionEvent e) {
        try {
            this.drawCalendar(this.displayedYearMonth.minusYears(1L));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dateLabelMousePressed(MouseEvent e) {
        JLabel label = (JLabel)e.getSource();
        String labelText = label.getText();
        if ("".equals(labelText)) {
            return;
        }
        int dayOfMonth = Integer.parseInt(labelText);
        LocalDate clickedDate = LocalDate.of(this.displayedYearMonth.getYear(), this.displayedYearMonth.getMonth(), dayOfMonth);
        this.userSelectedADate(clickedDate);
    }

    public void drawCalendar() {
        this.drawCalendar(this.displayedYearMonth);
    }

    private void drawCalendar(int year, Month month) {
        this.drawCalendar(YearMonth.of(year, month));
    }

    private void drawCalendar(YearMonth newYearMonth) {
        this.drawCalendar(newYearMonth, null);
    }

    private void drawCalendar(YearMonth newYearMonth, YearMonth oldYearMonthOrNull) {
        if (this.settings == null) {
            return;
        }
        YearMonth oldYearMonth = oldYearMonthOrNull == null ? this.displayedYearMonth : oldYearMonthOrNull;
        this.displayedYearMonth = newYearMonth;
        for (CalendarListener calendarListener : this.calendarListeners) {
            YearMonthChangeEvent yearMonthChangeEvent = new YearMonthChangeEvent(this, this.displayedYearMonth, oldYearMonth);
            calendarListener.yearMonthChanged(yearMonthChangeEvent);
        }
        Month displayedMonth = newYearMonth.getMonth();
        int displayedYear = newYearMonth.getYear();
        DateFormatSymbols symbols = DateFormatSymbols.getInstance(this.settings.getLocale());
        String[] localShortDaysOfWeek = symbols.getShortWeekdays();
        int zeroBasedMonthIndex = displayedMonth.getValue() - 1;
        String localizedFullMonth = this.settings.getTranslationArrayStandaloneLongMonthNames()[zeroBasedMonthIndex];
        String localizedShortMonth = this.settings.getTranslationArrayStandaloneShortMonthNames()[zeroBasedMonthIndex];
        LocalDate firstDayOfMonth = LocalDate.of(displayedYear, displayedMonth, 1);
        DayOfWeek firstDayOfWeekOfMonth = firstDayOfMonth.getDayOfWeek();
        int lastDateOfMonth = this.getLastDayOfMonth(this.displayedYearMonth);
        boolean selectedDateIsInDisplayedMonth = this.displayedSelectedDate != null && this.displayedSelectedDate.getYear() == displayedYear && this.displayedSelectedDate.getMonth() == displayedMonth;
        Color calendarPanelBackgroundColor = this.settings.getColor(DatePickerSettings.DateArea.BackgroundOverallCalendarPanel);
        this.setBackground(calendarPanelBackgroundColor);
        this.headerControlsPanel.setBackground(calendarPanelBackgroundColor);
        this.monthAndYearOuterPanel.setBackground(calendarPanelBackgroundColor);
        this.footerPanel.setBackground(calendarPanelBackgroundColor);
        Color navigationButtonsColor = this.settings.getColor(DatePickerSettings.DateArea.BackgroundMonthAndYearNavigationButtons);
        this.buttonPreviousYear.setBackground(navigationButtonsColor);
        this.buttonNextYear.setBackground(navigationButtonsColor);
        this.buttonPreviousMonth.setBackground(navigationButtonsColor);
        this.buttonNextMonth.setBackground(navigationButtonsColor);
        this.buttonPreviousYear.setFont(this.settings.getFontMonthAndYearNavigationButtons());
        this.buttonNextYear.setFont(this.settings.getFontMonthAndYearNavigationButtons());
        this.buttonPreviousMonth.setFont(this.settings.getFontMonthAndYearNavigationButtons());
        this.buttonNextMonth.setFont(this.settings.getFontMonthAndYearNavigationButtons());
        this.buttonPreviousYear.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearNavigationButtons));
        this.buttonNextYear.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearNavigationButtons));
        this.buttonPreviousMonth.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearNavigationButtons));
        this.buttonNextMonth.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearNavigationButtons));
        this.labelMonth.setFont(this.settings.getFontMonthAndYearMenuLabels());
        this.labelYear.setFont(this.settings.getFontMonthAndYearMenuLabels());
        this.labelSetDateToToday.setFont(this.settings.getFontTodayLabel());
        this.labelClearDate.setFont(this.settings.getFontClearLabel());
        this.labelMonth.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearMenuLabels));
        this.labelYear.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearMenuLabels));
        this.labelSetDateToToday.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextTodayLabel));
        this.labelClearDate.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextClearLabel));
        if (this.monthAndYearInnerPanel.isAncestorOf(this.yearEditorPanel)) {
            this.labelMonth.setText(localizedShortMonth);
        } else {
            this.labelMonth.setText(localizedFullMonth);
        }
        final String displayedYearString = "" + displayedYear;
        this.labelYear.setText(displayedYearString);
        if (!displayedYearString.equals(this.yearTextField.getText())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((CalendarPanel)CalendarPanel.this).yearTextField.skipNotificationOfNumberChangeListenerWhileTrue = true;
                    CalendarPanel.this.yearTextField.setText(displayedYearString);
                    ((CalendarPanel)CalendarPanel.this).yearTextField.skipNotificationOfNumberChangeListenerWhileTrue = false;
                }
            });
        }
        ArrayList<DayOfWeek> daysOfWeekAsDisplayed = new ArrayList<DayOfWeek>();
        int isoFirstDayOfWeekValue = this.settings.getFirstDayOfWeekDisplayedOnCalendar().getValue();
        int isoLastDayOfWeekOverflowed = isoFirstDayOfWeekValue + 6;
        int weekdayLabelArrayIndex = 0;
        for (int dayOfWeek = isoFirstDayOfWeekValue; dayOfWeek <= isoLastDayOfWeekOverflowed; ++dayOfWeek) {
            int localShortDaysOfWeekArrayIndex = dayOfWeek % 7 + 1;
            int isoDayOfWeek = dayOfWeek > 7 ? dayOfWeek - 7 : dayOfWeek;
            DayOfWeek currentDayOfWeek = DayOfWeek.of(isoDayOfWeek);
            daysOfWeekAsDisplayed.add(currentDayOfWeek);
            this.weekdayLabels.get(weekdayLabelArrayIndex).setText(localShortDaysOfWeek[localShortDaysOfWeekArrayIndex]);
            ++weekdayLabelArrayIndex;
        }
        ArrayList<LocalDate> firstDateInEachUsedRow = new ArrayList<LocalDate>();
        boolean insideValidRange = false;
        int dayOfMonth = 1;
        JComponent selectedDateLabel = null;
        DateVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        DateHighlightPolicy highlightPolicy = this.settings.getHighlightPolicy();
        for (int dateLabelArrayIndex = 0; dateLabelArrayIndex < this.dateLabels.size(); ++dateLabelArrayIndex) {
            JLabel dateLabel = this.dateLabels.get(dateLabelArrayIndex);
            dateLabel.setBackground(this.settings.getColor(DatePickerSettings.DateArea.CalendarBackgroundNormalDates));
            dateLabel.setForeground(this.settings.getColor(DatePickerSettings.DateArea.CalendarTextNormalDates));
            dateLabel.setFont(this.settings.getFontCalendarDateLabels());
            dateLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
            dateLabel.setEnabled(true);
            dateLabel.setToolTipText(null);
            int daysOfWeekAsDisplayedArrayIndex = dateLabelArrayIndex % 7;
            if (daysOfWeekAsDisplayed.get(daysOfWeekAsDisplayedArrayIndex) == firstDayOfWeekOfMonth && dateLabelArrayIndex < 7) {
                insideValidRange = true;
            }
            if (dayOfMonth > lastDateOfMonth) {
                insideValidRange = false;
            }
            if (insideValidRange) {
                LocalDate currentDate = LocalDate.of(displayedYear, displayedMonth, dayOfMonth);
                if (dayOfMonth == 1) {
                    try {
                        LocalDate firstDateOfFirstRow = currentDate.minusDays(dateLabelArrayIndex);
                        firstDateInEachUsedRow.add(firstDateOfFirstRow);
                    }
                    catch (Exception e) {
                        firstDateInEachUsedRow.add(LocalDate.MIN);
                    }
                } else if (dateLabelArrayIndex % 7 == 0) {
                    firstDateInEachUsedRow.add(currentDate);
                }
                boolean dateIsVetoed = InternalUtilities.isDateVetoed(vetoPolicy, currentDate);
                HighlightInformation highlightInfo = null;
                if (highlightPolicy != null) {
                    highlightInfo = highlightPolicy.getHighlightInformationOrNull(currentDate);
                }
                if (dateIsVetoed) {
                    dateLabel.setEnabled(false);
                    dateLabel.setBackground(this.settings.getColor(DatePickerSettings.DateArea.CalendarBackgroundVetoedDates));
                }
                if (!dateIsVetoed && highlightInfo != null) {
                    Color colorBackground = this.settings.getColor(DatePickerSettings.DateArea.CalendarDefaultBackgroundHighlightedDates);
                    Color colorText = this.settings.getColor(DatePickerSettings.DateArea.CalendarDefaultTextHighlightedDates);
                    if (highlightInfo.colorBackground != null) {
                        colorBackground = highlightInfo.colorBackground;
                    }
                    if (highlightInfo.colorText != null) {
                        colorText = highlightInfo.colorText;
                    }
                    dateLabel.setBackground(colorBackground);
                    dateLabel.setForeground(colorText);
                    if (highlightInfo.tooltipText != null && !highlightInfo.tooltipText.isEmpty()) {
                        dateLabel.setToolTipText(highlightInfo.tooltipText);
                    }
                }
                if (selectedDateIsInDisplayedMonth && this.displayedSelectedDate != null && this.displayedSelectedDate.getDayOfMonth() == dayOfMonth) {
                    selectedDateLabel = dateLabel;
                }
                dateLabel.setText("" + dayOfMonth);
                ++dayOfMonth;
                continue;
            }
            dateLabel.setText("");
        }
        if (selectedDateLabel != null) {
            selectedDateLabel.setBackground(this.settings.getColor(DatePickerSettings.DateArea.CalendarBackgroundSelectedDate));
            selectedDateLabel.setBorder(new LineBorder(this.settings.getColor(DatePickerSettings.DateArea.CalendarBorderSelectedDate)));
        }
        boolean showWeekNumbers = this.settings.getWeekNumbersDisplayed();
        int usedRowCount = firstDateInEachUsedRow.size();
        WeekFields weekNumberRules = this.settings.getWeekNumberRules();
        this.topLeftLabel.setVisible(showWeekNumbers);
        for (int weekNumberLabelIndex = 0; weekNumberLabelIndex < this.weekNumberLabels.size(); ++weekNumberLabelIndex) {
            JLabel currentLabel = this.weekNumberLabels.get(weekNumberLabelIndex);
            currentLabel.setVisible(showWeekNumbers);
            currentLabel.setText("");
            if (!showWeekNumbers || weekNumberRules == null || weekNumberLabelIndex >= usedRowCount) continue;
            LocalDate firstDateInRow = (LocalDate)firstDateInEachUsedRow.get(weekNumberLabelIndex);
            int weekNumber = this.zGetWeekNumberForASevenDayRange(firstDateInRow, weekNumberRules, false);
            currentLabel.setText("" + weekNumber);
        }
        this.topLeftLabel.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundTopLeftLabelAboveWeekNumbers));
        for (JLabel weekdayLabel : this.weekdayLabels) {
            weekdayLabel.setBackground(this.settings.getColorBackgroundWeekdayLabels());
            weekdayLabel.setForeground(this.settings.getColor(DatePickerSettings.DateArea.CalendarTextWeekdays));
            weekdayLabel.setFont(this.settings.getFontCalendarWeekdayLabels());
        }
        for (JLabel weekNumberLabel : this.weekNumberLabels) {
            weekNumberLabel.setBackground(this.settings.getColorBackgroundWeekNumberLabels());
            weekNumberLabel.setForeground(this.settings.getColor(DatePickerSettings.DateArea.CalendarTextWeekNumbers));
            weekNumberLabel.setFont(this.settings.getFontCalendarWeekNumberLabels());
        }
        this.setSizeOfWeekNumberLabels();
        String todayDateString = this.settings.getFormatForTodayButton().format(LocalDate.now(this.settings.getClock()));
        String todayLabel = this.settings.getTranslationToday() + ":  " + todayDateString;
        this.labelSetDateToToday.setText(todayLabel);
        boolean todayIsVetoed = InternalUtilities.isDateVetoed(vetoPolicy, LocalDate.now(this.settings.getClock()));
        this.labelSetDateToToday.setEnabled(!todayIsVetoed);
        this.zApplyVisibilityOfButtons();
        this.labelClearDate.setText(this.settings.getTranslationClear());
        this.setSizeOfMonthYearPanel();
        this.setSizeOfDatePanelCell();
        this.repaint();
    }

    public ArrayList<CalendarListener> getCalendarListeners() {
        return new ArrayList<CalendarListener>(this.calendarListeners);
    }

    public YearMonth getDisplayedYearMonth() {
        return this.displayedYearMonth;
    }

    public LocalDate getSelectedDate() {
        return this.displayedSelectedDate;
    }

    public DatePickerSettings getSettings() {
        return this.settings;
    }

    private int getLastDayOfMonth(YearMonth yearMonth) {
        LocalDate firstDayOfMonth = LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
        int lastDayOfMonth = firstDayOfMonth.lengthOfMonth();
        return lastDayOfMonth;
    }

    private Point getMonthOrYearMenuLocation(JLabel sourceLabel, JPopupMenu filledPopupMenu) {
        Rectangle labelBounds = sourceLabel.getBounds();
        int menuHeight = filledPopupMenu.getPreferredSize().height;
        int popupX = labelBounds.x + labelBounds.width + 1;
        int popupY = labelBounds.y + labelBounds.height / 2 - menuHeight / 2;
        return new Point(popupX, popupY);
    }

    private void labelClearDateMousePressed(MouseEvent e) {
        this.userSelectedADate(null);
    }

    private void labelIndicatorMouseEntered(MouseEvent e) {
        DateVetoPolicy vetoPolicy;
        boolean todayIsVetoed;
        if (this.settings == null) {
            return;
        }
        JLabel label = (JLabel)e.getSource();
        if (label == this.labelSetDateToToday && (todayIsVetoed = InternalUtilities.isDateVetoed(vetoPolicy = this.settings.getVetoPolicy(), LocalDate.now(this.settings.getClock())))) {
            return;
        }
        if (label == this.labelMonth && !this.settings.getEnableMonthMenu()) {
            return;
        }
        if (label == this.labelYear && !this.settings.getEnableYearMenu()) {
            return;
        }
        label.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundCalendarPanelLabelsOnHover));
        label.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextCalendarPanelLabelsOnHover));
        label.setBorder(new CompoundBorder(new LineBorder(Color.GRAY), this.labelIndicatorEmptyBorder));
    }

    private void labelIndicatorMouseExited(MouseEvent e) {
        JLabel label = (JLabel)e.getSource();
        this.labelIndicatorSetColorsToDefaultState(label);
    }

    private void labelIndicatorSetColorsToDefaultState(JLabel label) {
        if (label == null || this.settings == null) {
            return;
        }
        if (label == this.labelMonth || label == this.labelYear) {
            label.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundMonthAndYearMenuLabels));
            label.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextMonthAndYearMenuLabels));
            this.monthAndYearInnerPanel.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundMonthAndYearMenuLabels));
        }
        if (label == this.labelSetDateToToday) {
            label.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundTodayLabel));
            label.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextTodayLabel));
        }
        if (label == this.labelClearDate) {
            label.setBackground(this.settings.getColor(DatePickerSettings.DateArea.BackgroundClearLabel));
            label.setForeground(this.settings.getColor(DatePickerSettings.DateArea.TextClearLabel));
        }
        label.setBorder(new CompoundBorder(new EmptyBorder(1, 1, 1, 1), this.labelIndicatorEmptyBorder));
    }

    private void labelMonthIndicatorMousePressed(MouseEvent e) {
        if (this.settings == null) {
            return;
        }
        if (!this.settings.getEnableMonthMenu()) {
            return;
        }
        if (this.monthPopupCancelWatcher.wasJustCanceled()) {
            return;
        }
        this.popupMonth.removeAll();
        String[] allLocalMonths = this.settings.getTranslationArrayStandaloneLongMonthNames();
        for (int i = 0; i < allLocalMonths.length; ++i) {
            String localMonth = allLocalMonths[i];
            final int localMonthZeroBasedIndexTemp = i;
            if (localMonth.isEmpty()) continue;
            this.popupMonth.add(new JMenuItem(new AbstractAction(localMonth){
                int localMonthZeroBasedIndex;
                {
                    super(x0);
                    this.localMonthZeroBasedIndex = localMonthZeroBasedIndexTemp;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarPanel.this.drawCalendar(CalendarPanel.this.displayedYearMonth.getYear(), Month.of(this.localMonthZeroBasedIndex + 1));
                }
            }));
        }
        Point menuLocation = this.getMonthOrYearMenuLocation(this.labelMonth, this.popupMonth);
        this.popupMonth.show(this.monthAndYearInnerPanel, menuLocation.x, menuLocation.y);
    }

    private void labelSetDateToTodayMousePressed(MouseEvent e) {
        this.userSelectedADate(LocalDate.now(this.getClockForToday()));
    }

    private void labelYearIndicatorMousePressed(MouseEvent e) {
        if (!this.settings.getEnableYearMenu()) {
            return;
        }
        if (this.yearPopupCancelWatcher.wasJustCanceled()) {
            return;
        }
        int firstYearDifference = -11;
        int lastYearDifference = 11;
        this.popupYear.removeAll();
        for (int yearDifference = firstYearDifference; yearDifference <= lastYearDifference; ++yearDifference) {
            try {
                YearMonth choiceYearMonth = this.displayedYearMonth.plusYears(yearDifference);
                String choiceYearMonthString = "" + choiceYearMonth.getYear();
                this.popupYear.add(new JMenuItem(new AbstractAction(choiceYearMonthString){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String chosenMenuText = ((JMenuItem)e.getSource()).getText();
                        int chosenYear = Integer.parseInt(chosenMenuText);
                        CalendarPanel.this.drawCalendar(chosenYear, CalendarPanel.this.displayedYearMonth.getMonth());
                    }
                }));
                continue;
            }
            catch (Exception choiceYearMonth) {
                // empty catch block
            }
        }
        String choiceOtherYearString = "( . . . )";
        this.popupYear.add(new JMenuItem(new AbstractAction(choiceOtherYearString){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.otherYearMenuItemClicked();
            }
        }));
        Point menuLocation = this.getMonthOrYearMenuLocation(this.labelYear, this.popupYear);
        this.popupYear.show(this.monthAndYearInnerPanel, menuLocation.x, menuLocation.y);
    }

    private void doneEditingYearButtonActionPerformed(ActionEvent e) {
        this.monthAndYearInnerPanel.remove(this.yearEditorPanel);
        this.drawCalendar(this.displayedYearMonth);
    }

    private void otherYearMenuItemClicked() {
        this.monthAndYearInnerPanel.add((Component)this.yearEditorPanel, CC.xy(3, 1));
        this.drawCalendar(this.displayedYearMonth);
        this.yearTextField.requestFocusInWindow();
    }

    public void removeCalendarListener(CalendarListener listener) {
        this.calendarListeners.remove(listener);
    }

    public void setSelectedDate(LocalDate selectedDate) {
        this.setSelectedDateWithoutShowing(selectedDate);
        YearMonth yearMonthToShow = selectedDate == null ? YearMonth.now(this.getClockForToday()) : YearMonth.from(selectedDate);
        this.setDisplayedYearMonth(yearMonthToShow);
    }

    public void setSelectedDateWithoutShowing(LocalDate selectedDate) {
        this.zInternalChangeSelectedDateProcedure(selectedDate, null);
    }

    public void setDisplayedYearMonth(YearMonth yearMonth) {
        if (yearMonth == null) {
            throw new RuntimeException("CalendarPanel.setDisplayedYearMonth(), The displayed year and month cannot be set to null.");
        }
        this.drawCalendar(yearMonth);
    }

    @Override
    public void setLocale(Locale locale) {
        DatePickerSettings currentSettings = this.getSettings();
        if (currentSettings != null) {
            currentSettings.setLocale(locale);
        }
        super.setLocale(locale);
    }

    private void setSizeOfDatePanelCell() {
        if (this.settings == null) {
            return;
        }
        int minimumHeight = this.settings.getSizeDatePanelMinimumHeight();
        int minimumWidth = this.settings.getSizeDatePanelMinimumWidth();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        int panelHeight = minimumHeight;
        int panelWidth = minimumWidth;
        panelHeight += panelHeight % 7;
        panelWidth += panelWidth % 7;
        layout.rowHeights[3] = panelHeight + CalendarPanel.constantSizeOfCenterPanelBorders.height;
        layout.columnWidths[1] = panelWidth + CalendarPanel.constantSizeOfCenterPanelBorders.width;
        this.doLayout();
        this.validate();
    }

    private void setSizeOfWeekNumberLabels() {
        JLabel firstLabel = this.weekNumberLabels.get(0);
        Font font = firstLabel.getFont();
        FontMetrics fontMetrics = firstLabel.getFontMetrics(font);
        int width = fontMetrics.stringWidth("53 ");
        width += CalendarPanel.constantWeekNumberLabelInsets.left;
        Dimension size = new Dimension(width += CalendarPanel.constantWeekNumberLabelInsets.right, 1);
        for (JLabel currentLabel : this.weekNumberLabels) {
            currentLabel.setMinimumSize(size);
            currentLabel.setPreferredSize(size);
        }
        this.topLeftLabel.setMinimumSize(size);
        this.topLeftLabel.setPreferredSize(size);
    }

    private void setSizeOfMonthYearPanel() {
        if (this.settings == null) {
            return;
        }
        Font font = this.labelMonth.getFont();
        Canvas canvas = new Canvas();
        FontMetrics metrics = canvas.getFontMetrics(font);
        int heightNavigationButtons = this.buttonPreviousYear.getPreferredSize().height;
        int preferredHeightMonthLabel = this.labelMonth.getPreferredSize().height;
        int preferredHeightYearLabel = this.labelYear.getPreferredSize().height;
        int monthFontHeight = metrics.getHeight();
        int monthFontHeightWithPadding = monthFontHeight + 2;
        int panelHeight = Math.max(monthFontHeightWithPadding, Math.max(preferredHeightMonthLabel, Math.max(preferredHeightYearLabel, heightNavigationButtons)));
        DateFormatSymbols symbols = DateFormatSymbols.getInstance(this.settings.getLocale());
        String[] allLocalMonths = symbols.getMonths();
        int longestMonthPixels = 0;
        for (String month : allLocalMonths) {
            int monthPixels = metrics.stringWidth(month);
            longestMonthPixels = monthPixels > longestMonthPixels ? monthPixels : longestMonthPixels;
        }
        int yearPixels = metrics.stringWidth("_2000");
        Dimension size = new Dimension(longestMonthPixels + yearPixels + 12, panelHeight);
        this.monthAndYearOuterPanel.setMinimumSize(size);
        this.monthAndYearOuterPanel.setPreferredSize(size);
        this.doLayout();
        this.validate();
    }

    private void userSelectedADate(LocalDate selectedDate) {
        YearMonth selectedDateYearMonth;
        DateVetoPolicy vetoPolicy;
        if (this.settings == null) {
            return;
        }
        if (selectedDate != null && InternalUtilities.isDateVetoed(vetoPolicy = this.settings.getVetoPolicy(), selectedDate)) {
            return;
        }
        YearMonth oldYearMonth = this.displayedYearMonth;
        this.displayedYearMonth = selectedDate != null ? (selectedDateYearMonth = YearMonth.from(selectedDate)) : this.settings.zGetDefaultYearMonthAsUsed();
        this.zInternalChangeSelectedDateProcedure(selectedDate, oldYearMonth);
        if (this.settings.getParentDatePicker() != null) {
            DatePicker parent = this.settings.getParentDatePicker();
            parent.setDate(selectedDate);
            parent.closePopup();
        }
    }

    private void zAddMouseListenersToTodayAndClearButtons() {
        this.labelSetDateToToday.addMouseListener(new MouseLiberalAdapter(){

            @Override
            public void mouseLiberalClick(MouseEvent e) {
                CalendarPanel.this.labelSetDateToTodayMousePressed(e);
            }

            @Override
            public void mouseEnter(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseEntered(e);
            }

            @Override
            public void mouseExit(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseExited(e);
            }
        });
        this.labelClearDate.addMouseListener(new MouseLiberalAdapter(){

            @Override
            public void mouseLiberalClick(MouseEvent e) {
                CalendarPanel.this.labelClearDateMousePressed(e);
            }

            @Override
            public void mouseEnter(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseEntered(e);
            }

            @Override
            public void mouseExit(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseExited(e);
            }
        });
    }

    private void zInternalChangeSelectedDateProcedure(LocalDate newDate, YearMonth oldYearMonthOrNull) {
        LocalDate oldDate = this.displayedSelectedDate;
        this.displayedSelectedDate = newDate;
        for (CalendarListener calendarListener : this.calendarListeners) {
            CalendarSelectionEvent dateSelectionEvent = new CalendarSelectionEvent(this, newDate, oldDate);
            calendarListener.selectedDateChanged(dateSelectionEvent);
        }
        this.drawCalendar(this.displayedYearMonth, oldYearMonthOrNull);
        this.firePropertyChange("selectedDate", oldDate, newDate);
    }

    void zSetAllLabelIndicatorColorsToDefaultState() {
        this.labelIndicatorSetColorsToDefaultState(this.labelMonth);
        this.labelIndicatorSetColorsToDefaultState(this.labelYear);
        this.labelIndicatorSetColorsToDefaultState(this.labelSetDateToToday);
        this.labelIndicatorSetColorsToDefaultState(this.labelClearDate);
    }

    private void initComponents() {
        this.headerControlsPanel = new JPanel();
        this.buttonPreviousYear = new JButton();
        this.buttonPreviousMonth = new JButton();
        this.monthAndYearOuterPanel = new JPanel();
        this.monthAndYearInnerPanel = new JPanel();
        this.labelMonth = new JLabel();
        this.labelYear = new JLabel();
        this.buttonNextMonth = new JButton();
        this.buttonNextYear = new JButton();
        this.centerPanel = new JPanel();
        this.footerPanel = new JPanel();
        this.labelSetDateToToday = new JLabel();
        this.labelClearDate = new JLabel();
        this.yearEditorPanel = new JPanel();
        this.doneEditingYearButton = new JButton();
        this.setLayout(new GridBagLayout());
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{5, 0, 5, 0};
        ((GridBagLayout)this.getLayout()).rowHeights = new int[]{6, 0, 5, 80, 5, 0, 5, 0};
        ((GridBagLayout)this.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.headerControlsPanel.setLayout(new FormLayout("3*(pref), pref:grow, 3*(pref)", "fill:pref:grow"));
        ((FormLayout)this.headerControlsPanel.getLayout()).setColumnGroups(new int[][]{{1, 2, 6, 7}});
        this.buttonPreviousYear.setText("<<");
        this.buttonPreviousYear.setFocusable(false);
        this.buttonPreviousYear.setFocusPainted(false);
        this.buttonPreviousYear.setHorizontalTextPosition(0);
        this.buttonPreviousYear.setMargin(new Insets(5, 6, 5, 6));
        this.buttonPreviousYear.setFont(new Font("Monospaced", 1, 12));
        this.buttonPreviousYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.buttonPreviousYearActionPerformed(e);
            }
        });
        this.headerControlsPanel.add((Component)this.buttonPreviousYear, CC.xy(1, 1));
        this.buttonPreviousMonth.setText(" < ");
        this.buttonPreviousMonth.setFocusable(false);
        this.buttonPreviousMonth.setFocusPainted(false);
        this.buttonPreviousMonth.setHorizontalTextPosition(0);
        this.buttonPreviousMonth.setMargin(new Insets(5, 6, 5, 6));
        this.buttonPreviousMonth.setFont(new Font("Monospaced", 1, 12));
        this.buttonPreviousMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.buttonPreviousMonthActionPerformed(e);
            }
        });
        this.headerControlsPanel.add((Component)this.buttonPreviousMonth, CC.xy(2, 1));
        this.monthAndYearOuterPanel.setLayout(new FormLayout("pref:grow, pref, pref:grow", "fill:pref:grow"));
        this.monthAndYearInnerPanel.setLayout(new FormLayout("pref, [1px,pref], pref", "fill:pref:grow"));
        this.labelMonth.setText("September");
        this.labelMonth.setHorizontalAlignment(4);
        this.labelMonth.setOpaque(true);
        this.labelMonth.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CalendarPanel.this.labelMonthIndicatorMousePressed(e);
            }
        });
        this.monthAndYearInnerPanel.add((Component)this.labelMonth, CC.xy(1, 1));
        this.labelYear.setText("2100");
        this.labelYear.setOpaque(true);
        this.labelYear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CalendarPanel.this.labelIndicatorMouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CalendarPanel.this.labelYearIndicatorMousePressed(e);
            }
        });
        this.monthAndYearInnerPanel.add((Component)this.labelYear, CC.xy(3, 1));
        this.monthAndYearOuterPanel.add((Component)this.monthAndYearInnerPanel, CC.xy(2, 1));
        this.headerControlsPanel.add((Component)this.monthAndYearOuterPanel, CC.xy(4, 1));
        this.buttonNextMonth.setText(" > ");
        this.buttonNextMonth.setFocusable(false);
        this.buttonNextMonth.setFocusPainted(false);
        this.buttonNextMonth.setHorizontalTextPosition(0);
        this.buttonNextMonth.setMargin(new Insets(5, 6, 5, 6));
        this.buttonNextMonth.setFont(new Font("Monospaced", 1, 12));
        this.buttonNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.buttonNextMonthActionPerformed(e);
            }
        });
        this.headerControlsPanel.add((Component)this.buttonNextMonth, CC.xy(6, 1));
        this.buttonNextYear.setText(">>");
        this.buttonNextYear.setFocusable(false);
        this.buttonNextYear.setFocusPainted(false);
        this.buttonNextYear.setHorizontalTextPosition(0);
        this.buttonNextYear.setMargin(new Insets(5, 6, 5, 6));
        this.buttonNextYear.setFont(new Font("Monospaced", 1, 12));
        this.buttonNextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.buttonNextYearActionPerformed(e);
            }
        });
        this.headerControlsPanel.add((Component)this.buttonNextYear, CC.xy(7, 1));
        this.add((Component)this.headerControlsPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.setBackground(new Color(210, 210, 210));
        this.centerPanel.setLayout(new FormLayout("3*(min), 7*(default:grow), min", "fill:min, fill:2px, fill:default:grow, fill:1px, fill:min, 6*(fill:default:grow), fill:min"));
        ((FormLayout)this.centerPanel.getLayout()).setColumnGroups(new int[][]{{4, 5, 6, 7, 8, 9, 10}});
        ((FormLayout)this.centerPanel.getLayout()).setRowGroups(new int[][]{{3, 6, 7, 8, 9, 10, 11}});
        this.add((Component)this.centerPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.footerPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.footerPanel.getLayout()).columnWidths = new int[]{6, 0, 0, 0, 6, 0};
        ((GridBagLayout)this.footerPanel.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.footerPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.footerPanel.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.labelSetDateToToday.setText("Today: Feb 12, 2016");
        this.labelSetDateToToday.setHorizontalAlignment(0);
        this.labelSetDateToToday.setOpaque(true);
        this.footerPanel.add((Component)this.labelSetDateToToday, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.labelClearDate.setText("Clear");
        this.labelClearDate.setOpaque(true);
        this.footerPanel.add((Component)this.labelClearDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.footerPanel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.yearEditorPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.yearEditorPanel.getLayout()).columnWidths = new int[]{40, 1, 26, 0};
        ((GridBagLayout)this.yearEditorPanel.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.yearEditorPanel.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.yearEditorPanel.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.doneEditingYearButton.setFocusPainted(false);
        this.doneEditingYearButton.setFocusable(false);
        this.doneEditingYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.doneEditingYearButtonActionPerformed(e);
            }
        });
        this.yearEditorPanel.add((Component)this.doneEditingYearButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void zApplyBorderPropertiesInstance(CalendarBorderProperties borderProperties) {
        Point ul = borderProperties.upperLeft;
        Point lr = borderProperties.lowerRight;
        Color color = borderProperties.backgroundColor;
        Integer thickness = borderProperties.thicknessInPixels;
        if (ul == null || lr == null || ul.x < 1 || ul.x > 5 || ul.y < 1 || ul.y > 5 || lr.x < 1 || lr.x > 5 || lr.y < 1 || lr.y > 5 || ul.x > lr.x || ul.y > lr.y) {
            throw new RuntimeException("CalendarPanel.setBorderProperties(), The supplied points cannot be null, and they must have x and y coordinates with values in the range of 1 to 5 (inclusive). Additionally, the upper left point values must be less than or equal to the lower right point values.");
        }
        for (int x = ul.x; x <= lr.x; ++x) {
            for (int y = ul.y; y <= lr.y; ++y) {
                JLabel borderLabel = this.borderLabels[x][y];
                if (borderLabel == null) continue;
                if (color != null) {
                    borderLabel.setBackground(color);
                }
                if (thickness == null) continue;
                boolean isVisible = thickness > 0;
                borderLabel.setVisible(isVisible);
                Dimension minimumSize = isVisible ? new Dimension(thickness, thickness) : new Dimension(1, 1);
                borderLabel.setMinimumSize(minimumSize);
            }
        }
    }

    void zApplyBorderPropertiesList() {
        if (this.settings == null) {
            return;
        }
        CalendarBorderProperties clearBordersProperties = new CalendarBorderProperties(new Point(1, 1), new Point(5, 5), Color.black, 0);
        this.zApplyBorderPropertiesInstance(clearBordersProperties);
        for (CalendarBorderProperties borderProperties : this.settings.getBorderPropertiesList()) {
            this.zApplyBorderPropertiesInstance(borderProperties);
        }
        if (!this.settings.getWeekNumbersDisplayed()) {
            CalendarBorderProperties hideWeekNumberBorders = new CalendarBorderProperties(new Point(1, 1), new Point(2, 5), Color.black, 0);
            this.zApplyBorderPropertiesInstance(hideWeekNumberBorders);
        }
        this.drawCalendar();
    }

    void zApplyVisibilityOfButtons() {
        boolean showNextMonth = this.settings.getVisibleNextMonthButton();
        boolean showNextYear = this.settings.getVisibleNextYearButton();
        boolean showPreviousMonth = this.settings.getVisiblePreviousMonthButton();
        boolean showPreviousYear = this.settings.getVisiblePreviousYearButton();
        boolean showMonthMenu = this.settings.getVisibleMonthMenuButton();
        boolean showTodayButton = this.settings.getVisibleTodayButton();
        boolean yearMenuSetting = this.settings.getVisibleYearMenuButton();
        boolean yearEditorPanelIsDisplayed = this.yearEditorPanel.getParent() != null;
        boolean clearButtonSetting = this.settings.getVisibleClearButton();
        boolean emptyDatesAllowed = this.settings.getAllowEmptyDates();
        this.buttonNextMonth.setVisible(showNextMonth);
        this.buttonNextYear.setVisible(showNextYear);
        this.buttonPreviousMonth.setVisible(showPreviousMonth);
        this.buttonPreviousYear.setVisible(showPreviousYear);
        this.labelMonth.setVisible(showMonthMenu);
        this.labelSetDateToToday.setVisible(showTodayButton);
        boolean showYearMenu = yearMenuSetting && !yearEditorPanelIsDisplayed;
        this.labelYear.setVisible(showYearMenu);
        boolean showClearButton = clearButtonSetting && emptyDatesAllowed;
        this.labelClearDate.setVisible(showClearButton);
        boolean showMonthAndYearInnerPanel = showMonthMenu || showYearMenu || yearEditorPanelIsDisplayed;
        boolean showHeaderControlsPanel = showMonthAndYearInnerPanel || showNextMonth || showNextYear || showPreviousMonth || showPreviousYear;
        this.monthAndYearInnerPanel.setVisible(showMonthAndYearInnerPanel);
        this.headerControlsPanel.setVisible(showHeaderControlsPanel);
        boolean showFooterPanel = showTodayButton || showClearButton;
        this.footerPanel.setVisible(showFooterPanel);
    }

    private Integer zGetWeekNumberForASevenDayRange(LocalDate firstDateInRange, WeekFields weekFieldRules, boolean requireUnanimousWeekNumber) {
        ArrayList<Integer> weekNumbersList = new ArrayList<Integer>();
        for (int daysIntoTheFuture = 0; daysIntoTheFuture <= 6; ++daysIntoTheFuture) {
            try {
                LocalDate currentDateInRange = firstDateInRange.plusDays(daysIntoTheFuture);
                int currentWeekNumber = currentDateInRange.get(weekFieldRules.weekOfWeekBasedYear());
                weekNumbersList.add(currentWeekNumber);
                continue;
            }
            catch (Exception ex) {
                return 1;
            }
        }
        boolean isUnanimous = InternalUtilities.areObjectsEqual(weekNumbersList.get(0), weekNumbersList.get(6));
        if (isUnanimous) {
            return (Integer)weekNumbersList.get(0);
        }
        if (requireUnanimousWeekNumber) {
            return null;
        }
        int mostCommonWeekNumber = (Integer)InternalUtilities.getMostCommonElementInList(weekNumbersList);
        return mostCommonWeekNumber;
    }

    public void setSettings(DatePickerSettings datePickerSettings) {
        if (datePickerSettings == null) {
            datePickerSettings = new DatePickerSettings();
        }
        this.settings = datePickerSettings;
        if (this.isIndependentCalendarPanel) {
            this.settings.zSetParentCalendarPanel(this);
        }
        if (this.displayedSelectedDate == null) {
            this.displayedYearMonth = this.settings.zGetDefaultYearMonthAsUsed();
        }
        this.zApplyBorderPropertiesList();
        this.zSetAllLabelIndicatorColorsToDefaultState();
        if (this.isIndependentCalendarPanel) {
            this.settings.zApplyAllowEmptyDates();
        }
        this.zApplyVisibilityOfButtons();
        this.drawCalendar();
    }

    public JButton getPreviousYearButton() {
        return this.buttonPreviousYear;
    }

    public JButton getPreviousMonthButton() {
        return this.buttonPreviousMonth;
    }

    public JButton getNextMonthButton() {
        return this.buttonNextMonth;
    }

    public JButton getNextYearButton() {
        return this.buttonNextYear;
    }

    private Clock getClockForToday() {
        if (this.settings != null) {
            return this.settings.getClock();
        }
        return Clock.systemDefaultZone();
    }

    private class PopupCancelWatcher
    implements PopupMenuListener {
        private long cancelTime = 0L;

        private PopupCancelWatcher() {
        }

        public boolean wasJustCanceled() {
            return System.currentTimeMillis() - this.cancelTime < 100L;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.cancelTime = System.currentTimeMillis();
        }
    }
}

