/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import mediathek.config.MVColor;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.cellrenderer.CellRendererBaseWithStart;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellRendererDownloads
extends CellRendererBaseWithStart {
    private static final String DOWNLOAD_STARTEN = "Download starten";
    private static final String DOWNLOAD_LOESCHEN = "Download aus Liste entfernen";
    private static final String DOWNLOAD_STOPPEN = "Download stoppen";
    private static final String DOWNLOAD_ENTFERNEN = "Download entfernen";
    private static final String PLAY_DOWNLOADED_FILM = "gespeicherten Film abspielen";
    private static final Logger logger = LogManager.getLogger(CellRendererDownloads.class);
    private final FlatSVGIcon film_start_tab;
    private final Icon film_start_sw_tab;
    private final Border emptyBorder = BorderFactory.createEmptyBorder(3, 2, 3, 2);
    private final Border largeBorder = BorderFactory.createEmptyBorder(9, 2, 9, 2);
    private final JPanel panel;
    private final FlatSVGIcon download_stop_tab;
    private final FlatSVGIcon download_stop_sw_tab;
    private final FlatSVGIcon download_start_tab;
    private final Icon download_start_sw_tab;
    private final FlatSVGIcon download_clear_tab_selected;
    private final Icon download_clear_sw_tab;
    private final FlatSVGIcon download_del_tab_selected;
    private final Icon download_del_sw_tab;
    private final JProgressBar progressBar = new JProgressBar(0, 1000);

    public CellRendererDownloads() {
        FlatSVGIcon.ColorFilter whiteColorFilter = new FlatSVGIcon.ColorFilter(color -> Color.WHITE);
        this.download_stop_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/stop.svg");
        this.download_stop_tab.setColorFilter(whiteColorFilter);
        this.download_stop_sw_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/stop.svg");
        this.download_start_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/caret-down.svg");
        this.download_start_tab.setColorFilter(whiteColorFilter);
        this.download_start_sw_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/caret-down.svg");
        this.download_clear_tab_selected = SVGIconUtilities.createSVGIcon("icons/fontawesome/eraser.svg");
        this.download_clear_tab_selected.setColorFilter(whiteColorFilter);
        this.download_clear_sw_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/eraser.svg");
        this.download_del_tab_selected = SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg");
        this.download_del_tab_selected.setColorFilter(whiteColorFilter);
        this.download_del_sw_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg");
        this.film_start_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/play.svg");
        this.film_start_tab.setColorFilter(whiteColorFilter);
        this.film_start_sw_tab = SVGIconUtilities.createSVGIcon("icons/fontawesome/play.svg");
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(this.progressBar);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.resetComponent();
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenDownload datenDownload = (DatenDownload)table.getModel().getValueAt(rowModelIndex, 39);
            if (((MVTable)table).isLineBreak()) {
                switch (columnModelIndex) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 19: 
                    case 21: 
                    case 23: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: {
                        JTextArea textArea = new JTextArea();
                        textArea.setLineWrap(true);
                        textArea.setWrapStyleWord(true);
                        textArea.setText(value.toString());
                        textArea.setForeground(this.getForeground());
                        textArea.setBackground(this.getBackground());
                        if (columnModelIndex == 2) {
                            this.handleAboColumn(textArea, datenDownload);
                        }
                        this.setBackgroundColor(textArea, datenDownload.start, isSelected);
                        return textArea;
                    }
                }
            }
            switch (columnModelIndex) {
                case 8: {
                    this.setHorizontalAlignment(0);
                    if (((MVTable)table).showSenderIcons() && !((MVTable)table).useSmallSenderIcons) {
                        this.progressBar.setBorder(this.largeBorder);
                    } else {
                        this.progressBar.setBorder(this.emptyBorder);
                    }
                    if (datenDownload.start != null) {
                        if (1 < datenDownload.start.percent && datenDownload.start.percent < 1000) {
                            this.setBackgroundColor(this.panel, datenDownload.start, isSelected);
                            this.setBackgroundColor(this.progressBar, datenDownload.start, isSelected);
                            this.progressBar.setValue(datenDownload.start.percent);
                            double progressValue = (double)datenDownload.start.percent / 10.0;
                            this.progressBar.setString(Double.toString(progressValue) + "%");
                            return this.panel;
                        }
                        this.setText(Start.getTextProgress(datenDownload.isDownloadManager(), datenDownload.start));
                        break;
                    }
                    this.setText("");
                    break;
                }
                case 1: {
                    if ((Integer)table.getModel().getValueAt(rowModelIndex, 1) == 0) {
                        this.setText("");
                    }
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 32: {
                    switch (datenDownload.art) {
                        case 1: {
                            this.setText("direkter Download");
                            break;
                        }
                        case 2: {
                            this.setText("Programm");
                        }
                    }
                    break;
                }
                case 33: {
                    switch (datenDownload.quelle) {
                        case -1: {
                            this.setText("Alle");
                            break;
                        }
                        case 3: {
                            this.setText("Abo");
                            break;
                        }
                        case 1: {
                            this.setText("Button");
                            break;
                        }
                        case 2: {
                            this.setText("Download");
                        }
                    }
                    break;
                }
                case 6: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 7: {
                    this.handleButtonDeleteColumn(datenDownload, isSelected);
                    break;
                }
                case 11: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    this.handleAboColumn(datenDownload);
                    break;
                }
                case 0: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 3: {
                    if (!((MVTable)table).showSenderIcons()) break;
                    Dimension targetDim = this.getSenderCellDimension(table, row, columnModelIndex);
                    this.setSenderIcon(value.toString(), targetDim);
                    break;
                }
                case 18: {
                    this.drawGeolocationIcons(datenDownload.film, isSelected);
                }
            }
            if (columnModelIndex == 5 && datenDownload.film != null) {
                this.setIndicatorIcons(table, datenDownload.film, isSelected);
            }
            this.setBackgroundColor(this, datenDownload.start, isSelected);
        }
        catch (Exception ex) {
            logger.error(ex);
        }
        return this;
    }

    private void setIconsAndToolTips(DatenDownload datenDownload, Icon filmIcon, Icon downloadStartIcon, Icon downloadStopIcon) {
        if (datenDownload.start != null && !datenDownload.isDownloadManager()) {
            switch (datenDownload.start.status) {
                case 3: {
                    this.setIcon(filmIcon);
                    this.setToolTipText(PLAY_DOWNLOADED_FILM);
                    break;
                }
                case 4: {
                    this.setIcon(downloadStartIcon);
                    this.setToolTipText(DOWNLOAD_STARTEN);
                    break;
                }
                default: {
                    this.setIcon(downloadStopIcon);
                    this.setToolTipText(DOWNLOAD_STOPPEN);
                    break;
                }
            }
        } else {
            this.setIcon(downloadStartIcon);
            this.setToolTipText(DOWNLOAD_STARTEN);
        }
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (isSelected) {
            this.setIconsAndToolTips(datenDownload, this.film_start_tab, this.download_start_tab, this.download_stop_tab);
        } else {
            this.setIconsAndToolTips(datenDownload, this.film_start_sw_tab, this.download_start_sw_tab, this.download_stop_sw_tab);
        }
    }

    private void handleAboColumn(JTextArea a, DatenDownload datenDownload) {
        if (!datenDownload.arr[2].isEmpty()) {
            a.setForeground(MVColor.DOWNLOAD_IST_ABO.color);
        } else {
            a.setForeground(MVColor.DOWNLOAD_IST_DIREKTER_DOWNLOAD.color);
            a.setText("Download");
        }
    }

    private void handleAboColumn(DatenDownload datenDownload) {
        this.setHorizontalAlignment(0);
        if (!datenDownload.arr[2].isEmpty()) {
            this.setForeground(MVColor.DOWNLOAD_IST_ABO.color);
        } else {
            this.setForeground(MVColor.DOWNLOAD_IST_DIREKTER_DOWNLOAD.color);
            this.setText("Download");
        }
    }

    private void handleButtonDeleteColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (datenDownload.start != null) {
            if (datenDownload.start.status >= 3) {
                this.setIcons(this.download_clear_tab_selected, this.download_clear_sw_tab, DOWNLOAD_ENTFERNEN, isSelected);
            } else {
                this.setupDownloadLoeschen(isSelected);
            }
        } else {
            this.setupDownloadLoeschen(isSelected);
        }
    }

    private void setIcons(Icon tab, Icon tab_sw, String text, boolean isSelected) {
        Icon icon = isSelected ? tab : tab_sw;
        this.setIcon(icon);
        this.setToolTipText(text);
    }

    private void setupDownloadLoeschen(boolean isSelected) {
        this.setIcons(this.download_del_tab_selected, this.download_del_sw_tab, DOWNLOAD_LOESCHEN, isSelected);
    }
}

