# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class InlineObject9(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'channel_id': 'int',
        'save_replay': 'bool',
        'thumbnailfile': 'file',
        'previewfile': 'file',
        'privacy': 'VideoPrivacySet',
        'category': 'str',
        'licence': 'str',
        'language': 'str',
        'description': 'str',
        'support': 'str',
        'nsfw': 'bool',
        'name': 'str',
        'tags': 'list[str]',
        'comments_enabled': 'bool',
        'download_enabled': 'bool'
    }

    attribute_map = {
        'channel_id': 'channelId',
        'save_replay': 'saveReplay',
        'thumbnailfile': 'thumbnailfile',
        'previewfile': 'previewfile',
        'privacy': 'privacy',
        'category': 'category',
        'licence': 'licence',
        'language': 'language',
        'description': 'description',
        'support': 'support',
        'nsfw': 'nsfw',
        'name': 'name',
        'tags': 'tags',
        'comments_enabled': 'commentsEnabled',
        'download_enabled': 'downloadEnabled'
    }

    def __init__(self, channel_id=None, save_replay=None, thumbnailfile=None, previewfile=None, privacy=None, category=None, licence=None, language=None, description=None, support=None, nsfw=None, name=None, tags=None, comments_enabled=None, download_enabled=None, local_vars_configuration=None):  # noqa: E501
        """InlineObject9 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._channel_id = None
        self._save_replay = None
        self._thumbnailfile = None
        self._previewfile = None
        self._privacy = None
        self._category = None
        self._licence = None
        self._language = None
        self._description = None
        self._support = None
        self._nsfw = None
        self._name = None
        self._tags = None
        self._comments_enabled = None
        self._download_enabled = None
        self.discriminator = None

        self.channel_id = channel_id
        if save_replay is not None:
            self.save_replay = save_replay
        if thumbnailfile is not None:
            self.thumbnailfile = thumbnailfile
        if previewfile is not None:
            self.previewfile = previewfile
        if privacy is not None:
            self.privacy = privacy
        if category is not None:
            self.category = category
        if licence is not None:
            self.licence = licence
        if language is not None:
            self.language = language
        if description is not None:
            self.description = description
        if support is not None:
            self.support = support
        if nsfw is not None:
            self.nsfw = nsfw
        self.name = name
        if tags is not None:
            self.tags = tags
        if comments_enabled is not None:
            self.comments_enabled = comments_enabled
        if download_enabled is not None:
            self.download_enabled = download_enabled

    @property
    def channel_id(self):
        """Gets the channel_id of this InlineObject9.  # noqa: E501

        Channel id that will contain this live video  # noqa: E501

        :return: The channel_id of this InlineObject9.  # noqa: E501
        :rtype: int
        """
        return self._channel_id

    @channel_id.setter
    def channel_id(self, channel_id):
        """Sets the channel_id of this InlineObject9.

        Channel id that will contain this live video  # noqa: E501

        :param channel_id: The channel_id of this InlineObject9.  # noqa: E501
        :type channel_id: int
        """
        if self.local_vars_configuration.client_side_validation and channel_id is None:  # noqa: E501
            raise ValueError("Invalid value for `channel_id`, must not be `None`")  # noqa: E501

        self._channel_id = channel_id

    @property
    def save_replay(self):
        """Gets the save_replay of this InlineObject9.  # noqa: E501


        :return: The save_replay of this InlineObject9.  # noqa: E501
        :rtype: bool
        """
        return self._save_replay

    @save_replay.setter
    def save_replay(self, save_replay):
        """Sets the save_replay of this InlineObject9.


        :param save_replay: The save_replay of this InlineObject9.  # noqa: E501
        :type save_replay: bool
        """

        self._save_replay = save_replay

    @property
    def thumbnailfile(self):
        """Gets the thumbnailfile of this InlineObject9.  # noqa: E501

        Live video/replay thumbnail file  # noqa: E501

        :return: The thumbnailfile of this InlineObject9.  # noqa: E501
        :rtype: file
        """
        return self._thumbnailfile

    @thumbnailfile.setter
    def thumbnailfile(self, thumbnailfile):
        """Sets the thumbnailfile of this InlineObject9.

        Live video/replay thumbnail file  # noqa: E501

        :param thumbnailfile: The thumbnailfile of this InlineObject9.  # noqa: E501
        :type thumbnailfile: file
        """

        self._thumbnailfile = thumbnailfile

    @property
    def previewfile(self):
        """Gets the previewfile of this InlineObject9.  # noqa: E501

        Live video/replay preview file  # noqa: E501

        :return: The previewfile of this InlineObject9.  # noqa: E501
        :rtype: file
        """
        return self._previewfile

    @previewfile.setter
    def previewfile(self, previewfile):
        """Sets the previewfile of this InlineObject9.

        Live video/replay preview file  # noqa: E501

        :param previewfile: The previewfile of this InlineObject9.  # noqa: E501
        :type previewfile: file
        """

        self._previewfile = previewfile

    @property
    def privacy(self):
        """Gets the privacy of this InlineObject9.  # noqa: E501


        :return: The privacy of this InlineObject9.  # noqa: E501
        :rtype: VideoPrivacySet
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this InlineObject9.


        :param privacy: The privacy of this InlineObject9.  # noqa: E501
        :type privacy: VideoPrivacySet
        """

        self._privacy = privacy

    @property
    def category(self):
        """Gets the category of this InlineObject9.  # noqa: E501

        Live video/replay category  # noqa: E501

        :return: The category of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this InlineObject9.

        Live video/replay category  # noqa: E501

        :param category: The category of this InlineObject9.  # noqa: E501
        :type category: str
        """

        self._category = category

    @property
    def licence(self):
        """Gets the licence of this InlineObject9.  # noqa: E501

        Live video/replay licence  # noqa: E501

        :return: The licence of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._licence

    @licence.setter
    def licence(self, licence):
        """Sets the licence of this InlineObject9.

        Live video/replay licence  # noqa: E501

        :param licence: The licence of this InlineObject9.  # noqa: E501
        :type licence: str
        """

        self._licence = licence

    @property
    def language(self):
        """Gets the language of this InlineObject9.  # noqa: E501

        Live video/replay language  # noqa: E501

        :return: The language of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this InlineObject9.

        Live video/replay language  # noqa: E501

        :param language: The language of this InlineObject9.  # noqa: E501
        :type language: str
        """

        self._language = language

    @property
    def description(self):
        """Gets the description of this InlineObject9.  # noqa: E501

        Live video/replay description  # noqa: E501

        :return: The description of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this InlineObject9.

        Live video/replay description  # noqa: E501

        :param description: The description of this InlineObject9.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def support(self):
        """Gets the support of this InlineObject9.  # noqa: E501

        A text tell the audience how to support the creator  # noqa: E501

        :return: The support of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._support

    @support.setter
    def support(self, support):
        """Sets the support of this InlineObject9.

        A text tell the audience how to support the creator  # noqa: E501

        :param support: The support of this InlineObject9.  # noqa: E501
        :type support: str
        """

        self._support = support

    @property
    def nsfw(self):
        """Gets the nsfw of this InlineObject9.  # noqa: E501

        Whether or not this live video/replay contains sensitive content  # noqa: E501

        :return: The nsfw of this InlineObject9.  # noqa: E501
        :rtype: bool
        """
        return self._nsfw

    @nsfw.setter
    def nsfw(self, nsfw):
        """Sets the nsfw of this InlineObject9.

        Whether or not this live video/replay contains sensitive content  # noqa: E501

        :param nsfw: The nsfw of this InlineObject9.  # noqa: E501
        :type nsfw: bool
        """

        self._nsfw = nsfw

    @property
    def name(self):
        """Gets the name of this InlineObject9.  # noqa: E501

        Live video/replay name  # noqa: E501

        :return: The name of this InlineObject9.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this InlineObject9.

        Live video/replay name  # noqa: E501

        :param name: The name of this InlineObject9.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def tags(self):
        """Gets the tags of this InlineObject9.  # noqa: E501

        Live video/replay tags (maximum 5 tags each between 2 and 30 characters)  # noqa: E501

        :return: The tags of this InlineObject9.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this InlineObject9.

        Live video/replay tags (maximum 5 tags each between 2 and 30 characters)  # noqa: E501

        :param tags: The tags of this InlineObject9.  # noqa: E501
        :type tags: list[str]
        """

        self._tags = tags

    @property
    def comments_enabled(self):
        """Gets the comments_enabled of this InlineObject9.  # noqa: E501

        Enable or disable comments for this live video/replay  # noqa: E501

        :return: The comments_enabled of this InlineObject9.  # noqa: E501
        :rtype: bool
        """
        return self._comments_enabled

    @comments_enabled.setter
    def comments_enabled(self, comments_enabled):
        """Sets the comments_enabled of this InlineObject9.

        Enable or disable comments for this live video/replay  # noqa: E501

        :param comments_enabled: The comments_enabled of this InlineObject9.  # noqa: E501
        :type comments_enabled: bool
        """

        self._comments_enabled = comments_enabled

    @property
    def download_enabled(self):
        """Gets the download_enabled of this InlineObject9.  # noqa: E501

        Enable or disable downloading for the replay of this live  # noqa: E501

        :return: The download_enabled of this InlineObject9.  # noqa: E501
        :rtype: bool
        """
        return self._download_enabled

    @download_enabled.setter
    def download_enabled(self, download_enabled):
        """Sets the download_enabled of this InlineObject9.

        Enable or disable downloading for the replay of this live  # noqa: E501

        :param download_enabled: The download_enabled of this InlineObject9.  # noqa: E501
        :type download_enabled: bool
        """

        self._download_enabled = download_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineObject9):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineObject9):
            return True

        return self.to_dict() != other.to_dict()
