# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Notification(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'type': 'int',
        'read': 'bool',
        'video': 'VideoInfo',
        'video_import': 'NotificationVideoImport',
        'comment': 'NotificationComment',
        'video_abuse': 'NotificationVideoAbuse',
        'video_blacklist': 'NotificationVideoAbuse',
        'account': 'ActorInfo',
        'actor_follow': 'NotificationActorFollow',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'read': 'read',
        'video': 'video',
        'video_import': 'videoImport',
        'comment': 'comment',
        'video_abuse': 'videoAbuse',
        'video_blacklist': 'videoBlacklist',
        'account': 'account',
        'actor_follow': 'actorFollow',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, type=None, read=None, video=None, video_import=None, comment=None, video_abuse=None, video_blacklist=None, account=None, actor_follow=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """Notification - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._type = None
        self._read = None
        self._video = None
        self._video_import = None
        self._comment = None
        self._video_abuse = None
        self._video_blacklist = None
        self._account = None
        self._actor_follow = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if read is not None:
            self.read = read
        self.video = video
        self.video_import = video_import
        self.comment = comment
        self.video_abuse = video_abuse
        self.video_blacklist = video_blacklist
        self.account = account
        self.actor_follow = actor_follow
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this Notification.  # noqa: E501


        :return: The id of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Notification.


        :param id: The id of this Notification.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this Notification.  # noqa: E501

        Notification type, following the `UserNotificationType` enum: - `1` NEW_VIDEO_FROM_SUBSCRIPTION - `2` NEW_COMMENT_ON_MY_VIDEO - `3` NEW_ABUSE_FOR_MODERATORS - `4` BLACKLIST_ON_MY_VIDEO - `5` UNBLACKLIST_ON_MY_VIDEO - `6` MY_VIDEO_PUBLISHED - `7` MY_VIDEO_IMPORT_SUCCESS - `8` MY_VIDEO_IMPORT_ERROR - `9` NEW_USER_REGISTRATION - `10` NEW_FOLLOW - `11` COMMENT_MENTION - `12` VIDEO_AUTO_BLACKLIST_FOR_MODERATORS - `13` NEW_INSTANCE_FOLLOWER - `14` AUTO_INSTANCE_FOLLOWING   # noqa: E501

        :return: The type of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Notification.

        Notification type, following the `UserNotificationType` enum: - `1` NEW_VIDEO_FROM_SUBSCRIPTION - `2` NEW_COMMENT_ON_MY_VIDEO - `3` NEW_ABUSE_FOR_MODERATORS - `4` BLACKLIST_ON_MY_VIDEO - `5` UNBLACKLIST_ON_MY_VIDEO - `6` MY_VIDEO_PUBLISHED - `7` MY_VIDEO_IMPORT_SUCCESS - `8` MY_VIDEO_IMPORT_ERROR - `9` NEW_USER_REGISTRATION - `10` NEW_FOLLOW - `11` COMMENT_MENTION - `12` VIDEO_AUTO_BLACKLIST_FOR_MODERATORS - `13` NEW_INSTANCE_FOLLOWER - `14` AUTO_INSTANCE_FOLLOWING   # noqa: E501

        :param type: The type of this Notification.  # noqa: E501
        :type type: int
        """

        self._type = type

    @property
    def read(self):
        """Gets the read of this Notification.  # noqa: E501


        :return: The read of this Notification.  # noqa: E501
        :rtype: bool
        """
        return self._read

    @read.setter
    def read(self, read):
        """Sets the read of this Notification.


        :param read: The read of this Notification.  # noqa: E501
        :type read: bool
        """

        self._read = read

    @property
    def video(self):
        """Gets the video of this Notification.  # noqa: E501


        :return: The video of this Notification.  # noqa: E501
        :rtype: VideoInfo
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this Notification.


        :param video: The video of this Notification.  # noqa: E501
        :type video: VideoInfo
        """

        self._video = video

    @property
    def video_import(self):
        """Gets the video_import of this Notification.  # noqa: E501


        :return: The video_import of this Notification.  # noqa: E501
        :rtype: NotificationVideoImport
        """
        return self._video_import

    @video_import.setter
    def video_import(self, video_import):
        """Sets the video_import of this Notification.


        :param video_import: The video_import of this Notification.  # noqa: E501
        :type video_import: NotificationVideoImport
        """

        self._video_import = video_import

    @property
    def comment(self):
        """Gets the comment of this Notification.  # noqa: E501


        :return: The comment of this Notification.  # noqa: E501
        :rtype: NotificationComment
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Notification.


        :param comment: The comment of this Notification.  # noqa: E501
        :type comment: NotificationComment
        """

        self._comment = comment

    @property
    def video_abuse(self):
        """Gets the video_abuse of this Notification.  # noqa: E501


        :return: The video_abuse of this Notification.  # noqa: E501
        :rtype: NotificationVideoAbuse
        """
        return self._video_abuse

    @video_abuse.setter
    def video_abuse(self, video_abuse):
        """Sets the video_abuse of this Notification.


        :param video_abuse: The video_abuse of this Notification.  # noqa: E501
        :type video_abuse: NotificationVideoAbuse
        """

        self._video_abuse = video_abuse

    @property
    def video_blacklist(self):
        """Gets the video_blacklist of this Notification.  # noqa: E501


        :return: The video_blacklist of this Notification.  # noqa: E501
        :rtype: NotificationVideoAbuse
        """
        return self._video_blacklist

    @video_blacklist.setter
    def video_blacklist(self, video_blacklist):
        """Sets the video_blacklist of this Notification.


        :param video_blacklist: The video_blacklist of this Notification.  # noqa: E501
        :type video_blacklist: NotificationVideoAbuse
        """

        self._video_blacklist = video_blacklist

    @property
    def account(self):
        """Gets the account of this Notification.  # noqa: E501


        :return: The account of this Notification.  # noqa: E501
        :rtype: ActorInfo
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this Notification.


        :param account: The account of this Notification.  # noqa: E501
        :type account: ActorInfo
        """

        self._account = account

    @property
    def actor_follow(self):
        """Gets the actor_follow of this Notification.  # noqa: E501


        :return: The actor_follow of this Notification.  # noqa: E501
        :rtype: NotificationActorFollow
        """
        return self._actor_follow

    @actor_follow.setter
    def actor_follow(self, actor_follow):
        """Sets the actor_follow of this Notification.


        :param actor_follow: The actor_follow of this Notification.  # noqa: E501
        :type actor_follow: NotificationActorFollow
        """

        self._actor_follow = actor_follow

    @property
    def created_at(self):
        """Gets the created_at of this Notification.  # noqa: E501


        :return: The created_at of this Notification.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Notification.


        :param created_at: The created_at of this Notification.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Notification.  # noqa: E501


        :return: The updated_at of this Notification.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Notification.


        :param updated_at: The updated_at of this Notification.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Notification):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Notification):
            return True

        return self.to_dict() != other.to_dict()
