/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.TaggedWord;

public class TaggedWordFactory
implements LabelFactory {
    public static final int TAG_LABEL = 2;
    private final char divider;

    public TaggedWordFactory() {
        this('/');
    }

    public TaggedWordFactory(char divider) {
        this.divider = divider;
    }

    public Label newLabel(String labelStr) {
        return new TaggedWord(labelStr);
    }

    public Label newLabel(String labelStr, int options) {
        if (options == 2) {
            return new TaggedWord(null, labelStr);
        }
        return new TaggedWord(labelStr);
    }

    public Label newLabelFromString(String word) {
        int where = word.lastIndexOf(this.divider);
        if (where >= 0) {
            return new TaggedWord(word.substring(0, where), word.substring(where + 1));
        }
        return new TaggedWord(word);
    }

    public Label newLabel(Label oldLabel) {
        return new TaggedWord(oldLabel);
    }
}

