/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.stats.IntCounter;
import java.util.HashMap;
import java.util.Map;

class VariableStrings {
    private Map<String, String> varsToStrings = new HashMap<String, String>();
    private IntCounter<String> numVarsSet = new IntCounter();

    public boolean isSet(String o) {
        return this.numVarsSet.getCount(o) == 1.0;
    }

    public void setVar(String var, String string) {
        String oldString = this.varsToStrings.put(var, string);
        if (oldString != null && !oldString.equals(string)) {
            throw new RuntimeException("Error -- can't setVar to a different string -- old: " + oldString + " new: " + string);
        }
        this.numVarsSet.incrementCount(var);
    }

    public void unsetVar(String var) {
        if (this.numVarsSet.getCount(var) > 0.0) {
            this.numVarsSet.decrementCount(var);
        }
        if (this.numVarsSet.getCount(var) == 0.0) {
            this.varsToStrings.put(var, null);
        }
    }

    public String getString(String var) {
        return this.varsToStrings.get(var);
    }
}

