/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interval<E extends Comparable<E>>
extends Pair<E, E>
implements HasInterval<E> {
    public static int INTERVAL_OPEN_BEGIN = 1;
    public static int INTERVAL_OPEN_END = 2;
    private int flags;
    protected static final int REL_FLAGS_SAME = 1;
    protected static final int REL_FLAGS_BEFORE = 2;
    protected static final int REL_FLAGS_AFTER = 4;
    protected static final int REL_FLAGS_UNKNOWN = 7;
    protected static final int REL_FLAGS_SS_SHIFT = 0;
    protected static final int REL_FLAGS_SE_SHIFT = 4;
    protected static final int REL_FLAGS_ES_SHIFT = 8;
    protected static final int REL_FLAGS_EE_SHIFT = 12;
    public static final int REL_FLAGS_SS_SAME = 1;
    public static final int REL_FLAGS_SS_BEFORE = 2;
    public static final int REL_FLAGS_SS_AFTER = 4;
    public static final int REL_FLAGS_SS_UNKNOWN = 7;
    public static final int REL_FLAGS_SE_SAME = 16;
    public static final int REL_FLAGS_SE_BEFORE = 32;
    public static final int REL_FLAGS_SE_AFTER = 64;
    public static final int REL_FLAGS_SE_UNKNOWN = 112;
    public static final int REL_FLAGS_ES_SAME = 256;
    public static final int REL_FLAGS_ES_BEFORE = 512;
    public static final int REL_FLAGS_ES_AFTER = 1024;
    public static final int REL_FLAGS_ES_UNKNOWN = 1792;
    public static final int REL_FLAGS_EE_SAME = 4096;
    public static final int REL_FLAGS_EE_BEFORE = 8192;
    public static final int REL_FLAGS_EE_AFTER = 16384;
    public static final int REL_FLAGS_EE_UNKNOWN = 28672;
    public static final int REL_FLAGS_INTERVAL_SAME = 65536;
    public static final int REL_FLAGS_INTERVAL_BEFORE = 131072;
    public static final int REL_FLAGS_INTERVAL_AFTER = 262144;
    public static final int REL_FLAGS_INTERVAL_OVERLAP = 0x100000;
    public static final int REL_FLAGS_INTERVAL_INSIDE = 0x200000;
    public static final int REL_FLAGS_INTERVAL_CONTAIN = 0x400000;
    public static final int REL_FLAGS_INTERVAL_UNKNOWN = 0x770000;
    public static final int REL_FLAGS_INTERVAL_ALMOST_SAME = 0x1000000;
    public static final int REL_FLAGS_INTERVAL_ALMOST_BEFORE = 0x1000000;
    public static final int REL_FLAGS_INTERVAL_ALMOST_AFTER = 0x1000000;
    public static final int REL_FLAGS_INTERVAL_FUZZY = Integer.MIN_VALUE;

    protected Interval(E a, E b, int flags) {
        super(a, b);
        this.flags = flags;
        int comp = a.compareTo(b);
        if (comp > 0) {
            throw new IllegalArgumentException("Invalid interval: " + a + "," + b);
        }
    }

    public static <E extends Comparable<E>> Interval<E> toInterval(E a, E b) {
        return Interval.toInterval(a, b, 0);
    }

    public static <E extends Comparable<E>> Interval<E> toInterval(E a, E b, int flags) {
        int comp = a.compareTo(b);
        if (comp <= 0) {
            return new Interval<E>(a, b, flags);
        }
        return null;
    }

    public static <E extends Comparable<E>> Interval<E> toValidInterval(E a, E b) {
        return Interval.toValidInterval(a, b, 0);
    }

    public static <E extends Comparable<E>> Interval<E> toValidInterval(E a, E b, int flags) {
        int comp = a.compareTo(b);
        if (comp <= 0) {
            return new Interval<E>(a, b, flags);
        }
        return new Interval<E>(b, a, flags);
    }

    @Override
    public Interval<E> getInterval() {
        return this;
    }

    public E getBegin() {
        return (E)((Comparable)this.first);
    }

    public E getEnd() {
        return (E)((Comparable)this.second);
    }

    protected static <E extends Comparable<E>> E max(E a, E b) {
        int comp = a.compareTo(b);
        return comp > 0 ? a : b;
    }

    protected static <E extends Comparable<E>> E min(E a, E b) {
        int comp = a.compareTo(b);
        return comp < 0 ? a : b;
    }

    public boolean contains(E p) {
        return ((Comparable)this.first).compareTo(p) <= 0 && ((Comparable)this.second).compareTo(p) >= 0;
    }

    public Interval expand(Interval<E> other) {
        if (other == null) {
            return this;
        }
        Comparable a = Interval.min((Comparable)this.first, (Comparable)other.first);
        Comparable b = Interval.max((Comparable)this.second, (Comparable)other.second);
        return Interval.toInterval(a, b);
    }

    public Interval intersect(Interval<E> other) {
        if (other == null) {
            return null;
        }
        Comparable a = Interval.max((Comparable)this.first, (Comparable)other.first);
        Comparable b = Interval.min((Comparable)this.second, (Comparable)other.second);
        return Interval.toInterval(a, b);
    }

    public boolean overlaps(Interval<E> other) {
        if (other == null) {
            return false;
        }
        int comp12 = ((Comparable)this.first).compareTo(other.second());
        int comp21 = ((Comparable)this.second).compareTo(other.first());
        if (comp12 > 0 || comp21 < 0) {
            return false;
        }
        if (!(comp12 != 0 || this.includesBegin() && other.includesEnd())) {
            return false;
        }
        return comp21 != 0 || this.includesEnd() && other.includesBegin();
    }

    public boolean includesBegin() {
        return (this.flags & INTERVAL_OPEN_BEGIN) == 0;
    }

    public boolean includesEnd() {
        return (this.flags & INTERVAL_OPEN_END) == 0;
    }

    protected int toRelFlags(int comp, int shift) {
        int flags = 0;
        flags = comp == 0 ? 1 : (comp > 0 ? 4 : 2);
        return flags <<= shift;
    }

    public int getRelationFlags(Interval<E> other) {
        if (other == null) {
            return 0;
        }
        int flags = 0;
        int comp11 = ((Comparable)this.first).compareTo(other.first());
        flags |= this.toRelFlags(comp11, 0);
        int comp22 = ((Comparable)this.second).compareTo(other.second());
        flags |= this.toRelFlags(comp22, 12);
        int comp12 = ((Comparable)this.first).compareTo(other.second());
        flags |= this.toRelFlags(comp12, 4);
        int comp21 = ((Comparable)this.second).compareTo(other.first());
        flags |= this.toRelFlags(comp21, 8);
        flags = this.addIntervalRelationFlags(flags, false);
        return flags;
    }

    public int addIntervalRelationFlags(int flags, boolean checkFuzzy) {
        int f11 = Interval.extractRelationSubflags(flags, 0);
        int f22 = Interval.extractRelationSubflags(flags, 12);
        int f12 = Interval.extractRelationSubflags(flags, 4);
        int f21 = Interval.extractRelationSubflags(flags, 8);
        if (checkFuzzy) {
            boolean isFuzzy;
            boolean bl = isFuzzy = Interval.checkMultipleBitSet(f11) || Interval.checkMultipleBitSet(f12) || Interval.checkMultipleBitSet(f21) || Interval.checkMultipleBitSet(f22);
            if (isFuzzy) {
                flags |= Integer.MIN_VALUE;
            }
        }
        if ((f11 & 1) != 0 && (f22 & 1) != 0) {
            flags |= 0x10000;
        }
        if ((f21 & 2) != 0) {
            flags |= 0x20000;
        }
        if ((f12 & 4) != 0) {
            flags |= 0x40000;
        }
        if ((f11 & 5) != 0 && (f12 & 3) != 0) {
            flags |= 0x100000;
        }
        if ((f11 & 3) != 0 && (f21 & 5) != 0) {
            flags |= 0x100000;
        }
        if ((f11 & 5) != 0 && (f22 & 3) != 0) {
            flags |= 0x200000;
        }
        if ((f11 & 3) != 0 && (f22 & 5) != 0) {
            flags |= 0x400000;
        }
        return flags;
    }

    public static int extractRelationSubflags(int flags, int shift) {
        return flags >> shift & 0xF;
    }

    public static boolean checkMultipleBitSet(int flags) {
        boolean set = false;
        while (flags != 0) {
            if ((flags & 1) != 0) {
                if (set) {
                    return false;
                }
                set = true;
            }
            flags >>= 1;
        }
        return false;
    }

    public static boolean checkFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean checkFlagExclusiveSet(int flags, int flag, int mask) {
        int f = flags & flag;
        if (f != 0) {
            return (flags & mask & ~flag) == 0;
        }
        return false;
    }

    public RelType getRelation(Interval<E> other) {
        if (other == null) {
            return RelType.NONE;
        }
        int comp11 = ((Comparable)this.first).compareTo(other.first());
        int comp22 = ((Comparable)this.second).compareTo(other.second());
        if (comp11 == 0) {
            if (comp22 == 0) {
                return RelType.EQUAL;
            }
            if (comp22 < 0) {
                return RelType.INSIDE;
            }
            return RelType.CONTAIN;
        }
        if (comp22 == 0) {
            if (comp11 < 0) {
                return RelType.CONTAIN;
            }
            return RelType.INSIDE;
        }
        if (comp11 > 0 && comp22 < 0) {
            return RelType.INSIDE;
        }
        if (comp11 < 0 && comp22 > 0) {
            return RelType.CONTAIN;
        }
        int comp12 = ((Comparable)this.first).compareTo(other.second());
        int comp21 = ((Comparable)this.second).compareTo(other.first());
        if (comp12 > 0) {
            return RelType.AFTER;
        }
        if (comp21 < 0) {
            return RelType.BEFORE;
        }
        if (comp12 == 0) {
            return RelType.BEGIN_MEET_END;
        }
        if (comp21 == 0) {
            return RelType.END_MEET_BEGIN;
        }
        return RelType.OVERLAP;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.flags == interval.flags;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.flags;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelType {
        BEFORE,
        AFTER,
        EQUAL,
        BEGIN_MEET_END,
        END_MEET_BEGIN,
        CONTAIN,
        INSIDE,
        OVERLAP,
        UNKNOWN,
        NONE;

    }
}

