/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.FactoredLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.process.SerializableFunction;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.french.DybroFrenchHeadFinder;
import edu.stanford.nlp.trees.international.french.FrenchTreeReaderFactory;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrenchTreebankParserParams
extends AbstractTreebankParserParams {
    private static final long serialVersionUID = -6976724734594763986L;
    private final StringBuilder optionsString;
    private HeadFinder headFinder;
    private final Map<String, Pair<TregexPattern, Function<TregexMatcher, String>>> annotationPatterns;
    private final Map<TregexPattern, Function<TregexMatcher, String>> activeAnnotations;
    private boolean readPennFormat = true;
    private boolean collinizerRetainsPunctuation = false;
    private static TwoDimensionalCounter<String, String> mwCounter;
    private MorphoFeatureSpecification morphoSpec;
    private static final List<String> baselineFeatures;
    private static final List<String> additionalFeatures;

    public FrenchTreebankParserParams() {
        super(new FrenchTreebankLanguagePack());
        this.setInputEncoding("UTF-8");
        this.optionsString = new StringBuilder();
        this.optionsString.append("FrenchTreebankParserParams\n");
        this.annotationPatterns = new HashMap<String, Pair<TregexPattern, Function<TregexMatcher, String>>>();
        this.activeAnnotations = new HashMap<TregexPattern, Function<TregexMatcher, String>>();
        this.initializeAnnotationPatterns();
    }

    private void initializeAnnotationPatterns() {
        try {
            TregexPatternCompiler tregexPatternCompiler = new TregexPatternCompiler(this.headFinder());
            this.annotationPatterns.put("-markInf", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@V > (@VN > @VPinf)"), new SimpleStringFunction("-infinitive")));
            this.annotationPatterns.put("-markPart", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@V > (@VN > @VPpart)"), new SimpleStringFunction("-participle")));
            this.annotationPatterns.put("-markVN", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << @VN"), new SimpleStringFunction("-withVN")));
            this.annotationPatterns.put("-tagPAFr", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("!@PUNC < (__ !< __) > __=parent"), new AddRelativeNodeFunction("-", "parent", true)));
            this.annotationPatterns.put("-coord1", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@COORD <2 __=word"), new AddRelativeNodeFunction("-", "word", true)));
            this.annotationPatterns.put("-de2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P < /^([Dd]es?|du|d')$/"), new SimpleStringFunction("-de2")));
            this.annotationPatterns.put("-de3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP|PP|COORD >+(@NP|PP) (@PP <, (@P < /^([Dd]es?|du|d')$/))"), new SimpleStringFunction("-de3")));
            this.annotationPatterns.put("-markP1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > (@PP > @NP)"), new SimpleStringFunction("-n")));
            this.annotationPatterns.put("-MWAdvS", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWADV > /S/"), new SimpleStringFunction("-mwadv-s")));
            this.annotationPatterns.put("-MWADVSel1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWADV <1 @P <2 @N !<3 __"), new SimpleStringFunction("-mwadv1")));
            this.annotationPatterns.put("-MWADVSel2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWADV <1 @P <2 @D <3 @N !<4 __"), new SimpleStringFunction("-mwadv2")));
            this.annotationPatterns.put("-MWNSel1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @A !<3 __"), new SimpleStringFunction("-mwn1")));
            this.annotationPatterns.put("-MWNSel2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @P <3 @N !<4 __"), new SimpleStringFunction("-mwn2")));
            this.annotationPatterns.put("-MWNSel3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @- <3 @N !<4 __"), new SimpleStringFunction("-mwn3")));
            this.annotationPatterns.put("-splitPUNC", new Pair<TregexPattern, AbstractTreebankParserParams.AnnotatePunctuationFunction>(tregexPatternCompiler.compile("@PUNC < __=punc"), new AbstractTreebankParserParams.AnnotatePunctuationFunction("-", "punc")));
            this.annotationPatterns.put("-sq", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@SENT << /\\?/"), new SimpleStringFunction("-Q")));
            this.annotationPatterns.put("-hasVP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("!@ROOT|SENT << /^VP/"), new SimpleStringFunction("-hasVP")));
            this.annotationPatterns.put("-hasVP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << /^VP/"), new SimpleStringFunction("-hasVP")));
            this.annotationPatterns.put("-npCOORD", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < @COORD"), new SimpleStringFunction("-coord")));
            this.annotationPatterns.put("-npVP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < /VP/"), new SimpleStringFunction("-vp")));
            this.annotationPatterns.put("-baseNP1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <1 @D <2 @N !<3 __"), new SimpleStringFunction("-np1")));
            this.annotationPatterns.put("-baseNP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <1 @D <2 @MWN !<3 __"), new SimpleStringFunction("-np2")));
            this.annotationPatterns.put("-baseNP3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <1 @MWD <2 @N !<3 __ "), new SimpleStringFunction("-np3")));
            this.annotationPatterns.put("-npMWN1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < (@MWN < @A)"), new SimpleStringFunction("-mwna")));
            this.annotationPatterns.put("-npMWN2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <1 @D <2 @MWN <3 @PP !<4 __"), new SimpleStringFunction("-mwn2")));
            this.annotationPatterns.put("-npMWN3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <1 @D <2 (@MWN <1 @N <2 @A !<3 __) !<3 __"), new SimpleStringFunction("-mwn3")));
            this.annotationPatterns.put("-npMWN4", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP <, @P <2 (@NP <1 @D <2 (@MWN <1 @N <2 @A !<3 __) !<3 __) !<3 __"), new SimpleStringFunction("-mwn3")));
            this.annotationPatterns.put("-MWNSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWN"), new AddPOSSequenceFunction("-", 600, true)));
            this.annotationPatterns.put("-MWADVSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWADV"), new AddPOSSequenceFunction("-", 500, true)));
            this.annotationPatterns.put("-MWASel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWA"), new AddPOSSequenceFunction("-", 100, true)));
            this.annotationPatterns.put("-MWCSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWC"), new AddPOSSequenceFunction("-", 400, true)));
            this.annotationPatterns.put("-MWDSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWD"), new AddPOSSequenceFunction("-", 100, true)));
            this.annotationPatterns.put("-MWPSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWP"), new AddPOSSequenceFunction("-", 600, true)));
            this.annotationPatterns.put("-MWPROSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWPRO"), new AddPOSSequenceFunction("-", 60, true)));
            this.annotationPatterns.put("-MWVSel", new Pair<TregexPattern, AddPOSSequenceFunction>(tregexPatternCompiler.compile("@MWV"), new AddPOSSequenceFunction("-", 200, true)));
            this.annotationPatterns.put("-mwn1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @A !<3 __"), new SimpleStringFunction("-na")));
            this.annotationPatterns.put("-mwn2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @P <3 @N !<4 __"), new SimpleStringFunction("-npn")));
            this.annotationPatterns.put("-mwn3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @- <3 @N !<4 __"), new SimpleStringFunction("-n-n")));
            this.annotationPatterns.put("-mwn4", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @N <2 @N !<3 __"), new SimpleStringFunction("-nn")));
            this.annotationPatterns.put("-mwn5", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWN <1 @D <2 @N !<3 __"), new SimpleStringFunction("-dn")));
            this.annotationPatterns.put("-hasWH", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ < /^(qui|quoi|comment|quel|quelle|quels|quelles|o\u00f9|combien|que|pourquoi|quand)$/"), new SimpleStringFunction("-wh")));
            this.annotationPatterns.put("-markNNP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@N < /^[A-Z]/"), new SimpleStringFunction("-nnp")));
            this.annotationPatterns.put("-markD1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D > (__ > @PP)"), new SimpleStringFunction("-p")));
            this.annotationPatterns.put("-markD2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D > (__ > @NP)"), new SimpleStringFunction("-n")));
            this.annotationPatterns.put("-markD3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D > (__ > /^VP/)"), new SimpleStringFunction("-v")));
            this.annotationPatterns.put("-markD4", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D > (__ > /^S/)"), new SimpleStringFunction("-s")));
            this.annotationPatterns.put("-markD5", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D > (__ > @COORD)"), new SimpleStringFunction("-c")));
            this.annotationPatterns.put("-app1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < /[,]/"), new SimpleStringFunction("-app1")));
            this.annotationPatterns.put("-app2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("/[^,\\-:;\"]/ > (@NP < /^[,]$/) $,, /^[,]$/"), new SimpleStringFunction("-app2")));
            this.annotationPatterns.put("-coord2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@COORD !< @C"), new SimpleStringFunction("-nonC")));
            this.annotationPatterns.put("-hasCOORD", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ < @COORD"), new SimpleStringFunction("-hasCOORD")));
            this.annotationPatterns.put("-hasCOORDLS", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@SENT <, @COORD"), new SimpleStringFunction("-hasCOORDLS")));
            this.annotationPatterns.put("-hasCOORDNonS", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ < @COORD !<, @COORD"), new SimpleStringFunction("-hasCOORDNonS")));
            this.annotationPatterns.put("-pp1", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@P < /^(du|des|au|aux)$/=word"), new AddRelativeNodeFunction("-", "word", false)));
            this.annotationPatterns.put("-vpinf1", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@VPinf <, __=word"), new AddRelativeNodeFunction("-", "word", false)));
            this.annotationPatterns.put("-vpinf2", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@VPinf <, __=word"), new AddRelativeNodeFunction("-", "word", true)));
            this.annotationPatterns.put("-splitIN", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@PP <, (P < /^([Dd]e|[Dd]'|[Dd]es|[Dd]u|\u00e0|[Aa]u|[Aa]ux|[Ee]n|[Dd]ans|[Pp]ar|[Ss]ur|[Pp]our|[Aa]vec|[Ee]ntre)$/=word)"), new AddRelativeNodeFunction("-", "word", false, true)));
            this.annotationPatterns.put("-splitP", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@P < /^([Dd]e|[Dd]'|[Dd]es|[Dd]u|\u00e0|[Aa]u|[Aa]ux|[Ee]n|[Dd]ans|[Pp]ar|[Ss]ur|[Pp]our|[Aa]vec|[Ee]ntre)$/=word"), new AddRelativeNodeFunction("-", "word", false, true)));
            this.annotationPatterns.put("-hasde", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP|PP <+(@NP|PP) (P < de)"), new SimpleStringFunction("-hasDE")));
            this.annotationPatterns.put("-hasde2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP < de"), new SimpleStringFunction("-hasDE2")));
            this.annotationPatterns.put("-np1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < /^,$/"), new SimpleStringFunction("-np1")));
            this.annotationPatterns.put("-np2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <, (@D < le|la|les)"), new SimpleStringFunction("-np2")));
            this.annotationPatterns.put("-np3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D < le|la|les"), new SimpleStringFunction("-def")));
            this.annotationPatterns.put("-baseNP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <, @D <- (@N , @D)"), new SimpleStringFunction("-baseNP")));
            this.annotationPatterns.put("-markP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > (@PP > @AP)"), new SimpleStringFunction("-a")));
            this.annotationPatterns.put("-markP3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > (@PP > @SENT|Ssub|VPinf|VPpart)"), new SimpleStringFunction("-v")));
            this.annotationPatterns.put("-markP4", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > (@PP > @Srel)"), new SimpleStringFunction("-r")));
            this.annotationPatterns.put("-markP5", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > (@PP > @COORD)"), new SimpleStringFunction("-c")));
            this.annotationPatterns.put("-markP6", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > @VPinf"), new SimpleStringFunction("-b")));
            this.annotationPatterns.put("-markP7", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > @VPpart"), new SimpleStringFunction("-b")));
            this.annotationPatterns.put("-markP8", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > /^MW|NP/"), new SimpleStringFunction("-internal")));
            this.annotationPatterns.put("-markP9", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@P > @COORD"), new SimpleStringFunction("-c")));
            this.annotationPatterns.put("-hasMWP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("!/S/ < @MWP"), new SimpleStringFunction("-mwp")));
            this.annotationPatterns.put("-hasMWP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP < @MWP"), new SimpleStringFunction("-mwp2")));
            this.annotationPatterns.put("-hasMWN2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP <+(@NP) @MWN"), new SimpleStringFunction("-hasMWN2")));
            this.annotationPatterns.put("-hasMWN3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < @MWN"), new SimpleStringFunction("-hasMWN3")));
            this.annotationPatterns.put("-hasMWADV", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("/^A/ < @MWADV"), new SimpleStringFunction("-hasmwadv")));
            this.annotationPatterns.put("-hasC1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ < @MWC"), new SimpleStringFunction("-hasc1")));
            this.annotationPatterns.put("-hasC2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@MWC > /S/"), new SimpleStringFunction("-hasc2")));
            this.annotationPatterns.put("-hasC3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@COORD < @MWC"), new SimpleStringFunction("-hasc3")));
            this.annotationPatterns.put("-uMWN", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP <: @MWN"), new SimpleStringFunction("-umwn")));
            this.annotationPatterns.put("-splitC", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@C < __=word"), new AddRelativeNodeFunction("-", "word", false)));
            this.annotationPatterns.put("-splitD", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@D < /^[^\\d+]{1,4}$/=word"), new AddRelativeNodeFunction("-", "word", false)));
            this.annotationPatterns.put("-de1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@D < /^([Dd]es?|du|d')$/"), new SimpleStringFunction("-de1")));
            this.annotationPatterns.put("-markNNP1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < (N < /^[A-Z]/) !< /^[^NA]/"), new SimpleStringFunction("-nnp")));
            this.annotationPatterns.put("-markPP1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP > @NP"), new SimpleStringFunction("-n")));
            this.annotationPatterns.put("-markPP2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP > @AP"), new SimpleStringFunction("-a")));
            this.annotationPatterns.put("-markPP3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP > @SENT|Ssub|VPinf|VPpart"), new SimpleStringFunction("-v")));
            this.annotationPatterns.put("-markPP4", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP > @Srel"), new SimpleStringFunction("-r")));
            this.annotationPatterns.put("-markPP5", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@PP > @COORD"), new SimpleStringFunction("-c")));
            this.annotationPatterns.put("-dominateCC", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << @COORD"), new SimpleStringFunction("-withCC")));
            this.annotationPatterns.put("-dominateIN", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << @PP"), new SimpleStringFunction("-withPP")));
            this.annotationPatterns.put("-markContainsVP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << /^VP/"), new SimpleStringFunction("-hasV")));
            this.annotationPatterns.put("-markContainsVP2", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("__ << /^VP/=word"), new AddRelativeNodeFunction("-hasV-", "word", false)));
            this.annotationPatterns.put("-markVNArgs", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@VN $+ __=word1"), new AddRelativeNodeFunction("-", "word1", false)));
            this.annotationPatterns.put("-markVNArgs2", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("@VN > __=word1 $+ __=word2"), new AddRelativeNodeFunction("-", "word1", "word2", false)));
            this.annotationPatterns.put("-markContainsMW", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ << /^MW/"), new SimpleStringFunction("-hasMW")));
            this.annotationPatterns.put("-markContainsMW2", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("__ << /^MW/=word"), new AddRelativeNodeFunction("-has-", "word", false)));
            this.annotationPatterns.put("-mwStart", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ >, /^MW/"), new SimpleStringFunction("-mwStart")));
            this.annotationPatterns.put("-mwMiddle", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ !>- /^MW/ !>, /^MW/ > /^MW/"), new SimpleStringFunction("-mwMid")));
            this.annotationPatterns.put("-mwMiddle2", new Pair<TregexPattern, AddRelativeNodeFunction>(tregexPatternCompiler.compile("__ !>- /^MW/ !>, /^MW/ > /^MW/ , __=pos"), new AddRelativeNodeFunction("-", "pos", true)));
            this.annotationPatterns.put("-mwEnd", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("__ >- /^MW/"), new SimpleStringFunction("-mwEnd")));
            this.annotationPatterns.put("-nonNAP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@AP !$, @N|AP"), new SimpleStringFunction("-nap")));
            this.annotationPatterns.put("-markNPTMP", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < (@N < /^(lundi|mardi|mercredi|jeudi|vendredi|samedi|dimanche|Lundi|Mardi|Mercredi|Jeudi|Vendredi|Samedi|Dimanche|janvier|f\u00e9vrier|mars|avril|mai|juin|juillet|ao\u00fbt|septembre|octobre|novembre|d\u00e9cembre|Janvier|F\u00e9vrier|Mars|Avril|Mai|Juin|Juillet|Ao\u00fbt|Septembre|Octobre|Novembre|D\u00e9cembre)$/)"), new SimpleStringFunction("-tmp")));
            this.annotationPatterns.put("-markSing1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < (D < /^(ce|cette|une|la|le|un|sa|son|ma|mon|ta|ton)$/)"), new SimpleStringFunction("-sing")));
            this.annotationPatterns.put("-markSing2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@AP < (A < (/[^sx]$/ !< __))"), new SimpleStringFunction("-sing")));
            this.annotationPatterns.put("-markSing3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@VPpart < (V < /(e|\u00e9)$/)"), new SimpleStringFunction("-sing")));
            this.annotationPatterns.put("-markPl1", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@NP < (D < /s$/)"), new SimpleStringFunction("-pl")));
            this.annotationPatterns.put("-markPl2", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@AP < (A < /[sx]$/)"), new SimpleStringFunction("-pl")));
            this.annotationPatterns.put("-markPl3", new Pair<TregexPattern, SimpleStringFunction>(tregexPatternCompiler.compile("@VPpart < (V < /(es|\u00e9s)$/)"), new SimpleStringFunction("-pl")));
        }
        catch (ParseException e) {
            int nth = this.annotationPatterns.size() + 1;
            String nthStr = nth == 1 ? "1st" : (nth == 2 ? "2nd" : nth + "th");
            System.err.println("Parse exception on " + nthStr + " annotation pattern initialization:" + e);
        }
    }

    @Override
    public HeadFinder headFinder() {
        if (this.headFinder == null) {
            this.headFinder = new DybroFrenchHeadFinder(this.treebankLanguagePack());
        }
        return this.headFinder;
    }

    private void setHeadFinder(HeadFinder hf) {
        Pair<TregexPattern, Function<TregexMatcher, String>> p;
        if (hf == null) {
            throw new IllegalArgumentException();
        }
        this.headFinder = hf;
        this.initializeAnnotationPatterns();
        this.activeAnnotations.clear();
        for (String key : baselineFeatures) {
            p = this.annotationPatterns.get(key);
            this.activeAnnotations.put(p.first(), p.second());
        }
        for (String key : additionalFeatures) {
            p = this.annotationPatterns.get(key);
            this.activeAnnotations.put(p.first(), p.second());
        }
    }

    @Override
    public Lexicon lex() {
        if (this.morphoSpec != null) {
            return new FactoredLexicon(this.morphoSpec);
        }
        return new BaseLexicon();
    }

    @Override
    public Lexicon lex(Options.LexOptions op) {
        if (op.uwModel == null) {
            op.uwModel = "edu.stanford.nlp.parser.lexparser.FrenchUnknownWordModel";
        }
        if (this.morphoSpec != null) {
            return new FactoredLexicon(op, this.morphoSpec);
        }
        return new BaseLexicon(op);
    }

    @Override
    public String[] sisterSplitters() {
        return new String[0];
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.treebankLanguagePack(), this.collinizerRetainsPunctuation, false);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new FrenchTreeReaderFactory(this.readPennFormat);
    }

    public List<HasWord> defaultTestSentence() {
        String[] sent = new String[]{"Ceci", "est", "seulement", "un", "test", "."};
        return Sentence.toWordList(sent);
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        String baseCat = t.value();
        StringBuilder newCategory = new StringBuilder();
        for (Map.Entry<TregexPattern, Function<TregexMatcher, String>> e : this.activeAnnotations.entrySet()) {
            TregexMatcher m = e.getKey().matcher(root);
            if (!m.matchesAt(t)) continue;
            newCategory.append(e.getValue().apply(m));
        }
        if (t.isPreTerminal() && this.morphoSpec != null) {
            if (!(t.firstChild().label() instanceof CoreLabel) || ((CoreLabel)t.firstChild().label()).current() == null) {
                throw new RuntimeException(String.format("%s: Term lacks morpho analysis: %s", this.getClass().getName(), t.toString()));
            }
            String morphoStr = ((CoreLabel)t.firstChild().label()).current();
            MorphoFeatures feats = this.morphoSpec.strToFeatures(morphoStr);
            baseCat = feats.getTag(baseCat);
        }
        String newCat = baseCat + newCategory.toString();
        t.setValue(newCat);
        if (t.isPreTerminal() && t.label() instanceof HasTag) {
            ((HasTag)((Object)t.label())).setTag(newCat);
        }
        return t;
    }

    private void loadMWMap(String filename) {
        mwCounter = new TwoDimensionalCounter();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF-8"));
            int nLines = 0;
            while ((line = br.readLine()) != null) {
                String[] toks = line.split("\t");
                assert (toks.length == 3);
                mwCounter.setCount(toks[0].trim(), toks[1].trim(), Double.parseDouble(toks[2].trim()));
                ++nLines;
            }
            br.close();
            System.err.printf("%s: Loaded %d lines from %s into MWE counter%n", this.getClass().getName(), nLines, filename);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String setupMorphoFeatures(String activeFeats) {
        String[] feats = activeFeats.split(",");
        this.morphoSpec = this.tlp.morphFeatureSpec();
        for (String feat : feats) {
            MorphoFeatureSpecification.MorphoFeatureType fType = MorphoFeatureSpecification.MorphoFeatureType.valueOf(feat.trim());
            this.morphoSpec.activate(fType);
        }
        return this.morphoSpec.toString();
    }

    private void removeBaselineFeature(String featName) {
        if (baselineFeatures.contains(featName)) {
            baselineFeatures.remove(featName);
            Pair<TregexPattern, Function<TregexMatcher, String>> p = this.annotationPatterns.get(featName);
            this.activeAnnotations.remove(p.first());
        }
    }

    @Override
    public void display() {
        System.err.println(this.optionsString.toString());
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (this.annotationPatterns.keySet().contains(args[i])) {
            if (!baselineFeatures.contains(args[i])) {
                additionalFeatures.add(args[i]);
            }
            Pair<TregexPattern, Function<TregexMatcher, String>> p = this.annotationPatterns.get(args[i]);
            this.activeAnnotations.put(p.first(), p.second());
            this.optionsString.append("Option " + args[i] + " added annotation pattern " + p.first() + " with annotation " + p.second() + '\n');
            ++i;
        } else if (args[i].equals("-collinizerRetainsPunctuation")) {
            this.optionsString.append("Collinizer retains punctuation.\n");
            this.collinizerRetainsPunctuation = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                HeadFinder hf = (HeadFinder)Class.forName(args[i + 1]).newInstance();
                this.setHeadFinder(hf);
                this.optionsString.append("HeadFinder: " + args[i + 1] + "\n");
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
            }
            i += 2;
        } else if (args[i].equals("-xmlFormat")) {
            this.optionsString.append("Reading trees in XML format.\n");
            this.readPennFormat = false;
            this.setInputEncoding(this.tlp.getEncoding());
            ++i;
        } else if (args[i].equals("-frenchFactored")) {
            for (String annotation : baselineFeatures) {
                String[] a = new String[]{annotation};
                this.setOptionFlag(a, 0);
            }
            ++i;
        } else if (args[i].equals("-frenchMWMap")) {
            this.loadMWMap(args[i + 1]);
            i += 2;
        } else if (args[i].equals("-tsg")) {
            this.optionsString.append("Removing baseline features: ");
            this.removeBaselineFeature("-markVN");
            this.optionsString.append(" (removed -markVN)");
            this.removeBaselineFeature("-coord1");
            this.optionsString.append(" (removed -coord1)\n");
            ++i;
        } else if (args[i].equals("-factlex") && i + 1 < args.length) {
            String activeFeats = this.setupMorphoFeatures(args[i + 1]);
            this.optionsString.append("Factored Lexicon: active features: ").append(activeFeats);
            this.removeBaselineFeature("-tagPAFr");
            this.optionsString.append(" (removed -tagPAFr)\n");
            i += 2;
        } else if (args[i].equals("-noFeatures")) {
            this.activeAnnotations.clear();
            this.optionsString.append("Removed all manual features.\n");
            ++i;
        }
        return i;
    }

    static {
        baselineFeatures = new ArrayList<String>();
        baselineFeatures.add("-tagPAFr");
        baselineFeatures.add("-markInf");
        baselineFeatures.add("-markPart");
        baselineFeatures.add("-markVN");
        baselineFeatures.add("-coord1");
        baselineFeatures.add("-de2");
        baselineFeatures.add("-markP1");
        baselineFeatures.add("-MWAdvS");
        baselineFeatures.add("-MWADVSel1");
        baselineFeatures.add("-MWADVSel2");
        baselineFeatures.add("-MWNSel1");
        baselineFeatures.add("-MWNSel2");
        baselineFeatures.add("-MWNSel3");
        additionalFeatures = new ArrayList<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddPOSSequenceFunction
    implements SerializableFunction<TregexMatcher, String> {
        private final String annotationMark;
        private final boolean doBasicCat;
        private final double cutoff;
        private static final TreebankLanguagePack tlp = new FrenchTreebankLanguagePack();
        private static final long serialVersionUID = 1L;

        public AddPOSSequenceFunction(String annotationMark, int cutoff, boolean basicCategory) {
            this.annotationMark = annotationMark;
            this.doBasicCat = basicCategory;
            this.cutoff = cutoff;
        }

        @Override
        public String apply(TregexMatcher m) {
            if (mwCounter == null) {
                throw new RuntimeException("Cannot enable POSSequence features without POS sequence map. Use option -frenchMWMap.");
            }
            Tree t = m.getMatch();
            StringBuilder sb = new StringBuilder();
            for (Tree kid : t.children()) {
                if (!kid.isPreTerminal()) {
                    throw new RuntimeException("Not POS sequence for tree: " + t.toString());
                }
                String tag = this.doBasicCat ? tlp.basicCategory(kid.value()) : kid.value();
                sb.append(tag).append(" ");
            }
            if (mwCounter.getCount(t.value(), sb.toString().trim()) > this.cutoff) {
                return this.annotationMark + sb.toString().replaceAll("\\s+", "").toLowerCase();
            }
            return "";
        }

        public String toString() {
            return "AddPOSSequenceFunction[" + this.annotationMark + ',' + this.cutoff + ',' + this.doBasicCat + ']';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddRelativeNodeFunction
    implements SerializableFunction<TregexMatcher, String> {
        private String annotationMark;
        private String key;
        private String key2;
        private boolean doBasicCat = false;
        private boolean toLower = false;
        private static final TreebankLanguagePack tlp = new FrenchTreebankLanguagePack();
        private static final long serialVersionUID = 1L;

        public AddRelativeNodeFunction(String annotationMark, String key, boolean basicCategory) {
            this.annotationMark = annotationMark;
            this.key = key;
            this.key2 = null;
            this.doBasicCat = basicCategory;
        }

        public AddRelativeNodeFunction(String annotationMark, String key1, String key2, boolean basicCategory) {
            this(annotationMark, key1, basicCategory);
            this.key2 = key2;
        }

        public AddRelativeNodeFunction(String annotationMark, String key1, boolean basicCategory, boolean toLower) {
            this(annotationMark, key1, basicCategory);
            this.toLower = toLower;
        }

        @Override
        public String apply(TregexMatcher m) {
            String tag;
            if (this.key2 == null) {
                tag = this.annotationMark + (this.doBasicCat ? tlp.basicCategory(m.getNode(this.key).label().value()) : m.getNode(this.key).label().value());
            } else {
                String annot1 = this.doBasicCat ? tlp.basicCategory(m.getNode(this.key).label().value()) : m.getNode(this.key).label().value();
                String annot2 = this.doBasicCat ? tlp.basicCategory(m.getNode(this.key2).label().value()) : m.getNode(this.key2).label().value();
                tag = this.annotationMark + annot1 + this.annotationMark + annot2;
            }
            return this.toLower ? tag.toLowerCase() : tag;
        }

        public String toString() {
            if (this.key2 == null) {
                return "AddRelativeNodeFunction[" + this.annotationMark + ',' + this.key + ']';
            }
            return "AddRelativeNodeFunction[" + this.annotationMark + ',' + this.key + ',' + this.key2 + ']';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleStringFunction
    implements SerializableFunction<TregexMatcher, String> {
        private String annotationMark;
        private static final long serialVersionUID = 1L;

        public SimpleStringFunction(String annotationMark) {
            this.annotationMark = annotationMark;
        }

        @Override
        public String apply(TregexMatcher tregexMatcher) {
            return this.annotationMark;
        }

        public String toString() {
            return "SimpleStringFunction[" + this.annotationMark + ']';
        }
    }
}

