/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.WordCatConstituent;
import edu.stanford.nlp.trees.international.pennchinese.CharacterLevelTagExtender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TreeToBracketProcessor {
    public List evalTypes = new ArrayList();
    public static CharacterLevelTagExtender ext = new CharacterLevelTagExtender();

    public TreeToBracketProcessor(List evalTypes) {
        this.evalTypes = evalTypes;
    }

    public Collection allBrackets(Tree root) {
        boolean words = this.evalTypes.contains("word");
        boolean tags = this.evalTypes.contains("tag");
        boolean cats = this.evalTypes.contains("cat");
        ArrayList<WordCatConstituent> brackets = new ArrayList<WordCatConstituent>();
        if (words || cats || tags) {
            root = ext.transformTree(root);
            for (Tree tree : root) {
                if (tree.isPrePreTerminal() && !tree.value().equals("ROOT")) {
                    if (words) {
                        brackets.add(new WordCatConstituent(tree, root, "word"));
                    }
                    if (!tags) continue;
                    brackets.add(new WordCatConstituent(tree, root, "tag"));
                    continue;
                }
                if (!cats || !tree.isPhrasal() || tree.value().equals("ROOT")) continue;
                brackets.add(new WordCatConstituent(tree, root, "cat"));
            }
        }
        return brackets;
    }

    public Collection commonWordTagTypeBrackets(Tree root1, Tree root2) {
        root1 = ext.transformTree(root1);
        root2 = ext.transformTree(root2);
        ArrayList<Tree> firstPreTerms = new ArrayList<Tree>();
        for (Tree tree : root1) {
            if (!tree.isPrePreTerminal()) continue;
            firstPreTerms.add(tree);
        }
        ArrayList<WordCatConstituent> brackets = new ArrayList<WordCatConstituent>();
        block1: for (Tree preTerm : firstPreTerms) {
            for (Tree tree : root2) {
                if (!tree.isPrePreTerminal() || Trees.leftEdge(tree, root2) != Trees.leftEdge(preTerm, root1) || Trees.rightEdge(tree, root2) != Trees.rightEdge(preTerm, root1)) continue;
                brackets.add(new WordCatConstituent(preTerm, root1, "goodWordTag"));
                continue block1;
            }
        }
        return brackets;
    }
}

