"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMapLanguage = exports.fromMBtoBytes = void 0;
exports.isEscapeKey = isEscapeKey;

var _i18n = require("@osd/i18n");

var _index = require("./index");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const fromMBtoBytes = sizeInMB => {
  return sizeInMB * 1024 * 1024;
};

exports.fromMBtoBytes = fromMBtoBytes;

const getMapLanguage = () => {
  const OSDLanguage = _i18n.i18n.getLocale().toLowerCase(),
        parts = OSDLanguage.split('-');

  const languageCode = parts.length > 1 ? parts[0] : OSDLanguage;
  return _index.OSD_LANGUAGES.includes(languageCode) ? languageCode : _index.FALLBACK_LANGUAGE;
};

exports.getMapLanguage = getMapLanguage;

function isEscapeKey(e) {
  return e.code === 'Escape';
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOlsiZnJvbU1CdG9CeXRlcyIsInNpemVJbk1CIiwiZ2V0TWFwTGFuZ3VhZ2UiLCJPU0RMYW5ndWFnZSIsImkxOG4iLCJnZXRMb2NhbGUiLCJ0b0xvd2VyQ2FzZSIsInBhcnRzIiwic3BsaXQiLCJsYW5ndWFnZUNvZGUiLCJsZW5ndGgiLCJPU0RfTEFOR1VBR0VTIiwiaW5jbHVkZXMiLCJGQUxMQkFDS19MQU5HVUFHRSIsImlzRXNjYXBlS2V5IiwiZSIsImNvZGUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBSUE7O0FBQ0E7O0FBTEE7QUFDQTtBQUNBO0FBQ0E7QUFJTyxNQUFNQSxhQUFhLEdBQUlDLFFBQUQsSUFBc0I7QUFDakQsU0FBT0EsUUFBUSxHQUFHLElBQVgsR0FBa0IsSUFBekI7QUFDRCxDQUZNOzs7O0FBSUEsTUFBTUMsY0FBYyxHQUFHLE1BQU07QUFDbEMsUUFBTUMsV0FBVyxHQUFHQyxXQUFLQyxTQUFMLEdBQWlCQyxXQUFqQixFQUFwQjtBQUFBLFFBQ0VDLEtBQUssR0FBR0osV0FBVyxDQUFDSyxLQUFaLENBQWtCLEdBQWxCLENBRFY7O0FBRUEsUUFBTUMsWUFBWSxHQUFHRixLQUFLLENBQUNHLE1BQU4sR0FBZSxDQUFmLEdBQW1CSCxLQUFLLENBQUMsQ0FBRCxDQUF4QixHQUE4QkosV0FBbkQ7QUFDQSxTQUFPUSxxQkFBY0MsUUFBZCxDQUF1QkgsWUFBdkIsSUFBdUNBLFlBQXZDLEdBQXNESSx3QkFBN0Q7QUFDRCxDQUxNOzs7O0FBT0EsU0FBU0MsV0FBVCxDQUFxQkMsQ0FBckIsRUFBdUM7QUFDNUMsU0FBT0EsQ0FBQyxDQUFDQyxJQUFGLEtBQVcsUUFBbEI7QUFDRCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cbmltcG9ydCB7IGkxOG4gfSBmcm9tICdAb3NkL2kxOG4nO1xuaW1wb3J0IHsgT1NEX0xBTkdVQUdFUywgRkFMTEJBQ0tfTEFOR1VBR0UgfSBmcm9tICcuL2luZGV4JztcblxuZXhwb3J0IGNvbnN0IGZyb21NQnRvQnl0ZXMgPSAoc2l6ZUluTUI6IG51bWJlcikgPT4ge1xuICByZXR1cm4gc2l6ZUluTUIgKiAxMDI0ICogMTAyNDtcbn07XG5cbmV4cG9ydCBjb25zdCBnZXRNYXBMYW5ndWFnZSA9ICgpID0+IHtcbiAgY29uc3QgT1NETGFuZ3VhZ2UgPSBpMThuLmdldExvY2FsZSgpLnRvTG93ZXJDYXNlKCksXG4gICAgcGFydHMgPSBPU0RMYW5ndWFnZS5zcGxpdCgnLScpO1xuICBjb25zdCBsYW5ndWFnZUNvZGUgPSBwYXJ0cy5sZW5ndGggPiAxID8gcGFydHNbMF0gOiBPU0RMYW5ndWFnZTtcbiAgcmV0dXJuIE9TRF9MQU5HVUFHRVMuaW5jbHVkZXMobGFuZ3VhZ2VDb2RlKSA/IGxhbmd1YWdlQ29kZSA6IEZBTExCQUNLX0xBTkdVQUdFO1xufTtcblxuZXhwb3J0IGZ1bmN0aW9uIGlzRXNjYXBlS2V5KGU6IEtleWJvYXJkRXZlbnQpIHtcbiAgcmV0dXJuIGUuY29kZSA9PT0gJ0VzY2FwZSc7XG59XG4iXX0=