/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindow;

public class DescribeInstanceEventWindowsPublisher
implements SdkPublisher<DescribeInstanceEventWindowsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceEventWindowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceEventWindowsPublisher(Ec2AsyncClient client, DescribeInstanceEventWindowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceEventWindowsPublisher(Ec2AsyncClient client, DescribeInstanceEventWindowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceEventWindowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceEventWindowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceEventWindow> instanceEventWindows() {
        Function<DescribeInstanceEventWindowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceEventWindows() != null) {
                return response.instanceEventWindows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceEventWindowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceEventWindowsResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceEventWindowsResponse> {
        private DescribeInstanceEventWindowsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceEventWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceEventWindowsResponse> nextPage(DescribeInstanceEventWindowsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceEventWindowsPublisher.this.client.describeInstanceEventWindows(DescribeInstanceEventWindowsPublisher.this.firstRequest);
            }
            return DescribeInstanceEventWindowsPublisher.this.client.describeInstanceEventWindows((DescribeInstanceEventWindowsRequest)((Object)DescribeInstanceEventWindowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

