/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo;

public class ListSnapshotsInRecycleBinIterable
implements SdkIterable<ListSnapshotsInRecycleBinResponse> {
    private final Ec2Client client;
    private final ListSnapshotsInRecycleBinRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSnapshotsInRecycleBinIterable(Ec2Client client, ListSnapshotsInRecycleBinRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSnapshotsInRecycleBinResponseFetcher();
    }

    public Iterator<ListSnapshotsInRecycleBinResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotRecycleBinInfo> snapshots() {
        Function<ListSnapshotsInRecycleBinResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSnapshotsInRecycleBinResponseFetcher
    implements SyncPageFetcher<ListSnapshotsInRecycleBinResponse> {
        private ListSnapshotsInRecycleBinResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotsInRecycleBinResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSnapshotsInRecycleBinResponse nextPage(ListSnapshotsInRecycleBinResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotsInRecycleBinIterable.this.client.listSnapshotsInRecycleBin(ListSnapshotsInRecycleBinIterable.this.firstRequest);
            }
            return ListSnapshotsInRecycleBinIterable.this.client.listSnapshotsInRecycleBin((ListSnapshotsInRecycleBinRequest)((Object)ListSnapshotsInRecycleBinIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

