/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.transform.action.delete.DeleteTransformsRequest;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/transform/action/delete/TransportDeleteTransformsAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/transform/action/delete/DeleteTransformsRequest;", "Lorg/opensearch/action/bulk/BulkResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/action/support/ActionFilters;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "DeleteTransformHandler", "opensearch-index-management"})
public final class TransportDeleteTransformsAction
extends HandledTransportAction<DeleteTransformsRequest, BulkResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportDeleteTransformsAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ActionFilters actionFilters) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        super("cluster:admin/opendistro/transform/delete", transportService, actionFilters, DeleteTransformsRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportDeleteTransformsAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull DeleteTransformsRequest request, @NotNull ActionListener<BulkResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        new DeleteTransformHandler(this, this.client, request, actionListener, null, 8, null).start();
    }

    private static final void _init_$lambda$0(TransportDeleteTransformsAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ4\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0006\u0010\u001d\u001a\u00020\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/transform/action/delete/TransportDeleteTransformsAction$DeleteTransformHandler;", "", "client", "Lorg/opensearch/client/Client;", "request", "Lorg/opensearch/indexmanagement/transform/action/delete/DeleteTransformsRequest;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/action/bulk/BulkResponse;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/transform/action/delete/TransportDeleteTransformsAction;Lorg/opensearch/client/Client;Lorg/opensearch/indexmanagement/transform/action/delete/DeleteTransformsRequest;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/commons/authuser/User;)V", "getActionListener", "()Lorg/opensearch/core/action/ActionListener;", "getClient", "()Lorg/opensearch/client/Client;", "getRequest", "()Lorg/opensearch/indexmanagement/transform/action/delete/DeleteTransformsRequest;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "bulkDelete", "", "response", "Lorg/opensearch/action/get/MultiGetResponse;", "ids", "", "", "forceDelete", "", "start", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransportDeleteTransformsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportDeleteTransformsAction.kt\norg/opensearch/indexmanagement/transform/action/delete/TransportDeleteTransformsAction$DeleteTransformHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,181:1\n1855#2,2:182\n13579#3,2:184\n*S KotlinDebug\n*F\n+ 1 TransportDeleteTransformsAction.kt\norg/opensearch/indexmanagement/transform/action/delete/TransportDeleteTransformsAction$DeleteTransformHandler\n*L\n79#1:182,2\n117#1:184,2\n*E\n"})
    public final class DeleteTransformHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final DeleteTransformsRequest request;
        @NotNull
        private final ActionListener<BulkResponse> actionListener;
        @Nullable
        private final User user;
        final /* synthetic */ TransportDeleteTransformsAction this$0;

        public DeleteTransformHandler(@NotNull TransportDeleteTransformsAction this$0, @NotNull Client client, @NotNull DeleteTransformsRequest request, @Nullable ActionListener<BulkResponse> actionListener, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            this.this$0 = this$0;
            this.client = client;
            this.request = request;
            this.actionListener = actionListener;
            this.user = user;
        }

        public /* synthetic */ DeleteTransformHandler(TransportDeleteTransformsAction transportDeleteTransformsAction, Client client, DeleteTransformsRequest deleteTransformsRequest, ActionListener actionListener, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportDeleteTransformsAction, client, deleteTransformsRequest, (ActionListener<BulkResponse>)actionListener, user);
        }

        @NotNull
        public final Client getClient() {
            return this.client;
        }

        @NotNull
        public final DeleteTransformsRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final ActionListener<BulkResponse> getActionListener() {
            return this.actionListener;
        }

        @Nullable
        public final User getUser() {
            return this.user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            this.this$0.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            MultiGetRequest getRequest = new MultiGetRequest();
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true);
            Iterable $this$forEach$iv = this.request.getIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String id2 = (String)element$iv;
                boolean bl = false;
                getRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", id2).fetchSourceContext(fetchSourceContext));
            }
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                this.client.multiGet(getRequest, (ActionListener)new ActionListener<MultiGetResponse>(this){
                    final /* synthetic */ DeleteTransformHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull MultiGetResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        try {
                            MultiGetItemResponse[] multiGetItemResponseArray = response2.getResponses();
                            Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
                            if (((MultiGetItemResponse)ArraysKt.first((Object[])multiGetItemResponseArray)).isFailed()) {
                                this.this$0.getActionListener().onFailure((Exception)((Object)new OpenSearchStatusException("Cluster missing system index .opendistro-ism-config, cannot execute the request", RestStatus.BAD_REQUEST, new Object[0])));
                                return;
                            }
                            DeleteTransformHandler.access$bulkDelete(this.this$0, response2, this.this$0.getRequest().getIds(), this.this$0.getRequest().getForce(), this.this$0.getActionListener());
                        }
                        catch (Exception e) {
                            this.this$0.getActionListener().onFailure(e);
                        }
                    }

                    public void onFailure(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.getActionListener().onFailure(e);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void bulkDelete(MultiGetResponse response2, List<String> ids, boolean forceDelete, ActionListener<BulkResponse> actionListener) {
            void $this$forEach$iv;
            List enabledIDs = new ArrayList();
            List notTransform = new ArrayList();
            List noPermission = new ArrayList();
            MultiGetItemResponse[] multiGetItemResponseArray = response2.getResponses();
            Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"response.responses");
            Object[] objectArray = multiGetItemResponseArray;
            TransportDeleteTransformsAction transportDeleteTransformsAction = this.this$0;
            boolean $i$f$forEach = false;
            for (void element$iv : $this$forEach$iv) {
                MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
                boolean bl = false;
                if (!it.getResponse().isExists()) continue;
                try {
                    GetResponse getResponse2 = it.getResponse();
                    Intrinsics.checkNotNullExpressionValue((Object)getResponse2, (String)"it.response");
                    Transform transform2 = (Transform)OpenSearchExtensionsKt.parseFromGetResponse(getResponse2, transportDeleteTransformsAction.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

                        @NotNull
                        public final Transform invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
                        }
                    });
                    boolean enabled = transform2.getEnabled();
                    if (enabled && !forceDelete) {
                        String string = it.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                        enabledIDs.add(string);
                    }
                    User user = transform2.getUser();
                    Boolean bl2 = transportDeleteTransformsAction.filterByEnabled;
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                    if (SecurityUtils.Companion.userHasPermissionForResource(this.user, user, bl2)) continue;
                    String string = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                    noPermission.add(string);
                }
                catch (Exception e) {
                    String string = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                    notTransform.add(string);
                }
            }
            if (!((Collection)noPermission).isEmpty()) {
                actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Don't have permission to delete some/all transforms in [" + this.request.getIds() + "]", RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            if (!((Collection)notTransform).isEmpty()) {
                actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Cannot find transforms " + notTransform, RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            if (!((Collection)enabledIDs).isEmpty()) {
                actionListener.onFailure((Exception)((Object)new OpenSearchStatusException(enabledIDs + " transform(s) are enabled, please disable them before deleting them or set force flag", RestStatus.CONFLICT, new Object[0])));
                return;
            }
            BulkRequest bulkDeleteRequest = new BulkRequest();
            bulkDeleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (String id2 : ids) {
                bulkDeleteRequest.add(new DeleteRequest(".opendistro-ism-config", id2));
            }
            this.client.bulk(bulkDeleteRequest, (ActionListener)new ActionListener<BulkResponse>(actionListener){
                final /* synthetic */ ActionListener<BulkResponse> $actionListener;
                {
                    this.$actionListener = $actionListener;
                }

                public void onResponse(@NotNull BulkResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$actionListener.onFailure(e);
                }
            });
        }

        public static final /* synthetic */ void access$bulkDelete(DeleteTransformHandler $this, MultiGetResponse response2, List ids, boolean forceDelete, ActionListener actionListener) {
            $this.bulkDelete(response2, ids, forceDelete, (ActionListener<BulkResponse>)actionListener);
        }
    }
}

