/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.get;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.transform.action.get.GetTransformRequest;
import org.opensearch.indexmanagement.transform.action.get.GetTransformResponse;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lorg/opensearch/indexmanagement/transform/action/get/TransportGetTransformAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/transform/action/get/GetTransformRequest;", "Lorg/opensearch/indexmanagement/transform/action/get/GetTransformResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-index-management"})
public final class TransportGetTransformAction
extends HandledTransportAction<GetTransformRequest, GetTransformResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportGetTransformAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/transform/get", transportService, actionFilters, GetTransformRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetTransformAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetTransformRequest request, @NotNull ActionListener<GetTransformResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId()).preference(request.getPreference());
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(listener, this, user, request){
                final /* synthetic */ ActionListener<GetTransformResponse> $listener;
                final /* synthetic */ TransportGetTransformAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ GetTransformRequest $request;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        GetTransformResponse getTransformResponse;
                        Transform transform2 = null;
                        try {
                            transform2 = (Transform)OpenSearchExtensionsKt.parseFromGetResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Transform>((Object)Transform.Companion){

                                @NotNull
                                public final Transform invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    return ((Transform.Companion)this.receiver).parse(p0, p1, p2, p3);
                                }
                            });
                        }
                        catch (IllegalArgumentException e) {
                            this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        User user = transform2.getUser();
                        Boolean bl = TransportGetTransformAction.access$getFilterByEnabled$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
                        if (!SecurityUtils.Companion.userHasPermissionForResource(this.$user, user, bl, "transform", this.$request.getId(), this.$listener)) {
                            return;
                        }
                        if (this.$request.getSrcContext() != null && !this.$request.getSrcContext().fetchSource()) {
                            String string = response2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                            getTransformResponse = new GetTransformResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, null);
                        } else {
                            String string = response2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                            getTransformResponse = new GetTransformResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, transform2);
                        }
                        GetTransformResponse transformResponse = getTransformResponse;
                        this.$listener.onResponse((Object)((Object)transformResponse));
                    }
                    catch (Exception e) {
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Failed to parse transform", RestStatus.INTERNAL_SERVER_ERROR, ExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.onFailure(e);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda$0(TransportGetTransformAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportGetTransformAction $this) {
        return $this.filterByEnabled;
    }
}

