/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameType;
import org.opensearch.ml.common.dataframe.DefaultDataFrame;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;

@InputDataSet(value=MLInputDataType.DATA_FRAME)
public class DataFrameInputDataset
extends MLInputDataset {
    private final DataFrame dataFrame;

    public DataFrameInputDataset(@NonNull DataFrame dataFrame) {
        super(MLInputDataType.DATA_FRAME);
        Objects.requireNonNull(dataFrame, "dataFrame is marked non-null but is null");
        this.dataFrame = dataFrame;
    }

    public DataFrameInputDataset(StreamInput in) throws IOException {
        super(MLInputDataType.DATA_FRAME);
        DataFrameType dataFrameType = (DataFrameType)in.readEnum(DataFrameType.class);
        switch (dataFrameType) {
            case DEFAULT: {
                this.dataFrame = new DefaultDataFrame(in);
                break;
            }
            default: {
                this.dataFrame = null;
            }
        }
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        this.dataFrame.writeTo(streamOutput);
    }

    @Generated
    public static DataFrameInputDatasetBuilder builder() {
        return new DataFrameInputDatasetBuilder();
    }

    @Generated
    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Generated
    public static class DataFrameInputDatasetBuilder {
        @Generated
        private DataFrame dataFrame;

        @Generated
        DataFrameInputDatasetBuilder() {
        }

        @Generated
        public DataFrameInputDatasetBuilder dataFrame(@NonNull DataFrame dataFrame) {
            Objects.requireNonNull(dataFrame, "dataFrame is marked non-null but is null");
            this.dataFrame = dataFrame;
            return this;
        }

        @Generated
        public DataFrameInputDataset build() {
            return new DataFrameInputDataset(this.dataFrame);
        }

        @Generated
        public String toString() {
            return "DataFrameInputDataset.DataFrameInputDatasetBuilder(dataFrame=" + this.dataFrame + ")";
        }
    }
}

