/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;

public class ValidationResult<C> {
    private final RestStatus status;
    private final C content;
    private final ToXContent errorMessage;

    private ValidationResult(C jsonContent) {
        this(RestStatus.OK, jsonContent, null);
    }

    private ValidationResult(RestStatus status, ToXContent errorMessage) {
        this(status, null, errorMessage);
    }

    private ValidationResult(RestStatus status, C jsonContent, ToXContent errorMessage) {
        this.status = status;
        this.content = jsonContent;
        this.errorMessage = errorMessage;
    }

    public static <L> ValidationResult<L> success(L content) {
        return new ValidationResult<L>(content);
    }

    public static <L> ValidationResult<L> error(RestStatus status, ToXContent errorMessage) {
        return new ValidationResult(status, errorMessage);
    }

    public <L> ValidationResult<L> map(CheckedFunction<C, ValidationResult<L>, IOException> mapper) throws IOException {
        if (this.content != null) {
            return (ValidationResult)Objects.requireNonNull(mapper).apply(this.content);
        }
        return ValidationResult.error(this.status, this.errorMessage);
    }

    public void error(CheckedBiConsumer<RestStatus, ToXContent, IOException> mapper) throws IOException {
        if (this.errorMessage != null) {
            Objects.requireNonNull(mapper).accept((Object)this.status, (Object)this.errorMessage);
        }
    }

    public ValidationResult<C> valid(CheckedConsumer<C, IOException> mapper) throws IOException {
        if (this.content != null) {
            Objects.requireNonNull(mapper).accept(this.content);
        }
        return this;
    }

    public RestStatus status() {
        return this.status;
    }

    public boolean isValid() {
        return this.errorMessage == null;
    }

    public ToXContent errorMessage() {
        return this.errorMessage;
    }
}

