/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.Imports;

public class ReferenceFinder {
    public ReferenceSet getReferenceSet(Collection<? extends OWLEntity> entities, OWLOntology ontology) {
        ImmutableSet.Builder axiomSetBuilder = ImmutableSet.builder();
        ImmutableSet.Builder ontologyAnnotationSetBuilder = ImmutableSet.builder();
        Set<Object> entityIRIs = new HashSet(entities.size());
        for (OWLEntity oWLEntity : entities) {
            Set refs = ontology.getReferencingAxioms((OWLPrimitive)oWLEntity, Imports.EXCLUDED);
            axiomSetBuilder.addAll((Iterable)refs);
            entityIRIs.add(oWLEntity.getIRI());
        }
        if (entityIRIs.size() == 1) {
            entityIRIs = Collections.singleton((IRI)entityIRIs.iterator().next());
        }
        for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            OWLAnnotationSubject subject = oWLAnnotationAssertionAxiom.getSubject();
            if (subject instanceof IRI && entityIRIs.contains(subject)) {
                axiomSetBuilder.add((Object)oWLAnnotationAssertionAxiom);
                continue;
            }
            OWLAnnotationValue value = oWLAnnotationAssertionAxiom.getValue();
            if (!(value instanceof IRI) || !entityIRIs.contains(value)) continue;
            axiomSetBuilder.add((Object)oWLAnnotationAssertionAxiom);
        }
        for (OWLAnnotation oWLAnnotation : ontology.getAnnotations()) {
            OWLAnnotationValue value = oWLAnnotation.getValue();
            if (value instanceof IRI && entityIRIs.contains(value)) {
                ontologyAnnotationSetBuilder.add((Object)oWLAnnotation);
                continue;
            }
            if (!entities.contains(oWLAnnotation.getProperty())) continue;
            ontologyAnnotationSetBuilder.add((Object)oWLAnnotation);
        }
        return new ReferenceSet(ontology, (ImmutableCollection<OWLAxiom>)axiomSetBuilder.build(), (ImmutableCollection<OWLAnnotation>)ontologyAnnotationSetBuilder.build());
    }

    public static final class ReferenceSet {
        private final OWLOntology ontology;
        private final ImmutableCollection<OWLAxiom> referencingAxioms;
        private final ImmutableCollection<OWLAnnotation> referencingOntologyAnnotations;

        public ReferenceSet(OWLOntology ontology, ImmutableCollection<OWLAxiom> referencingAxioms, ImmutableCollection<OWLAnnotation> referencingOntologyAnnotations) {
            this.ontology = (OWLOntology)Preconditions.checkNotNull((Object)ontology);
            this.referencingAxioms = (ImmutableCollection)Preconditions.checkNotNull(referencingAxioms);
            this.referencingOntologyAnnotations = (ImmutableCollection)Preconditions.checkNotNull(referencingOntologyAnnotations);
        }

        public OWLOntology getOntology() {
            return this.ontology;
        }

        public ImmutableCollection<OWLAxiom> getReferencingAxioms() {
            return this.referencingAxioms;
        }

        public ImmutableCollection<OWLAnnotation> getReferencingOntologyAnnotations() {
            return this.referencingOntologyAnnotations;
        }
    }
}

