/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.util.Bijection;
import net.sf.sdedit.util.Utilities;

public class DateSwitcher
extends JPanel
implements ActionListener {
    private static Bijection<Integer, Integer> dateComponents = new Bijection();
    private JLabel dateLabel;
    private JButton previousButton;
    private JButton nextButton;
    private JButton reloadButton;
    private List<DateSwitcherListener> listeners;
    private final DateFormat dateFormat;
    private GregorianCalendar calendar;
    private int granularity;

    public DateSwitcher(String dateFormat, int granularity) {
        this(new SimpleDateFormat(dateFormat), granularity);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel datePanel = new JPanel();
        datePanel.setLayout(new BorderLayout());
        this.dateLabel = new JLabel();
        this.dateLabel.setHorizontalAlignment(0);
        datePanel.add((Component)this.dateLabel, "Center");
        this.reloadButton = new JButton(Icons.getIcon("reload"));
        this.reloadButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        datePanel.add((Component)this.reloadButton, "East");
        this.previousButton = new JButton(Icons.getIcon("previous"));
        this.previousButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 5));
        this.nextButton = new JButton(Icons.getIcon("next"));
        this.nextButton.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.add((Component)this.previousButton, "West");
        this.add((Component)datePanel, "Center");
        this.add((Component)this.nextButton, "East");
        this.listeners = new LinkedList<DateSwitcherListener>();
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.reloadButton.addActionListener(this);
        this.calendar = new GregorianCalendar(TimeZone.getDefault());
    }

    public DateSwitcher(DateFormat dateFormat, int granularity) {
        this.dateFormat = dateFormat;
        this.granularity = dateComponents.getPreImage(granularity);
        this.init();
    }

    public DateSwitcher() {
        this(DateFormat.getDateInstance(), 5);
    }

    public void addDateSwitcherListener(DateSwitcherListener listener) {
        this.listeners.add(listener);
    }

    public void removeDateSwitcherListener(DateSwitcherListener listener) {
        this.listeners.remove(listener);
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
        if (this.granularity == 2) {
            return;
        }
        for (int i = this.granularity + 1; i < dateComponents.size(); ++i) {
            int r = 0;
            if (this.granularity == 1 || this.granularity == 0) {
                r = 1;
            }
            if (i == 2) continue;
            this.calendar.set(dateComponents.getImage(i), r);
        }
        this.update();
    }

    public void update() {
        this.dateLabel.setText(this.formatDate());
        for (DateSwitcherListener listener : Collections.checkedCollection(this.listeners, DateSwitcherListener.class)) {
            listener.dateSwitched(this, this.calendar.getTime());
        }
        this.dateLabel.requestFocusInWindow();
    }

    public String formatDate() {
        return this.dateFormat.format(this.calendar.getTime());
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    private void nextDate() {
        this.calendar.add(dateComponents.getImage(this.granularity), 1);
        this.update();
    }

    private void previousDate() {
        this.calendar.add(dateComponents.getImage(this.granularity), -1);
        this.update();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (Utilities.iIn(e.getSource(), this.previousButton, this.nextButton, this.reloadButton)) {
            case 0: {
                this.previousDate();
                break;
            }
            case 1: {
                this.nextDate();
                break;
            }
            case 2: {
                this.update();
            }
        }
    }

    static {
        dateComponents.add(0, 1);
        dateComponents.add(1, 2);
        dateComponents.add(2, 3);
        dateComponents.add(3, 5);
        dateComponents.add(4, 11);
        dateComponents.add(5, 12);
        dateComponents.add(6, 13);
        dateComponents.add(7, 14);
    }

    public static interface DateSwitcherListener {
        public void dateSwitched(DateSwitcher var1, Date var2);
    }
}

