/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.JTreeSearcherUI;
import net.sf.sdedit.util.JTreeFacade;
import net.sf.sdedit.util.tree.BreadthFirstSearch;

public class JTreeSearcher
implements ActionListener {
    private ArrayList<JTree> tree;
    private ArrayList<BreadthFirstSearch> bfs;
    private boolean isCaseSensitive;
    private ArrayList<JTreeFacade> facade;
    private String text;
    private int currentTree;
    private List<ActionListener> actionListeners;
    private int eventId;
    private Map<JTree, JTreeSearcherUI> uis;

    public JTreeSearcher(JTree ... tree) {
        this.tree = new ArrayList<JTree>(Arrays.asList(tree));
        this.facade = new ArrayList();
        this.bfs = new ArrayList();
        for (int i = 0; i < tree.length; ++i) {
            this.facade.add(new JTreeFacade(tree[i]));
            this.bfs.add(new BreadthFirstSearch(tree[i].getModel()));
        }
        this.isCaseSensitive = false;
        this.currentTree = 0;
        this.actionListeners = new LinkedList<ActionListener>();
        this.eventId = 0;
        this.uis = new HashMap<JTree, JTreeSearcherUI>();
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireGoToTree() {
        ActionEvent actionEvent = new ActionEvent(this.currTree(), this.eventId, this.text);
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(actionEvent);
        }
    }

    private JTree currTree() {
        return this.tree.get(this.currentTree);
    }

    private JTreeFacade currFacade() {
        return this.facade.get(this.currentTree);
    }

    public void register(JTreeSearcherUI ui) {
        if (ui.getTree() != null) {
            this.uis.put(ui.getTree(), ui);
        }
    }

    public void deregister(JTreeSearcherUI ui) {
        if (ui.getTree() != null) {
            this.uis.remove(ui.getTree());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTreeSearcherUI ui = (JTreeSearcherUI)e.getSource();
        if (ui.getTree() != null) {
            this.currentTree = this.tree.indexOf(ui.getTree());
        }
        this.text = ui.getSearchText();
        TreePath next = this.findNext();
        if (next != null) {
            this.currFacade().deselectAll();
            TreePath path = next.getParentPath();
            if (path != null) {
                this.currTree().expandPath(path);
            }
            this.currTree().setSelectionPath(next);
            this.currTree().scrollPathToVisible(next);
            this.fireGoToTree();
            JTreeSearcherUI sui = this.uis.get(this.currTree());
            sui.getTextField().requestFocusInWindow();
        }
    }

    public TreePath findNext() {
        for (int state = 0; state < 2; ++state) {
            TreePath next;
            while ((next = this.next()) != null) {
                String str = this.currTree().convertValueToText(next.getLastPathComponent(), false, false, false, 0, false);
                if (!this.matches(str)) continue;
                return next;
            }
            this.restart();
        }
        return null;
    }

    private TreePath next() {
        TreePath next;
        do {
            if ((next = this.bfs.get(this.currentTree).next()) != null) continue;
            ++this.currentTree;
        } while (next == null && this.currentTree < this.tree.size());
        return next;
    }

    public void remove(JTree tree) {
        int i = this.tree.indexOf(tree);
        this.tree.remove(i);
        this.bfs.remove(i);
        this.facade.remove(i);
        if (i >= 0 && i < this.tree.size()) {
            this.currentTree = i;
        } else {
            this.restart();
        }
    }

    public JTree[] getTrees() {
        return this.tree.toArray(new JTree[this.tree.size()]);
    }

    private void restart() {
        for (BreadthFirstSearch b : this.bfs) {
            b.restart();
        }
        this.currentTree = 0;
    }

    private boolean matches(String string) {
        int i = this.isCaseSensitive ? string.indexOf(this.text) : string.toUpperCase().indexOf(this.text.toUpperCase());
        return i >= 0;
    }
}

