/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korio.net.ssl;

import com.soywiz.kds.ByteArrayDeque;
import com.soywiz.korio.net.ssl.SSLProcessor;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J \u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020$H\u0016J \u0010+\u001a\u00020'2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J \u0010,\u001a\u00020'2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020$H\u0002J \u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0018\u001a\n \b*\u0004\u0018\u00010\u00190\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/soywiz/korio/net/ssl/SSLProcessorJvm;", "Lcom/soywiz/korio/net/ssl/SSLProcessor;", "()V", "encryptedC2S", "Lcom/soywiz/kds/ByteArrayDeque;", "encryptedS2C", "engine", "Ljavax/net/ssl/SSLEngine;", "kotlin.jvm.PlatformType", "getEngine", "()Ljavax/net/ssl/SSLEngine;", "setEngine", "(Ljavax/net/ssl/SSLEngine;)V", "isAlive", "", "()Z", "setAlive", "(Z)V", "needInput", "getNeedInput", "needSync", "getNeedSync", "plainC2S", "plainS2C", "sslContext", "Ljavax/net/ssl/SSLContext;", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "status", "", "getStatus", "()Ljava/lang/Object;", "temp1", "", "temp2", "addDecryptedClientData", "", "data", "offset", "", "size", "addEncryptedServerData", "clientClose", "getDecryptedServerData", "getEncryptedClientData", "setEndPoint", "host", "", "port", "sync", "Ljavax/net/ssl/SSLEngineResult$Status;", "input", "output", "wrap", "korio"})
public final class SSLProcessorJvm
implements SSLProcessor {
    private boolean isAlive = true;
    private final SSLContext sslContext;
    private SSLEngine engine;
    @NotNull
    private final ByteArrayDeque encryptedS2C;
    @NotNull
    private final ByteArrayDeque encryptedC2S;
    @NotNull
    private final ByteArrayDeque plainS2C;
    @NotNull
    private final ByteArrayDeque plainC2S;
    @NotNull
    private final byte[] temp1;
    @NotNull
    private byte[] temp2;

    /*
     * WARNING - void declaration
     */
    public SSLProcessorJvm() {
        void $this$engine_u24lambda_u2d1;
        Object it;
        Object object = SSLContext.getInstance("TLS");
        SSLContext sSLContext = object;
        SSLProcessorJvm sSLProcessorJvm = this;
        boolean bl = false;
        ((SSLContext)it).init(null, null, null);
        sSLProcessorJvm.sslContext = object;
        it = object = this.sslContext.createSSLEngine();
        sSLProcessorJvm = this;
        boolean bl2 = false;
        $this$engine_u24lambda_u2d1.setUseClientMode(true);
        sSLProcessorJvm.engine = object;
        this.encryptedS2C = new ByteArrayDeque(0, false, 3, null);
        this.encryptedC2S = new ByteArrayDeque(0, false, 3, null);
        this.plainS2C = new ByteArrayDeque(0, false, 3, null);
        this.plainC2S = new ByteArrayDeque(0, false, 3, null);
        this.temp1 = new byte[this.engine.getSession().getApplicationBufferSize()];
        this.temp2 = new byte[this.engine.getSession().getPacketBufferSize()];
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAlive(boolean bl) {
        this.isAlive = bl;
    }

    public final SSLContext getSslContext() {
        return this.sslContext;
    }

    public final SSLEngine getEngine() {
        return this.engine;
    }

    public final void setEngine(SSLEngine sSLEngine) {
        this.engine = sSLEngine;
    }

    @Override
    public void setEndPoint(@NotNull String host, int port) {
        this.engine = this.sslContext.createSSLEngine(host, port);
        this.engine.setUseClientMode(true);
        this.engine.beginHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEncryptedServerData(@NotNull byte[] data2, int offset, int size2) {
        ByteArrayDeque byteArrayDeque = this.encryptedS2C;
        synchronized (byteArrayDeque) {
            boolean bl = false;
            int n = this.encryptedS2C.write(data2, offset, size2);
        }
    }

    @Override
    public void addDecryptedClientData(@NotNull byte[] data2, int offset, int size2) {
        this.plainC2S.write(data2, offset, size2);
    }

    @Override
    public int getDecryptedServerData(@NotNull byte[] data2, int offset, int size2) {
        this.sync();
        return this.plainS2C.read(data2, offset, size2);
    }

    @Override
    public int getEncryptedClientData(@NotNull byte[] data2, int offset, int size2) {
        this.sync();
        return this.encryptedC2S.read(data2, offset, size2);
    }

    @Override
    public void clientClose() {
        this.engine.closeOutbound();
    }

    @Override
    public boolean getNeedInput() {
        SSLEngineResult.HandshakeStatus status2 = this.engine.getHandshakeStatus();
        return status2 != SSLEngineResult.HandshakeStatus.FINISHED && status2 != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public boolean getNeedSync() {
        SSLEngineResult.HandshakeStatus status2 = this.engine.getHandshakeStatus();
        return status2 == SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    @Override
    @Nullable
    public Object getStatus() {
        return this.engine.getHandshakeStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sync() {
        block8: while (true) {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            SSLEngineResult.HandshakeStatus handshakeStatus2 = handshakeStatus = this.engine.getHandshakeStatus();
            switch (handshakeStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handshakeStatus2.ordinal()]) {
                case -1: {
                    throw new NotImplementedError(null, 1, null);
                }
                case 1: {
                    Runnable task;
                    do {
                        task = this.engine.getDelegatedTask();
                        try {
                            Runnable runnable = task;
                            if (runnable == null) continue;
                            runnable.run();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    } while (task != null);
                    continue block8;
                }
                case 2: 
                case 3: {
                    this.sync(this.plainC2S, this.encryptedC2S, true);
                    this.sync(this.encryptedS2C, this.plainS2C, false);
                    return;
                }
                case 4: {
                    this.sync(this.plainC2S, this.encryptedC2S, true);
                    continue block8;
                }
                default: {
                    if (this.sync(this.encryptedS2C, this.plainS2C, false) == SSLEngineResult.Status.BUFFER_UNDERFLOW) return;
                    continue block8;
                }
            }
            break;
        }
    }

    private final SSLEngineResult.Status sync(ByteArrayDeque input, ByteArrayDeque output, boolean wrap2) {
        SSLEngineResult result2;
        block6: while (true) {
            int temp1Count = ByteArrayDeque.peek$default(input, this.temp1, 0, 0, 6, null);
            ByteBuffer inp = ByteBuffer.wrap(this.temp1, 0, RangesKt.coerceAtLeast(temp1Count, 0));
            ByteBuffer out2 = ByteBuffer.wrap(this.temp2, 0, this.temp2.length);
            result2 = wrap2 ? this.engine.wrap(inp, out2) : this.engine.unwrap(inp, out2);
            input.skip(result2.bytesConsumed());
            output.write(this.temp2, 0, result2.bytesProduced());
            result2.bytesProduced();
            SSLEngineResult.Status status2 = result2.getStatus();
            switch (status2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[status2.ordinal()]) {
                case -1: 
                case 1: {
                    break;
                }
                case 2: {
                    if (!wrap2) break;
                    throw new IllegalStateException("Expected BUFFER_UNDERFLOW in SSL".toString());
                }
                case 3: {
                    this.temp2 = new byte[this.temp2.length * 2];
                    continue block6;
                }
                case 4: {
                    this.setAlive(false);
                }
            }
            if (temp1Count <= 0 || result2.bytesConsumed() == 0 && result2.bytesProduced() == 0) break;
        }
        SSLEngineResult.Status status3 = result2.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)status3, "result.status");
        return status3;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SSLEngineResult.HandshakeStatus.values().length];
            nArray[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 1;
            nArray[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 2;
            nArray[SSLEngineResult.HandshakeStatus.FINISHED.ordinal()] = 3;
            nArray[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SSLEngineResult.Status.values().length];
            nArray[SSLEngineResult.Status.OK.ordinal()] = 1;
            nArray[SSLEngineResult.Status.BUFFER_UNDERFLOW.ordinal()] = 2;
            nArray[SSLEngineResult.Status.BUFFER_OVERFLOW.ordinal()] = 3;
            nArray[SSLEngineResult.Status.CLOSED.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

