/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingResultSet;
import org.apache.tomcat.dbcp.dbcp2.DelegatingStatement;
import org.apache.tomcat.dbcp.dbcp2.SQLExceptionList;

public class DelegatingPreparedStatement
extends DelegatingStatement
implements PreparedStatement {
    public DelegatingPreparedStatement(DelegatingConnection<?> delegatingConnection, PreparedStatement preparedStatement) {
        super(delegatingConnection, preparedStatement);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().addBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().clearParameters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return this.getDelegatePreparedStatement().execute();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().executeLargeUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0L;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return DelegatingResultSet.wrapResultSet(this, this.getDelegatePreparedStatement().executeQuery());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().setLastUsed();
        }
        try {
            return this.getDelegatePreparedStatement().executeUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    private PreparedStatement getDelegatePreparedStatement() {
        return (PreparedStatement)this.getDelegate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().getMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this.getDelegatePreparedStatement().getParameterMetaData();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(n, object, sQLType);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setObject(n, object, sQLType, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setString(n, string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.checkOpen();
        try {
            this.getDelegatePreparedStatement().setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public synchronized String toString() {
        Statement statement = this.getDelegate();
        return statement == null ? "NULL" : statement.toString();
    }

    protected void prepareToReturn() throws SQLException {
        this.setClosedInternal(true);
        this.removeThisTrace(this.getConnectionInternal());
        List<AbandonedTrace> list = this.getTrace();
        if (list != null) {
            ArrayList arrayList = new ArrayList();
            list.forEach(abandonedTrace -> abandonedTrace.close(arrayList::add));
            this.clearTrace();
            if (!arrayList.isEmpty()) {
                throw new SQLExceptionList(arrayList);
            }
        }
        super.passivate();
    }
}

