/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class TimeBucketCounter {
    private static final Log log = LogFactory.getLog(TimeBucketCounter.class);
    private static final StringManager sm = StringManager.getManager(TimeBucketCounter.class);
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
    private final int numBits;
    private final double ratio;
    private ScheduledFuture<?> maintenanceFuture;
    private ScheduledFuture<?> monitorFuture;
    private final ScheduledExecutorService executorService;
    private final long sleeptime;

    public TimeBucketCounter(int n, ScheduledExecutorService scheduledExecutorService) {
        int n2;
        this.executorService = scheduledExecutorService;
        int n3 = n * 1000;
        int n4 = 0;
        int n5 = n2 = TimeBucketCounter.nextPowerOf2(n3);
        while (n5 > 1) {
            n5 = n2 >> ++n4;
        }
        this.numBits = n4;
        this.ratio = TimeBucketCounter.ratioToPowerOf2(n3);
        int n6 = n3 >= 60000 ? 6 : 3;
        this.sleeptime = n3 / n6;
        if (this.sleeptime > 0L) {
            this.monitorFuture = scheduledExecutorService.scheduleWithFixedDelay(new MaintenanceMonitor(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public final int increment(String string2) {
        String string3 = this.getCurrentBucketPrefix() + "-" + string2;
        AtomicInteger atomicInteger = this.map.computeIfAbsent(string3, string -> new AtomicInteger());
        return atomicInteger.incrementAndGet();
    }

    public final int getCurrentBucketPrefix() {
        return (int)(System.currentTimeMillis() >> this.numBits);
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getActualDuration() {
        return (int)Math.pow(2.0, this.getNumBits());
    }

    public double getRatio() {
        return this.ratio;
    }

    static double ratioToPowerOf2(int n) {
        double d = TimeBucketCounter.nextPowerOf2(n);
        return (double)Math.round(1000.0 * d / (double)n) / 1000.0;
    }

    static int nextPowerOf2(int n) {
        int n2 = Integer.highestOneBit(n);
        if (n2 == n) {
            return n;
        }
        return n2 << 1;
    }

    public long getMillisUntilNextBucket() {
        long l = System.currentTimeMillis();
        long l2 = l + (long)Math.pow(2.0, this.numBits) >> this.numBits << this.numBits;
        long l3 = l2 - l;
        return l3;
    }

    public void destroy() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        if (this.maintenanceFuture != null) {
            this.maintenanceFuture.cancel(true);
            this.maintenanceFuture = null;
        }
    }

    private class MaintenanceMonitor
    implements Runnable {
        private MaintenanceMonitor() {
        }

        @Override
        public void run() {
            if (TimeBucketCounter.this.sleeptime > 0L && (TimeBucketCounter.this.maintenanceFuture == null || TimeBucketCounter.this.maintenanceFuture.isDone())) {
                if (TimeBucketCounter.this.maintenanceFuture != null && TimeBucketCounter.this.maintenanceFuture.isDone()) {
                    try {
                        TimeBucketCounter.this.maintenanceFuture.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        log.error((Object)sm.getString("timebucket.maintenance.error"), (Throwable)exception);
                    }
                }
                TimeBucketCounter.this.maintenanceFuture = TimeBucketCounter.this.executorService.scheduleWithFixedDelay(new Maintenance(), TimeBucketCounter.this.sleeptime, TimeBucketCounter.this.sleeptime, TimeUnit.MILLISECONDS);
            }
        }
    }

    private class Maintenance
    implements Runnable {
        private Maintenance() {
        }

        @Override
        public void run() {
            String string = String.valueOf(TimeBucketCounter.this.getCurrentBucketPrefix());
            Set set = TimeBucketCounter.this.map.keySet();
            set.removeIf(string2 -> !string2.startsWith(string));
        }
    }
}

