/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

abstract class OperationValidator {
    private static final OperationValidator FOR_INSTALL = new InstallValidator();
    private static final OperationValidator FOR_INTERNAL_UPDATE = new InternalUpdateValidator();
    private static final OperationValidator FOR_UNINSTALL = new UninstallValidator();
    private static final OperationValidator FOR_UPDATE = new UpdateValidator();
    private static final OperationValidator FOR_ENABLE = new EnableValidator();
    private static final OperationValidator FOR_DISABLE = new DisableValidator();
    private static final OperationValidator FOR_CUSTOM_INSTALL = new CustomInstallValidator();
    private static final OperationValidator FOR_CUSTOM_UNINSTALL = new CustomUninstallValidator();
    private static final Logger LOGGER = Logger.getLogger(OperationValidator.class.getName());
    private static Map<Module, Set<Module>> module2depending = new HashMap<Module, Set<Module>>();
    private static Map<Module, Set<Module>> module2required = new HashMap<Module, Set<Module>>();

    private OperationValidator() {
    }

    public static boolean isValidOperation(OperationContainerImpl.OperationType operationType, UpdateUnit updateUnit, UpdateElement updateElement) {
        if (updateUnit.isPending()) {
            return false;
        }
        boolean bl = false;
        switch (operationType) {
            case INSTALL: {
                bl = FOR_INSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case INTERNAL_UPDATE: {
                bl = FOR_INTERNAL_UPDATE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: {
                bl = FOR_UNINSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                bl = FOR_UPDATE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case ENABLE: {
                bl = FOR_ENABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case DIRECT_DISABLE: 
            case DISABLE: {
                bl = FOR_DISABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case CUSTOM_INSTALL: {
                bl = FOR_CUSTOM_INSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case CUSTOM_UNINSTALL: {
                bl = FOR_CUSTOM_UNINSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bl;
    }

    public static List<UpdateElement> getRequiredElements(OperationContainerImpl.OperationType operationType, UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
        List<UpdateElement> list2 = Collections.emptyList();
        switch (operationType) {
            case INSTALL: {
                list2 = FOR_INSTALL.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: {
                list2 = FOR_UNINSTALL.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case UPDATE: {
                list2 = FOR_UPDATE.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case ENABLE: {
                list2 = FOR_ENABLE.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case DIRECT_DISABLE: 
            case DISABLE: {
                list2 = FOR_DISABLE.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case CUSTOM_INSTALL: {
                list2 = FOR_CUSTOM_INSTALL.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case CUSTOM_UNINSTALL: {
                list2 = FOR_CUSTOM_UNINSTALL.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            case INTERNAL_UPDATE: {
                list2 = FOR_INTERNAL_UPDATE.getRequiredElementsImpl(updateElement, list, collection, collection2);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "== do getRequiredElements for " + (Object)((Object)operationType) + " of " + updateElement + " ==");
            for (UpdateElement updateElement2 : list2) {
                LOGGER.log(Level.FINE, "--> " + updateElement2);
            }
            LOGGER.log(Level.FINE, "== done. ==");
        }
        return list2;
    }

    public static Set<String> getBrokenDependencies(OperationContainerImpl.OperationType operationType, UpdateElement updateElement, List<ModuleInfo> list) {
        HashSet<String> hashSet = new HashSet();
        switch (operationType) {
            case ENABLE: {
                hashSet = Utilities.getBrokenDependenciesInInstalledModules(updateElement);
                break;
            }
            case INSTALL: 
            case INTERNAL_UPDATE: 
            case UPDATE: {
                HashSet<UpdateElement> hashSet2 = new HashSet<UpdateElement>();
                OperationValidator.getRequiredElements(operationType, updateElement, list, hashSet, hashSet2);
                if (hashSet2.isEmpty() || hashSet.isEmpty()) break;
                hashSet = new HashSet();
                OperationValidator.getRequiredElements(operationType, updateElement, list, hashSet, hashSet2);
                break;
            }
            case DIRECT_UNINSTALL: 
            case UNINSTALL: 
            case DIRECT_DISABLE: 
            case DISABLE: 
            case CUSTOM_INSTALL: 
            case CUSTOM_UNINSTALL: {
                hashSet = Utilities.getBrokenDependencies(updateElement, list);
                break;
            }
            default: {
                assert (false) : "Unknown type of operation " + (Object)((Object)operationType);
                break;
            }
        }
        return hashSet;
    }

    abstract boolean isValidOperationImpl(UpdateUnit var1, UpdateElement var2);

    abstract List<UpdateElement> getRequiredElementsImpl(UpdateElement var1, List<ModuleInfo> var2, Collection<String> var3, Collection<UpdateElement> var4);

    public static void clearMaps() {
        module2depending = new HashMap<Module, Set<Module>>();
        module2required = new HashMap<Module, Set<Module>>();
    }

    private static boolean containsElement(UpdateElement updateElement, UpdateUnit updateUnit) {
        return updateUnit.getAvailableUpdates().contains(updateElement);
    }

    private static void addMissingElements(FeatureUpdateElementImpl featureUpdateElementImpl, Collection<String> collection) {
        for (String string : featureUpdateElementImpl.getMissingElements()) {
            collection.add("module " + string);
        }
    }

    private static Set<Module> findRequiredModulesForDeactivate(Set<Module> set, ModuleManager moduleManager) {
        Module module;
        HashSet<Module> hashSet;
        HashSet<Module> hashSet2 = new HashSet<Module>(set);
        boolean bl = true;
        while (bl) {
            bl = false;
            hashSet = new HashSet<Module>(hashSet2);
            for (Module object : hashSet) {
                module = Utilities.findDependingModules(object, moduleManager, module2depending);
                bl |= hashSet2.addAll((Collection<Module>)module);
            }
        }
        hashSet = new HashSet<Module>(hashSet2);
        bl = true;
        while (bl) {
            bl = false;
            HashSet<Module> hashSet3 = new HashSet<Module>(hashSet);
            Iterator iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                if ((Utilities.isKitModule((ModuleInfo)module) || Utilities.isEssentialModule((ModuleInfo)module)) && !hashSet2.contains(module)) continue;
                Set<Module> set2 = Utilities.findRequiredModules(module, moduleManager, module2required);
                bl |= hashSet.addAll(set2);
            }
        }
        return OperationValidator.filterCandidatesToDeactivate(hashSet2, hashSet, moduleManager);
    }

    private static Set<Module> filterCandidatesToDeactivate(Collection<Module> collection, Collection<Module> collection2, ModuleManager moduleManager) {
        Object object3;
        Object object2;
        HashSet<Module> hashSet = new HashSet<Module>();
        HashSet<Module> hashSet2 = new HashSet<Module>(collection2);
        HashSet<Module> hashSet3 = new HashSet<Module>();
        for (UpdateElement object42 : UpdateManagerImpl.getInstance().getInstalledEagers()) {
            object2 = Trampoline.API.impl(object42);
            if (object2 instanceof ModuleUpdateElementImpl) {
                ModuleInfo moduleInfo = ((ModuleUpdateElementImpl)object2).getModuleInfo();
                hashSet3.add(Utilities.toModule(moduleInfo));
                continue;
            }
            if (object2 instanceof FeatureUpdateElementImpl) {
                List<ModuleInfo> list = ((FeatureUpdateElementImpl)object2).getModuleInfos();
                for (Object object3 : list) {
                    hashSet3.add(Utilities.toModule((ModuleInfo)object3));
                }
                continue;
            }
            assert (false) : object42 + " is instanceof neither ModuleUpdateElementImpl nor FeatureUpdateElementImpl";
        }
        hashSet2.addAll(hashSet3);
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        for (Module module : collection2) {
            if ((Utilities.isKitModule((ModuleInfo)module) || Utilities.isEssentialModule((ModuleInfo)module)) && !collection.contains(module)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " is KIT_MODULE and won't be deactivated now not even " + Utilities.findRequiredModules(module, moduleManager, module2required));
                }
                hashSet4.add(module);
                continue;
            }
            if (hashSet4.contains(module)) {
                LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " was investigated already and won't be deactivated now.");
                continue;
            }
            Module module2 = Utilities.findDependingModules(module, moduleManager, module2depending);
            if (!hashSet2.containsAll((Collection<?>)module2)) {
                hashSet4.add(module);
                object3 = Utilities.findRequiredModules(module, moduleManager, module2required);
                hashSet4.addAll(object3);
                LOGGER.log(Level.FINE, "The module " + module.getCodeNameBase() + " is shared and cannot be deactivated now.");
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                HashSet hashSet6 = new HashSet(module2);
                hashSet6.removeAll(hashSet2);
                LOGGER.log(Level.FINER, "On " + module.getCodeNameBase() + " depending modules outside of set now deactivating modules: " + hashSet6);
                LOGGER.log(Level.FINER, "With " + module.getCodeNameBase() + " must remain also these required modules: " + object3);
                continue;
            }
            hashSet.add(module);
            object3 = new HashSet(module2);
            object3.retainAll(hashSet3);
            if (object3.isEmpty()) continue;
            hashSet5.addAll(object3);
        }
        hashSet.removeAll(hashSet3);
        LOGGER.log(Level.FINE, "Possible affected eagers are " + hashSet5);
        hashSet.removeAll(OperationValidator.findDeepRequired(hashSet4, moduleManager));
        object2 = new HashSet<Object>();
        for (Module module2 : hashSet5) {
            object3 = Utilities.findRequiredModules(module2, moduleManager, module2depending);
            if (object3.removeAll(hashSet)) continue;
            object2.add(module2);
        }
        hashSet5.removeAll((Collection<?>)object2);
        hashSet.addAll(hashSet5);
        LOGGER.log(Level.FINE, "Real affected eagers are " + hashSet5);
        return hashSet;
    }

    private static Set<Module> findDeepRequired(Set<Module> set, ModuleManager moduleManager) {
        HashSet<Module> hashSet = new HashSet<Module>(set);
        boolean bl = true;
        while (bl) {
            HashSet<Module> hashSet2 = new HashSet<Module>(hashSet);
            bl = false;
            for (Module module : hashSet2) {
                Set<Module> set2 = Utilities.findRequiredModules(module, moduleManager, module2required);
                bl |= hashSet.addAll(set2);
            }
        }
        return hashSet;
    }

    private static class CustomUninstallValidator
    extends OperationValidator {
        private CustomUninstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            boolean bl = false;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            assert (updateElementImpl != null);
            if (updateElementImpl != null && updateElementImpl instanceof NativeComponentUpdateElementImpl) {
                NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl = (NativeComponentUpdateElementImpl)updateElementImpl;
                bl = nativeComponentUpdateElementImpl.getNativeItem().getUpdateItemDeploymentImpl().getCustomUninstaller() != null;
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            LOGGER.log(Level.INFO, "CustomUninstallValidator doesn't care about required elements.");
            return Collections.emptyList();
        }
    }

    private static class CustomInstallValidator
    extends OperationValidator {
        private CustomInstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl;
            boolean bl = false;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            assert (updateElementImpl != null);
            if (updateElementImpl != null && updateElementImpl instanceof NativeComponentUpdateElementImpl && (nativeComponentUpdateElementImpl = (NativeComponentUpdateElementImpl)updateElementImpl).getInstallInfo().getCustomInstaller() != null) {
                bl = OperationValidator.containsElement(updateElement, updateUnit);
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            LOGGER.log(Level.INFO, "CustomInstallValidator doesn't care about required elements.");
            return Collections.emptyList();
        }
    }

    private static class DisableValidator
    extends OperationValidator {
        private DisableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = Utilities.canDisable(module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= Utilities.canDisable(module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object2 : list) {
                Module bl = Utilities.toModule(object2);
                if (Utilities.canDisable(bl)) {
                    linkedHashSet.add(bl);
                }
                if (moduleManager != null) continue;
                moduleManager = bl.getManager();
            }
            if (moduleManager == null) {
                LOGGER.log(Level.WARNING, "No modules can be disabled when disabling UpdateElement " + updateElement);
                return Collections.emptyList();
            }
            Set set = OperationValidator.findRequiredModulesForDeactivate(linkedHashSet, moduleManager);
            List list2 = moduleManager.simulateDisable(linkedHashSet);
            boolean bl = set.addAll(list2);
            if (LOGGER.isLoggable(Level.FINE) && bl) {
                list2.removeAll(OperationValidator.filterCandidatesToDeactivate(linkedHashSet, set, moduleManager));
                LOGGER.log(Level.FINE, "requestedToDisable was enlarged by " + list2);
            }
            HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                UpdateUnit updateUnit;
                Module module = (Module)iterator.next();
                if (linkedHashSet.contains(module) || !Utilities.canDisable(module) || (updateUnit = Utilities.toUpdateUnit(module)) == null) continue;
                hashSet.add(updateUnit.getInstalled());
            }
            return new ArrayList<UpdateElement>(hashSet);
        }
    }

    private static class EnableValidator
    extends OperationValidator {
        private EnableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = Utilities.canEnable(module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= Utilities.canEnable(module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        private List<Module> getModulesToEnable(ModuleManager moduleManager, Set<Module> set) {
            List<Object> list = new ArrayList<Module>();
            boolean bl = true;
            while (bl) {
                bl = false;
                try {
                    list = moduleManager.simulateEnable(set);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.INFO, "Cannot enable all modules " + set, illegalArgumentException);
                    LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>(set);
                    for (Module module : linkedHashSet) {
                        if (Utilities.canEnable(module)) continue;
                        set.remove(module);
                        bl = true;
                    }
                    assert (bl) : "Can`t enable modules " + set;
                }
            }
            return list;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            Object object;
            UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>(list);
            arrayList.addAll(updateElementImpl.getModuleInfos(true));
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object32 : arrayList) {
                object = Utilities.toModule(object32);
                if (Utilities.canEnable((Module)object)) {
                    linkedHashSet.add((Module)object);
                }
                if (moduleManager != null) continue;
                moduleManager = object.getManager();
            }
            ArrayList arrayList2 = new ArrayList();
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            if (moduleManager != null) {
                object = this.getModulesToEnable(moduleManager, linkedHashSet);
                Iterator<Object> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Module module = (Module)iterator.next();
                    if (linkedHashSet.contains(module) || !Utilities.canEnable(module) || Utilities.toUpdateUnit(module).getInstalled() == null) continue;
                    arrayList2.add(Utilities.toUpdateUnit(module).getInstalled());
                }
            }
            if (updateElementImpl.getUpdateUnit() != null && updateElementImpl.getType() == UpdateManager.TYPE.FEATURE) {
                Object object2;
                object = (FeatureUpdateElementImpl)updateElementImpl;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : ((FeatureUpdateElementImpl)object).getContainedModuleElements()) {
                    object2 = Utilities.findRequiredUpdateElements(moduleUpdateElementImpl.getUpdateElement(), list, hashSet, true, collection2);
                    if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() != null) continue;
                    arrayList2.add(moduleUpdateElementImpl.getUpdateElement());
                    arrayList2.addAll(object2);
                }
                OperationValidator.addMissingElements((FeatureUpdateElementImpl)object, collection);
                for (UpdateElement updateElement2 : updateElementImpl.getUpdateUnit().getAvailableUpdates()) {
                    object2 = Trampoline.API.impl(updateElement2);
                    if (((UpdateElementImpl)object2).getType() != UpdateManager.TYPE.FEATURE) continue;
                    FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)object2;
                    for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                        if (moduleUpdateElementImpl.getUpdateUnit().getInstalled() != null) continue;
                        arrayList2.add(moduleUpdateElementImpl.getUpdateElement());
                        arrayList2.addAll(Utilities.findRequiredUpdateElements(moduleUpdateElementImpl.getUpdateElement(), list, hashSet, true, collection2));
                    }
                    OperationValidator.addMissingElements(featureUpdateElementImpl, collection);
                }
                for (FeatureUpdateElementImpl featureUpdateElementImpl : ((FeatureUpdateElementImpl)object).getDependingFeatures()) {
                    arrayList2.addAll(this.getRequiredElementsImpl(featureUpdateElementImpl.getUpdateElement(), featureUpdateElementImpl.getModuleInfos(), collection, collection2));
                }
                for (Dependency dependency : hashSet) {
                    if (dependency.getType() != 1) continue;
                    collection.add(dependency.toString());
                }
            }
            return arrayList2;
        }
    }

    private static class UpdateValidator
    extends OperationValidator {
        private UpdateValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && OperationValidator.containsElement(updateElement, updateUnit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            LinkedList<UpdateElement> linkedList = new LinkedList<UpdateElement>(Utilities.findRequiredUpdateElements(updateElement, list, hashSet, true, collection2));
            if (collection != null) {
                for (Dependency dependency : hashSet) {
                    collection.add(dependency.toString());
                }
            }
            return linkedList;
        }
    }

    private static class UninstallValidator
    extends OperationValidator {
        private UninstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() != null && this.isValidOperationImpl(Trampoline.API.impl(updateElement));
        }

        private boolean isValidOperationImpl(UpdateElementImpl updateElementImpl) {
            boolean bl = false;
            switch (updateElementImpl.getType()) {
                case KIT_MODULE: 
                case MODULE: {
                    Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                    bl = ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module);
                    break;
                }
                case STANDALONE_MODULE: 
                case FEATURE: {
                    for (ModuleInfo moduleInfo : ((FeatureUpdateElementImpl)updateElementImpl).getModuleInfos()) {
                        Module module = Utilities.toModule(moduleInfo);
                        bl |= ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module);
                    }
                    break;
                }
                case CUSTOM_HANDLED_COMPONENT: {
                    LOGGER.log(Level.INFO, "CUSTOM_HANDLED_COMPONENT doesn't support custom uninstaller yet.");
                    bl = false;
                    break;
                }
                default: {
                    assert (false) : "Not supported for impl " + updateElementImpl;
                    break;
                }
            }
            return bl;
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            ModuleManager moduleManager = null;
            LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
            for (ModuleInfo object2 : list) {
                Module module = Utilities.toModule(object2);
                if (module == null) continue;
                if (!Utilities.isEssentialModule((ModuleInfo)module)) {
                    linkedHashSet.add(module);
                }
                if (moduleManager != null) continue;
                moduleManager = module.getManager();
            }
            HashSet hashSet = new HashSet();
            if (moduleManager != null) {
                Set set = OperationValidator.findRequiredModulesForDeactivate(linkedHashSet, moduleManager);
                set.removeAll(linkedHashSet);
                for (Module module : set) {
                    if (Utilities.isEssentialModule((ModuleInfo)module)) {
                        LOGGER.log(Level.WARNING, "Essential module cannot be planned for uninstall but " + module);
                        continue;
                    }
                    if (!ModuleDeleterImpl.getInstance().canDelete((ModuleInfo)module)) {
                        LOGGER.log(Level.WARNING, "The module " + module + " cannot be planned for uninstall because is read-only.");
                        continue;
                    }
                    UpdateUnit updateUnit = Utilities.toUpdateUnit(module);
                    if (updateUnit == null) continue;
                    hashSet.add(updateUnit.getInstalled());
                }
            }
            return new ArrayList<UpdateElement>(hashSet);
        }
    }

    private static class InstallValidator
    extends OperationValidator {
        private InstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateUnit.getInstalled() == null && OperationValidator.containsElement(updateElement, updateUnit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement updateElement, List<ModuleInfo> list, Collection<String> collection, Collection<UpdateElement> collection2) {
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            LinkedList<UpdateElement> linkedList = new LinkedList<UpdateElement>(Utilities.findRequiredUpdateElements(updateElement, list, hashSet, false, collection2));
            if (collection != null) {
                for (Dependency dependency : hashSet) {
                    collection.add(dependency.toString());
                }
            }
            return linkedList;
        }
    }

    private static class InternalUpdateValidator
    extends UpdateValidator {
        private InternalUpdateValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            return updateElement.equals(updateUnit.getInstalled()) || OperationValidator.containsElement(updateElement, updateUnit);
        }
    }
}

