/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;

public class LocalObjectNode
extends InstanceNode {
    private final String localObjectName;

    public LocalObjectNode(Instance instance) {
        this(instance, Bundle.LocalObjectNode_LocalObject());
    }

    public LocalObjectNode(Instance instance, String localObjectName) {
        super(instance);
        this.localObjectName = localObjectName;
    }

    public String getLocalObjectName() {
        return this.localObjectName;
    }

    public static class Unknown
    extends LocalObjectNode {
        public Unknown() {
            super(null, Bundle.LocalObjectNode_UnknownLocalObject());
        }

        public String getName(Heap heap) {
            return Bundle.LocalObjectNode_Unknown();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.OWN_SIZE) {
                return DataType.OWN_SIZE.getNoValue();
            }
            if (type == DataType.RETAINED_SIZE) {
                return DataType.RETAINED_SIZE.getNoValue();
            }
            if (type == DataType.INSTANCE) {
                return DataType.INSTANCE.getNoValue();
            }
            if (type == DataType.CLASS) {
                return DataType.CLASS.getNoValue();
            }
            if (type == DataType.LOGICAL_VALUE) {
                return DataType.LOGICAL_VALUE.getNoValue();
            }
            return super.getValue(type, heap);
        }
    }
}

