/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.model;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.java.InstancesWrapper;
import org.graalvm.visualvm.heapviewer.model.Bundle;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.util.RequestProcessor;

public class DataType<T> {
    public static final String NO_VALUE_STRING = new String();
    public static final String UNSUPPORTED_VALUE_STRING = new String();
    public static final String NOT_AVAILABLE_VALUE_STRING = new String();
    public static final Integer NO_VALUE_INTEGER = new Integer(-2147483638);
    public static final Integer UNSUPPORTED_VALUE_INTEGER = new Integer(-2147483637);
    public static final Integer NOT_AVAILABLE_VALUE_INTEGER = new Integer(-2147483636);
    public static final Long NO_VALUE_LONG = new Long(-9223372036854775798L);
    public static final Long UNSUPPORTED_VALUE_LONG = new Long(-9223372036854775797L);
    public static final Long NOT_AVAILABLE_VALUE_LONG = new Long(-9223372036854775796L);
    public static final DataType<String> NAME = new DataType<String>(String.class, NO_VALUE_STRING, UNSUPPORTED_VALUE_STRING);
    public static final DataType<Integer> COUNT = new DataType<Integer>(Integer.class, NO_VALUE_INTEGER, UNSUPPORTED_VALUE_INTEGER);
    public static final DataType<Integer> GCROOTS = new DataType<Integer>(Integer.class, NO_VALUE_INTEGER, UNSUPPORTED_VALUE_INTEGER);
    public static final DataType<Long> OWN_SIZE = new DataType<Long>(Long.class, NO_VALUE_LONG, UNSUPPORTED_VALUE_LONG);
    public static final DataType<Long> RETAINED_SIZE = new RetainedSize();
    public static final DataType<String> LOGICAL_VALUE = new DataType<String>(String.class, NO_VALUE_STRING, UNSUPPORTED_VALUE_STRING);
    public static final DataType<Long> OBJECT_ID = new DataType<Long>(Long.class, NO_VALUE_LONG, UNSUPPORTED_VALUE_LONG);
    public static final DataType<JavaClass> CLASS = new DataType<Object>(JavaClass.class, null, null);
    public static final DataType<Instance> INSTANCE = new DataType<Object>(Instance.class, null, null);
    public static final DataType<InstancesWrapper> INSTANCES_WRAPPER = new DataType<Object>(InstancesWrapper.class, null, null);
    public static final DataType<HeapViewerNode> LOOP = new DataType<Object>(HeapViewerNode.class, null, null);
    public static final DataType<HeapViewerNode> LOOP_ORIGIN = new DataType<Object>(HeapViewerNode.class, null, null);
    static final Set<DataType> DEFAULT_TYPES = new HashSet<DataType>(Arrays.asList(NAME, COUNT, OWN_SIZE, RETAINED_SIZE, LOGICAL_VALUE, OBJECT_ID, CLASS, INSTANCE, INSTANCES_WRAPPER, LOOP, LOOP_ORIGIN));
    private final Class<T> type;
    private final T noValue;
    private final T unsupportedValue;

    public DataType(Class<T> type, T noValue, T unsupportedValue) {
        this.type = type;
        this.noValue = noValue;
        this.unsupportedValue = unsupportedValue;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getNoValue() {
        return this.noValue;
    }

    public T getUnsupportedValue() {
        return this.unsupportedValue;
    }

    public boolean valuesAvailable(Heap heap) {
        return true;
    }

    public boolean computeValues(Heap heap, Runnable whenComputed) {
        return true;
    }

    public void computeValuesImmediately(Heap heap) {
    }

    public void notifyWhenAvailable(Heap heap, Runnable target) {
    }

    public T getNotAvailableValue() {
        return null;
    }

    private static class RetainedSize
    extends Lazy<Long> {
        private volatile boolean computing;

        private RetainedSize() {
            super(Long.class, NO_VALUE_LONG, UNSUPPORTED_VALUE_LONG, NOT_AVAILABLE_VALUE_LONG);
        }

        @Override
        public boolean valuesAvailable(Heap heap) {
            return heap.isRetainedSizeComputed() && heap.isRetainedSizeByClassComputed();
        }

        @Override
        public boolean computeValues(final Heap heap, final Runnable whenComputed) {
            if (this.computing) {
                return true;
            }
            if (!ProfilerDialogs.displayConfirmationDNSA((String)Bundle.RetainedSize_ComputeRetainedMsg(), (String)Bundle.RetainedSize_ComputeRetainedCaption(), null, (String)"HeapFragmentWalker.computeRetainedSizes", (boolean)false)) {
                return false;
            }
            this.computing = true;
            new RequestProcessor("Retained Sizes Computer").post(new Runnable(){

                @Override
                public void run() {
                    this.computeValuesImmediately(heap, whenComputed);
                }
            });
            return true;
        }

        @Override
        public void computeValuesImmediately(Heap heap) {
            if (this.computing) {
                return;
            }
            this.computing = true;
            this.computeValuesImmediately(heap, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeValuesImmediately(final Heap heap, final Runnable whenComputed) {
            try {
                HeapOperations.initializeRetainedSizes(heap);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.valuesComputed(heap, whenComputed);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.computing = false;
            }
        }
    }

    public static abstract class ValueProvider {
        public abstract boolean supportsView(Heap var1, String var2);

        public abstract <T> T getValue(HeapViewerNode var1, DataType<T> var2, Heap var3);
    }

    public static abstract class Lazy<T>
    extends DataType<T> {
        private final T notAvailableValue;
        private Map<Heap, Set<WeakReference<Runnable>>> notifyTargets;

        public Lazy(Class<T> type, T noValue, T unsupportedValue, T notAvailableValue) {
            super(type, noValue, unsupportedValue);
            this.notAvailableValue = notAvailableValue;
        }

        @Override
        public abstract boolean valuesAvailable(Heap var1);

        @Override
        public abstract boolean computeValues(Heap var1, Runnable var2);

        @Override
        public abstract void computeValuesImmediately(Heap var1);

        protected void valuesComputed(Heap heap, Runnable whenComputed) {
            Set<WeakReference<Runnable>> targetRefs;
            if (whenComputed != null) {
                whenComputed.run();
            }
            if (this.notifyTargets != null && (targetRefs = this.notifyTargets.remove(heap)) != null) {
                for (WeakReference<Runnable> targetRef : targetRefs) {
                    Runnable target = (Runnable)targetRef.get();
                    if (target == null) continue;
                    target.run();
                }
                targetRefs.clear();
            }
        }

        @Override
        public void notifyWhenAvailable(Heap heap, Runnable target) {
            Set<WeakReference<Runnable>> targetRefs;
            if (this.notifyTargets == null) {
                this.notifyTargets = new WeakHashMap<Heap, Set<WeakReference<Runnable>>>();
            }
            if ((targetRefs = this.notifyTargets.get(heap)) == null) {
                targetRefs = new HashSet<WeakReference<Runnable>>();
                this.notifyTargets.put(heap, targetRefs);
            }
            targetRefs.add(new WeakReference<Runnable>(target));
        }

        @Override
        public T getNotAvailableValue() {
            return this.notAvailableValue;
        }
    }
}

