/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils.hname.win;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.NativeException;
import org.netbeans.core.network.utils.hname.win.Winsock2Lib;

public class HostnameUtilsWin {
    private static final Logger LOGGER = Logger.getLogger(HostnameUtilsWin.class.getName());

    public static String getComputerName() throws NativeException {
        try {
            return Kernel32Util.getComputerName();
        }
        catch (Win32Exception win32Exception) {
            LOGGER.log(Level.FINE, "Kernel32.GetComputerName error : {0}", win32Exception.getHR().intValue());
            String string = System.getenv("COMPUTERNAME");
            if (string != null) {
                return string;
            }
            throw new NativeException(win32Exception.getHR().intValue(), "error calling 'GetComputerName()' function");
        }
    }

    public static String getHostName(boolean bl) throws NativeException {
        byte[] byArray = new byte[256];
        int n = Winsock2Lib.INSTANCE.gethostname(byArray, byArray.length);
        if (n == 0) {
            String string = Native.toString((byte[])byArray);
            if (bl) {
                return IpAddressUtils.removeDomain(string);
            }
            return string;
        }
        throw new NativeException(n, "error calling 'gethostname()' function");
    }
}

