/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.console.r.Bundle;
import org.graalvm.visualvm.heapviewer.console.r.RQueries;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class CustomRQueries {
    private static final String SAVED_R_QUERIES_FILENAME = "rqueries";
    private static final String PROP_QUERY_NAME_KEY = "r-query-name";
    private static final String PROP_QUERY_DESCR_KEY = "r-query-descr";
    private static final String PROP_QUERY_SCRIPT_KEY = "r-query-script";
    private static CustomRQueries INSTANCE;
    private List<RQueries.Query> customQueries;

    public static synchronized CustomRQueries instance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomRQueries();
        }
        return INSTANCE;
    }

    public synchronized boolean isEmpty() {
        return this.customQueries.isEmpty();
    }

    public synchronized void add(RQueries.Query query) {
        this.customQueries.add(0, query);
        this.save();
    }

    public synchronized void save(RQueries.Query query) {
        for (RQueries.Query q : this.customQueries) {
            if (!q.getName().equals(query.getName())) continue;
            q.setScript(query.getScript());
            this.save();
            break;
        }
    }

    public synchronized void set(List<RQueries.Query> queries) {
        this.customQueries.clear();
        this.customQueries.addAll(queries);
        this.save();
    }

    public synchronized List<RQueries.Query> list() {
        ArrayList<RQueries.Query> list = new ArrayList<RQueries.Query>();
        for (RQueries.Query query : this.customQueries) {
            list.add(new RQueries.Query(query.getScript(), query.getName(), query.getDescription()));
        }
        return list;
    }

    private void save() {
        new RequestProcessor("R Scripts Saver").post(new Runnable(){

            @Override
            public void run() {
                try {
                    Properties p = CustomRQueries.listToProperties(CustomRQueries.this.list());
                    ProfilerStorage.saveGlobalProperties((Properties)p, (String)CustomRQueries.SAVED_R_QUERIES_FILENAME);
                }
                catch (Exception e) {
                    ProfilerDialogs.displayError((String)Bundle.CustomRQueries_SaveFailed());
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private static List<RQueries.Query> propertiesToList(List<RQueries.Query> queries, Properties properties) {
        int i = 0;
        while (properties.containsKey("r-query-name-" + i)) {
            String name = properties.getProperty("r-query-name-" + i);
            String description = properties.getProperty("r-query-descr-" + i, null);
            String script = properties.getProperty("r-query-script-" + i, "");
            if (name != null && script != null) {
                queries.add(new RQueries.Query(script, name, description));
            }
            ++i;
        }
        return queries;
    }

    private static Properties listToProperties(List<RQueries.Query> queries) {
        Properties properties = new Properties();
        int i = 0;
        for (RQueries.Query query : queries) {
            properties.put("r-query-name-" + i, query.getName().trim());
            properties.put("r-query-script-" + i, query.getScript().trim());
            String descr = query.getDescription();
            if (descr != null) {
                properties.put("r-query-descr-" + i, descr);
            }
            ++i;
        }
        return properties;
    }

    private CustomRQueries() {
        assert (!SwingUtilities.isEventDispatchThread());
        this.customQueries = new ArrayList<RQueries.Query>();
        try {
            Properties p = new Properties();
            ProfilerStorage.loadGlobalProperties((Properties)p, (String)SAVED_R_QUERIES_FILENAME);
            CustomRQueries.propertiesToList(this.customQueries, p);
        }
        catch (Exception e) {
            ProfilerDialogs.displayError((String)Bundle.CustomRQueries_LoadFailed());
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

