/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleThreadsProvider;
import org.graalvm.visualvm.heapviewer.truffle.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HTMLView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;

public class TruffleThreadsView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "threads";
    private static final String OBJECTS_ID = "_objects";
    private static final String HTML_ID = "_html";
    private JComponent component;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar pluginsToolbar;
    private final HTMLView htmlView;
    private final PluggableTreeTableView objectsView;

    public TruffleThreadsView(TruffleLanguage language, HeapContext context, HeapViewerActions actions) {
        super(TruffleThreadsView.idFromLanguage(language), Bundle.TruffleThreadsView_Name(), Bundle.TruffleThreadsView_Description(), TruffleThreadsView.iconFromLanguage(language), 300);
        Heap heap = context.getFragment().getHeap();
        final TruffleThreadsProvider threadsProvider = new TruffleThreadsProvider(language);
        this.objectsView = new PluggableTreeTableView(this.getID() + OBJECTS_ID, context, actions, TreeTableViewColumn.instances((Heap)heap, (boolean)false)){

            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                return threadsProvider.getThreadsObjects(root, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
            }

            protected void childrenChanged() {
                HeapViewerNode[] children;
                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                    this.expandNode(child);
                }
            }
        };
        this.objectsView.setViewName(this.getName());
        this.htmlView = new HTMLView(this.getID() + HTML_ID, context, actions, "<br>&nbsp;&nbsp;" + Bundle.TruffleThreadsView_ComputingThreads()){

            protected String computeData(HeapContext context, String viewID) {
                return threadsProvider.getThreadsHTML(context);
            }

            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                return threadsProvider.getNodeForURL(url, context);
            }
        };
    }

    static String idFromLanguage(TruffleLanguage<?, ?, ?> language) {
        return language.getID() + "_" + FEATURE_ID;
    }

    static Icon iconFromLanguage(TruffleLanguage<?, ?, ?> language) {
        return language.createLanguageIcon(Icons.getIcon((String)"ProfilerIcons.WindowThreads"));
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.TruffleThreadsView_Results()));
        this.toolbar.addSpace(3);
        ButtonGroup resultsBG = new ButtonGroup();
        JToggleButton rObjects = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots"), true){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (TruffleThreadsView.this.component != null) {
                        ((CardLayout)TruffleThreadsView.this.component.getLayout()).first(TruffleThreadsView.this.component);
                    }
                    if (TruffleThreadsView.this.pluginsToolbar != null) {
                        TruffleThreadsView.this.pluginsToolbar.getComponent().setVisible(true);
                    }
                }
            }
        };
        rObjects.putClientProperty("JButton.buttonType", "segmented");
        rObjects.putClientProperty("JButton.segmentPosition", "first");
        rObjects.setToolTipText(Bundle.TruffleThreadsView_ViewObjects());
        resultsBG.add(rObjects);
        this.toolbar.add((Component)rObjects);
        JToggleButton rHTML = new JToggleButton(Icons.getIcon((String)"HeapWalkerIcons.Properties")){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (TruffleThreadsView.this.component != null) {
                        ((CardLayout)TruffleThreadsView.this.component.getLayout()).last(TruffleThreadsView.this.component);
                    }
                    if (TruffleThreadsView.this.pluginsToolbar != null) {
                        TruffleThreadsView.this.pluginsToolbar.getComponent().setVisible(false);
                    }
                }
            }
        };
        rHTML.putClientProperty("JButton.buttonType", "segmented");
        rHTML.putClientProperty("JButton.segmentPosition", "last");
        rHTML.setToolTipText(Bundle.TruffleThreadsView_ViewHtml());
        resultsBG.add(rHTML);
        this.toolbar.add((Component)rHTML);
        if (this.objectsView.hasPlugins()) {
            this.pluginsToolbar = ProfilerToolbar.create((boolean)false);
            this.pluginsToolbar.addSpace(8);
            this.pluginsToolbar.add((Component)new GrayLabel(Bundle.TruffleThreadsView_Details()));
            this.pluginsToolbar.addSpace(2);
            this.pluginsToolbar.add(this.objectsView.getToolbar());
            this.toolbar.add(this.pluginsToolbar);
        }
        this.component = new JPanel(new CardLayout());
        this.component.add(this.objectsView.getComponent());
        this.component.add(this.htmlView.getComponent());
    }
}

