/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server.system;

import java.lang.management.ManagementFactory;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class Timers {
    private static MBeanServerConnection conn;
    private static final String PROCESS_CPU_TIME_ATTR = "ProcessCpuTime";
    private static final String PROCESS_CPU_TIME_NS_ATTR = "ProcessCpuTimeByNS";
    private static final String PROCESSING_CAPACITY_ATTR = "ProcessingCapacity";
    private static ObjectName osName;
    private static double processingCapacity;
    private static int processorsCount;
    private static boolean processCPUTimeAttribute;
    private static boolean initialized;
    private static String processCpuTimeAttr;

    public static long getCurrentTimeInCounts() {
        return System.nanoTime();
    }

    public static long getNoOfCountsInSecond() {
        return 1000000000L;
    }

    public static native long getThreadCPUTimeInNanos();

    public static long getProcessCpuTime() {
        Timers.initializeProcessCPUTime();
        if (processCPUTimeAttribute) {
            try {
                Long cputime = (Long)conn.getAttribute(osName, processCpuTimeAttr);
                return (long)((double)cputime.longValue() / processingCapacity / (double)processorsCount);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return -1L;
    }

    public static native void enableMicrostateAccounting(boolean var0);

    public static void initialize() {
        ManagementFactory.getThreadMXBean();
        Timers.getThreadCPUTimeInNanos();
        Timers.initializeProcessCPUTime();
    }

    private static void initializeProcessCPUTime() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            conn = ManagementFactory.getPlatformMBeanServer();
            osName = new ObjectName("java.lang:type=OperatingSystem");
            MBeanAttributeInfo[] attrs = conn.getMBeanInfo(osName).getAttributes();
            processorsCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            for (int i = 0; i < attrs.length; ++i) {
                String name = attrs[i].getName();
                if (PROCESS_CPU_TIME_ATTR.equals(name) && !processCPUTimeAttribute) {
                    processCPUTimeAttribute = Boolean.TRUE;
                    processCpuTimeAttr = name;
                }
                if (PROCESS_CPU_TIME_NS_ATTR.equals(name)) {
                    processCPUTimeAttribute = Boolean.TRUE;
                    processCpuTimeAttr = name;
                }
                if (!PROCESSING_CAPACITY_ATTR.equals(name)) continue;
                Number mul = (Number)conn.getAttribute(osName, PROCESSING_CAPACITY_ATTR);
                processingCapacity = (double)mul.longValue() / 100.0 / (double)processorsCount;
            }
        }
        catch (JMRuntimeException ex) {
            System.err.println(ex.getLocalizedMessage());
            initialized = false;
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static native void osSleep(int var0);
}

