/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.tools.jvmstat;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.model.Model;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.MonitoredValue;
import org.openide.util.NbBundle;

public abstract class JvmJvmstatModel
extends Model {
    private static final Logger LOGGER = Logger.getLogger(JvmJvmstatModel.class.getName());
    private static final String JAR_SUFFIX = ".jar";
    private static final Pattern MODULE_MAIN_CLASS_PATTERN = Pattern.compile("^(\\w+\\.)*\\w+/(\\w+\\.)+\\w+$");
    protected Application application;
    protected JvmstatModel jvmstat;
    protected MonitoredValue loadedClasses;
    protected MonitoredValue sharedLoadedClasses;
    protected MonitoredValue sharedUnloadedClasses;
    protected MonitoredValue unloadedClasses;
    protected MonitoredValue threadsDaemon;
    protected MonitoredValue threadsLive;
    protected MonitoredValue threadsLivePeak;
    protected MonitoredValue threadsStarted;
    protected MonitoredValue applicationTime;
    protected MonitoredValue upTime;
    protected long osFrequency;
    protected String[] genName;
    protected List<MonitoredValue> genCapacity;
    protected List<MonitoredValue> genUsed;
    protected long[] genMaxCapacity;

    protected JvmJvmstatModel(Application app, JvmstatModel stat) {
        this.application = app;
        this.jvmstat = stat;
        this.genName = new String[2];
        this.genName[0] = NbBundle.getMessage(JvmJvmstatModel.class, (String)"LBL_Heap");
        this.genName[1] = NbBundle.getMessage(JvmJvmstatModel.class, (String)"LBL_PermGen");
    }

    public String getCommandLine() {
        return this.jvmstat.findByName("sun.rt.javaCommand");
    }

    public String getJvmArgs() {
        return this.jvmstat.findByName("java.rt.vmArgs");
    }

    public String getJvmFlags() {
        return this.jvmstat.findByName("java.rt.vmFlags");
    }

    public String getJavaHome() {
        return this.jvmstat.findByName("java.property.java.home");
    }

    public String getVmInfo() {
        return this.jvmstat.findByName("java.property.java.vm.info");
    }

    public String getVmName() {
        return this.jvmstat.findByName("java.property.java.vm.name");
    }

    public String getVmVersion() {
        return this.jvmstat.findByName("java.property.java.vm.version");
    }

    public String getJavaVersion() {
        return this.jvmstat.findByName("java.property.java.version");
    }

    public String getVmVendor() {
        return this.jvmstat.findByName("java.property.java.vm.vendor");
    }

    public String getClassPath() {
        return this.jvmstat.findByName("java.property.java.class.path");
    }

    public boolean isAttachable() {
        String jvmCapabilities = this.jvmstat.findByName("sun.rt.jvmCapabilities");
        if (jvmCapabilities == null) {
            return false;
        }
        return jvmCapabilities.charAt(0) == '1';
    }

    public String getMainArgs() {
        String arg0;
        int firstSpace;
        String commandLine = this.getCommandLine();
        if (commandLine != null && (firstSpace = (arg0 = this.getFirstArgument()).length()) < commandLine.length()) {
            return commandLine.substring(firstSpace);
        }
        return null;
    }

    public String getMainClass() {
        File jarFile;
        String mainClassName = this.getFirstArgument();
        if (mainClassName == null) {
            return null;
        }
        if (this.application.isLocalApplication() && (jarFile = new File(mainClassName)).exists()) {
            try (JarFile jf = new JarFile(jarFile);){
                mainClassName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                assert (mainClassName != null);
            }
            catch (IOException ex) {
                LOGGER.throwing(JvmJvmstatModel.class.getName(), "getMainClass", ex);
            }
        }
        if (mainClassName.endsWith(JAR_SUFFIX)) {
            int index = (mainClassName = mainClassName.replace('\\', '/')).lastIndexOf(47);
            if (index != -1) {
                mainClassName = mainClassName.substring(index + 1);
            }
        } else if (MODULE_MAIN_CLASS_PATTERN.matcher(mainClassName).find()) {
            return mainClassName.substring(mainClassName.indexOf(47) + 1);
        }
        mainClassName = mainClassName.replace('\\', '/').replace('/', '.');
        return mainClassName;
    }

    private String getFirstArgument() {
        String classPath;
        String jarFile;
        String commandLine = this.getCommandLine();
        String mainClassName = null;
        if (commandLine == null) {
            return mainClassName;
        }
        int jarIndex = commandLine.indexOf(JAR_SUFFIX);
        if (jarIndex != -1 && ((jarFile = commandLine.substring(0, jarIndex + JAR_SUFFIX.length())).length() == commandLine.length() || commandLine.charAt(jarFile.length()) == ' ') && (classPath = this.getClassPath()) != null && classPath.contains(jarFile)) {
            mainClassName = jarFile;
        }
        if (mainClassName == null) {
            int firstSpace = commandLine.indexOf(32);
            mainClassName = firstSpace > 0 ? commandLine.substring(0, firstSpace) : commandLine;
        }
        return mainClassName;
    }

    public long getLoadedClasses() {
        return this.getLongValue(this.loadedClasses);
    }

    public long getSharedLoadedClasses() {
        return this.getLongValue(this.sharedLoadedClasses);
    }

    public long getSharedUnloadedClasses() {
        return this.getLongValue(this.sharedUnloadedClasses);
    }

    public long getUnloadedClasses() {
        return this.getLongValue(this.unloadedClasses);
    }

    public long getThreadsDaemon() {
        return this.getLongValue(this.threadsDaemon);
    }

    public long getThreadsLive() {
        return this.getLongValue(this.threadsLive);
    }

    public long getThreadsLivePeak() {
        return this.getLongValue(this.threadsLivePeak);
    }

    public long getThreadsStarted() {
        return this.getLongValue(this.threadsStarted);
    }

    public long getApplicationTime() {
        return this.getLongValue(this.applicationTime);
    }

    public long getUpTime() {
        return this.getLongValue(this.upTime);
    }

    public String[] getGenName() {
        return (String[])this.genName.clone();
    }

    public long[] getGenCapacity() {
        return this.getGenerationSum(this.genCapacity);
    }

    public long[] getGenUsed() {
        return this.getGenerationSum(this.genUsed);
    }

    public long[] getGenMaxCapacity() {
        return (long[])this.genMaxCapacity.clone();
    }

    public long getOsFrequency() {
        return this.osFrequency;
    }

    protected abstract String getPermGenPrefix();

    protected long getLongValue(MonitoredValue val) {
        if (val != null) {
            return (Long)val.getValue();
        }
        return 0L;
    }

    protected long[] getGenerationSum(List<MonitoredValue> values) {
        long[] results = new long[2];
        String prefix = this.getPermGenPrefix();
        for (MonitoredValue value : values) {
            if (value == null) continue;
            long val = this.getLongValue(value);
            if (value.getName().startsWith(prefix)) {
                results[1] = results[1] + val;
                continue;
            }
            results[0] = results[0] + val;
        }
        return results;
    }
}

