/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl;

import javax.swing.JComponent;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.TracerModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.details.DetailsPanel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.VisibilityHandler;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineSupport;

final class DetailsView {
    private final TimelineSupport timelineSupport;
    private DetailsPanel panel;
    private boolean hasData;
    private VisibilityHandler viewHandler;

    DetailsView(TracerModel model) {
        this.timelineSupport = model.getTimelineSupport();
    }

    void registerViewListener(VisibilityHandler viewHandler) {
        if (this.panel != null) {
            viewHandler.handle(this.panel);
        } else {
            this.viewHandler = viewHandler;
        }
    }

    boolean isShowing() {
        return this.panel != null && this.panel.isShowing();
    }

    boolean hasData() {
        return this.hasData;
    }

    JComponent getView() {
        this.panel = new DetailsPanel(this.timelineSupport);
        this.timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
            }
        });
        if (this.viewHandler != null) {
            this.viewHandler.handle(this.panel);
            this.viewHandler = null;
        }
        return this.panel;
    }
}

